/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturediagram;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentAnchor;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawFigure;
import org.eclipse.swt.graphics.Color;

abstract class UmlComponentAnchorFigure
extends DrawFigure {
    static final int WIDTH = 30;
    static final int HEIGHT = 11;
    protected static final int CIRCLE = 9;
    protected static final int LINE_WIDTH = 1;
    protected static final int BOX = 4;
    private Color m_backgroundColor;

    UmlComponentAnchorFigure() {
        this.minSize = this.maxSize = new Dimension(30, 11);
        this.prefSize = this.maxSize;
    }

    abstract UmlComponentAnchor<?> getUmlComponentAnchor();

    abstract Point getAnchorPoint(UmlComponent.DependencyType var1, UmlComponent.DependencyEndpoint var2);

    public final void setPreferredSize(Dimension size) {
    }

    public final void setMinimumSize(Dimension size) {
    }

    public final void setMaximumSize(Dimension size) {
    }

    protected abstract void performPaintFigure(Graphics var1, Color var2);

    protected final void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        int initialLineWidth = graphics.getLineWidth();
        Color initialBgColor = graphics.getBackgroundColor();
        this.performPaintFigure(graphics, this.m_backgroundColor);
        graphics.setLineWidth(initialLineWidth);
        graphics.setBackgroundColor(initialBgColor);
    }

    final boolean update() {
        Color newColor = null;
        if (this.getUmlComponentAnchor().isSelected()) {
            newColor = UiResourceManager.getInstance().getSelectionColor();
        } else if (this.getUmlComponentAnchor().isHighlighted()) {
            newColor = UiResourceManager.getInstance().getHighlightColor();
        }
        if (newColor != this.m_backgroundColor) {
            this.m_backgroundColor = newColor;
            this.revalidate();
            this.repaint();
            return true;
        }
        return false;
    }

    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(this.getUmlComponentAnchor().getDebugInfo());
        builder.append("\n");
        builder.append(super.getDebugInfo());
        return builder.toString();
    }
}

