/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.LayoutManager;
import com.hello2morrow.draw2d.MouseListener;
import com.hello2morrow.draw2d.MouseMotionListener;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawImageAndLabelFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import java.util.List;
import org.eclipse.swt.graphics.Image;

final class SecondaryTreeNodeFigure
extends TreeNodeFigure {
    private int m_index = -1;

    SecondaryTreeNodeFigure(ArchitecturalViewNode node, DrawNodeFigure.INodeFigureProvider<ArchitecturalViewNode> provider, int index) {
        super(node);
        assert (index >= 0) : "'index' must not be negative";
        this.m_index = index;
        this.initialize(provider);
    }

    SecondaryTreeNodeFigure(ArchitecturalViewNode node, DrawNodeFigure.INodeFigureProvider<ArchitecturalViewNode> connector) {
        super(node);
        this.initialize(connector);
    }

    void setIndex(int index) {
        assert (index >= 0) : "'index' must not be negative";
        this.m_index = index;
    }

    int getIndex() {
        return this.m_index;
    }

    protected void performInitialize(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'performInitialize' must not be null";
        this.setLayoutManager((LayoutManager)DrawUtilities.createGridLayout());
        Image image = UiResourceManager.getInstance().getImage((Element)node);
        DrawUtilities.checkImageDimension((Image)image, (String)("Node '" + String.valueOf(node) + "'"));
        DrawImageAndLabelFigure nodeLabel = new DrawImageAndLabelFigure(image, "");
        this.add((IFigure)nodeLabel);
        nodeLabel.addMouseListener((MouseListener)this);
        nodeLabel.addMouseMotionListener((MouseMotionListener)this);
    }

    protected boolean performUpdate(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'performUpdate' must not be null";
        List imageAndLabelFigures = DrawUtilities.findChildFigures(DrawImageAndLabelFigure.class, (IFigure)this);
        assert (imageAndLabelFigures.size() == 1) : "Exactly 1 image and label figure expected";
        Image image = UiResourceManager.getInstance().getImage((Element)node);
        if (((DrawImageAndLabelFigure)imageAndLabelFigures.get(0)).update(image, "")) {
            DrawUtilities.checkImageDimension((Image)image, (String)("Node '" + String.valueOf(this.getNode()) + "'"));
            return true;
        }
        return false;
    }
}

