/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.RenameElementCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.RenameElementInfo;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewHandler;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewMenuGroup;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionDialog;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public final class RenameElementHandler
extends ArchitecturalViewHandler {
    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public String getLabel(IWorkbenchView workbenchView, List<Element> currentSelection, String defaultLabel) {
                return "Rename Element...";
            }

            public IMenuGroup getMenuGroup() {
                return ArchitecturalViewMenuGroup.OTHER;
            }
        };
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.RENAME_ARCHITECTURAL_VIEW_ELEMENT;
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        ArchitecturalViewElement element;
        if (this.mayBeExecuted(selection) && (element = (ArchitecturalViewElement)RenameElementHandler.getSingleSelection(ArchitecturalViewElement.class, (List)selection.getElements(), (boolean)false)) != null) {
            return ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isRenameElementPossible(element) != null;
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        assert (WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) : "Not software system available";
        final ArchitecturalViewElement element = (ArchitecturalViewElement)RenameElementHandler.getSingleSelection(ArchitecturalViewElement.class, (List)selection.getElements(), (boolean)false);
        assert (element != null) : "Parameter 'element' of method 'execute' must not be null";
        RenameElementInfo info = ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isRenameElementPossible(element);
        assert (info != null) : "'validator' of method 'execute' must not be null";
        final NameAndDescriptionDialog dialog = new NameAndDescriptionDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "Rename Element (Refactoring)", info.getValidator(), info.getName(), null);
        if (dialog.open() == 0) {
            RenameElementCommand command = new RenameElementCommand(WorkbenchRegistry.getInstance().getProvider(), new RenameElementCommand.IRenameElementInteraction(){

                public boolean collect(RenameElementCommand.RenameElementData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.set(element, dialog.getName());
                    return true;
                }

                public void processRenameElementResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processHideElementsResult' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
    }
}

