/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.LayoutManager;
import com.hello2morrow.draw2d.MouseListener;
import com.hello2morrow.draw2d.MouseMotionListener;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewContentStepCalculator;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.SecondaryTreeNodeFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawExpandCollapseFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawImageAndLabelFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import java.util.List;
import org.eclipse.swt.graphics.Image;

final class PrimaryTreeNodeFigure
extends TreeNodeFigure {
    private final SecondaryTreeNodeFigure m_secondaryTreeNode;

    PrimaryTreeNodeFigure(ArchitecturalViewNode node, DrawNodeFigure.INodeFigureProvider<ArchitecturalViewNode> provider, SecondaryTreeNodeFigure secondaryTreeNode) {
        super(node);
        assert (node != null) : "Parameter 'node' of method 'PrimaryTreeNodeFigure' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'PrimaryTreeNodeFigure' must not be null";
        assert (secondaryTreeNode != null) : "Parameter 'secondaryTreeNode' of method 'PrimaryTreeNodeFigure' must not be null";
        this.m_secondaryTreeNode = secondaryTreeNode;
        this.initialize(provider);
    }

    SecondaryTreeNodeFigure getSecondaryTreeNode() {
        return this.m_secondaryTreeNode;
    }

    protected void performInitialize(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'performInitialize' must not be null";
        assert (!node.isExpanded() || node.isExpandable()) : "isExpanded but not isExpandable: " + node.getElementInfo();
        this.setLayoutManager((LayoutManager)DrawUtilities.createGridLayout((int)2));
        DrawExpandCollapseFigure collapseExpandFigure = new DrawExpandCollapseFigure(node.isExpandable(), node.isExpanded(), node.isExpandable() ? ArchitecturalViewContentStepCalculator.calculate(node) : -1);
        this.add((IFigure)collapseExpandFigure);
        if (node.isExpandable()) {
            collapseExpandFigure.addMouseListener((MouseListener)this);
        }
        Image image = UiResourceManager.getInstance().getImage((Element)node);
        DrawUtilities.checkImageDimension((Image)image, (String)("Node '" + String.valueOf(this.getNode()) + "'"));
        DrawImageAndLabelFigure nodeLabel = new DrawImageAndLabelFigure(image, node.getPresentationName(true));
        this.add((IFigure)nodeLabel);
        nodeLabel.addMouseListener((MouseListener)this);
        nodeLabel.addMouseMotionListener((MouseMotionListener)this);
    }

    protected boolean performUpdate(ArchitecturalViewNode node) {
        int contentStep;
        assert (node != null) : "Parameter 'node' of method 'performUpdate' must not be null";
        assert (!node.isExpanded() || node.isExpandable()) : "isExpanded but not isExpandable: " + node.getElementInfo();
        boolean updated = false;
        List expandCollapseFigures = DrawUtilities.findChildFigures(DrawExpandCollapseFigure.class, (IFigure)this);
        assert (expandCollapseFigures.size() == 1) : "Exactly 1 expand/collapse figure expected";
        DrawExpandCollapseFigure expandCollapseFigure = (DrawExpandCollapseFigure)expandCollapseFigures.get(0);
        if (expandCollapseFigure.isExpanded() != node.isExpanded()) {
            expandCollapseFigure.setIsExpanded(node.isExpanded());
            updated = true;
        }
        int n = contentStep = node.isExpandable() ? ArchitecturalViewContentStepCalculator.calculate(node) : -1;
        if (expandCollapseFigure.getContentStep() != contentStep) {
            expandCollapseFigure.setContentStep(contentStep);
            updated = true;
        }
        List imageAndLabelFigures = DrawUtilities.findChildFigures(DrawImageAndLabelFigure.class, (IFigure)this);
        assert (imageAndLabelFigures.size() == 1) : "Exactly 1 image and label figure expected";
        Image image = UiResourceManager.getInstance().getImage((Element)node);
        if (((DrawImageAndLabelFigure)imageAndLabelFigures.get(0)).update(image, node.getPresentationName(true))) {
            DrawUtilities.checkImageDimension((Image)image, (String)("Node '" + String.valueOf(this.getNode()) + "'"));
            updated = true;
        }
        return updated;
    }
}

