/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.LayoutListener;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ConnectedNodeBox;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationViewLayout;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.SecondaryTreeNodeFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.SelectedNodeBox;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeEdgeFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeEdgeFigureWeightDecorator;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeAndConnectionFigureCanvas;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class GestureHandler {
    private final Map<SecondaryTreeNodeFigure, SelectedNodeBox> m_secondaryTreeNodeFigureToSelectedNodeBox = new LinkedHashMap<SecondaryTreeNodeFigure, SelectedNodeBox>();
    private final Map<TreeEdgeFigure, TreeEdgeFigureWeightDecorator> m_selectedTreeEdgeFigureToDecorator = new LinkedHashMap<TreeEdgeFigure, TreeEdgeFigureWeightDecorator>();
    private final List<ConnectedNodeBox> m_connectedNodeBoxes = new ArrayList<ConnectedNodeBox>();
    private final DrawNodeAndConnectionFigureCanvas<ArchitecturalViewNode, ArchitecturalViewNode.ArchitecturalViewDependency, ExplorationViewLayout> m_canvas;
    private final SelectionProviderAdapter m_selectionProviderAdapter;
    private final ExplorationViewRepresentation m_representation;
    private SecondaryTreeNodeFigure m_lastSelectedSecondaryTreeNodeFigure;

    GestureHandler(DrawNodeAndConnectionFigureCanvas<ArchitecturalViewNode, ArchitecturalViewNode.ArchitecturalViewDependency, ExplorationViewLayout> figureWidget, SelectionProviderAdapter selectionProviderAdapter, ExplorationViewRepresentation representation) {
        assert (figureWidget != null) : "Parameter 'figureWidget' of method 'GestureHandler' must not be null";
        assert (selectionProviderAdapter != null) : "Parameter 'selectionProviderAdapter' of method 'GestureHandler' must not be null";
        this.m_canvas = figureWidget;
        this.m_selectionProviderAdapter = selectionProviderAdapter;
        this.m_representation = representation;
    }

    public void selectNodes(List<SecondaryTreeNodeFigure> select, boolean updateModel) {
        assert (select != null && !select.isEmpty()) : "Parameter 'select' of method 'selectNodes' must not be empty";
        for (SecondaryTreeNodeFigure next : select) {
            if (this.m_secondaryTreeNodeFigureToSelectedNodeBox.containsKey((Object)next)) continue;
            SelectedNodeBox selectionBox = new SelectedNodeBox((ExplorationViewLayout)this.m_canvas.getCanvasLayout(), next);
            this.m_secondaryTreeNodeFigureToSelectedNodeBox.put(next, selectionBox);
            this.m_canvas.addToFirstFloorLayer((IFigure)selectionBox);
            this.m_canvas.addLayoutListener((LayoutListener)selectionBox);
            if (!updateModel) continue;
            ((ArchitecturalViewNode)next.getNode()).setSelected(true);
            next.invalidate();
        }
    }

    void selectEdges(List<TreeEdgeFigure> select, boolean updateModel) {
        assert (select != null && !select.isEmpty()) : "Parameter 'select' of method 'selectEdges' must not be empty";
        for (TreeEdgeFigure next : select) {
            if (this.m_selectedTreeEdgeFigureToDecorator.containsKey((Object)next)) continue;
            TreeEdgeFigureWeightDecorator decorator = new TreeEdgeFigureWeightDecorator(next);
            this.m_selectedTreeEdgeFigureToDecorator.put(next, decorator);
            this.m_canvas.addToAtticLayer((IFigure)decorator);
            if (!updateModel) continue;
            ((ArchitecturalViewNode.ArchitecturalViewDependency)next.getConnection()).setSelected(true);
            next.invalidate();
        }
    }

    void clearNodeSelection(SecondaryTreeNodeFigure secondaryTreeNodeFigure, boolean assureWasSelected, boolean updateModel) {
        assert (secondaryTreeNodeFigure != null) : "Parameter 'secondaryTreeNodeFigure' of method 'clearNodeSelection' must not be null";
        SelectedNodeBox selectionBox = this.m_secondaryTreeNodeFigureToSelectedNodeBox.remove((Object)secondaryTreeNodeFigure);
        assert (!assureWasSelected || selectionBox != null) : "'selectionBox' of method 'clearNodeSelection' must not be null";
        if (selectionBox != null) {
            if (updateModel) {
                ((ArchitecturalViewNode)secondaryTreeNodeFigure.getNode()).setSelected(false);
            }
            this.m_canvas.removeFromFirstFloorLayer((IFigure)selectionBox);
            secondaryTreeNodeFigure.invalidate();
        }
    }

    boolean clearEdgeSelection(TreeEdgeFigure treeEdgeFigure) {
        assert (treeEdgeFigure != null) : "Parameter 'treeEdgeFigure' of method 'clearEdgeSelection' must not be null";
        TreeEdgeFigureWeightDecorator decorator = this.m_selectedTreeEdgeFigureToDecorator.remove((Object)treeEdgeFigure);
        if (decorator != null) {
            treeEdgeFigure.invalidate();
            ((ArchitecturalViewNode.ArchitecturalViewDependency)treeEdgeFigure.getConnection()).setSelected(false);
            this.m_canvas.removeFromAtticLayer((IFigure)decorator);
            return true;
        }
        return false;
    }

    boolean clearSelection(boolean updateModel) {
        boolean cleared = false;
        if (!this.m_secondaryTreeNodeFigureToSelectedNodeBox.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.m_secondaryTreeNodeFigureToSelectedNodeBox.entrySet()) {
                SecondaryTreeNodeFigure nextSecondaryTreeNodeFigure = (SecondaryTreeNodeFigure)((Object)entry.getKey());
                if (updateModel) {
                    ((ArchitecturalViewNode)nextSecondaryTreeNodeFigure.getNode()).setSelected(false);
                    nextSecondaryTreeNodeFigure.invalidate();
                }
                this.m_canvas.removeFromFirstFloorLayer((IFigure)entry.getValue());
            }
            this.m_secondaryTreeNodeFigureToSelectedNodeBox.clear();
            cleared = true;
        }
        if (!this.m_selectedTreeEdgeFigureToDecorator.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.m_selectedTreeEdgeFigureToDecorator.entrySet()) {
                TreeEdgeFigure nextTreeEdgeFigure = (TreeEdgeFigure)((Object)entry.getKey());
                if (updateModel) {
                    nextTreeEdgeFigure.invalidate();
                    ((ArchitecturalViewNode.ArchitecturalViewDependency)nextTreeEdgeFigure.getConnection()).setSelected(false);
                }
                this.m_canvas.removeFromAtticLayer((IFigure)entry.getValue());
            }
            this.m_selectedTreeEdgeFigureToDecorator.clear();
            cleared = true;
        }
        return cleared;
    }

    int getNumberOfSelectedNodes() {
        return this.m_secondaryTreeNodeFigureToSelectedNodeBox.size();
    }

    List<SecondaryTreeNodeFigure> getSelectedSecondaryTreeNodeFigures() {
        return new ArrayList<SecondaryTreeNodeFigure>(this.m_secondaryTreeNodeFigureToSelectedNodeBox.keySet());
    }

    List<ArchitecturalViewNode> getSelectedNodes() {
        return this.m_secondaryTreeNodeFigureToSelectedNodeBox.keySet().stream().map(s -> (ArchitecturalViewNode)s.getNode()).collect(Collectors.toList());
    }

    int getNumberOfSelectedEdges() {
        return this.m_selectedTreeEdgeFigureToDecorator.size();
    }

    List<Element> getSelectedElements() {
        if (this.m_secondaryTreeNodeFigureToSelectedNodeBox.isEmpty() && this.m_selectedTreeEdgeFigureToDecorator.isEmpty()) {
            return Collections.singletonList(this.m_representation);
        }
        ArrayList<Element> selected = new ArrayList<Element>();
        if (!this.m_secondaryTreeNodeFigureToSelectedNodeBox.isEmpty()) {
            selected.addAll(this.m_secondaryTreeNodeFigureToSelectedNodeBox.keySet().stream().map(s -> (ArchitecturalViewNode)s.getNode()).collect(Collectors.toList()));
        }
        if (!this.m_selectedTreeEdgeFigureToDecorator.isEmpty()) {
            selected.addAll(this.m_selectedTreeEdgeFigureToDecorator.keySet().stream().map(s -> (ArchitecturalViewNode.ArchitecturalViewDependency)s.getConnection()).collect(Collectors.toList()));
        }
        return selected;
    }

    boolean hasSelection() {
        return !this.m_selectedTreeEdgeFigureToDecorator.isEmpty() || !this.m_secondaryTreeNodeFigureToSelectedNodeBox.isEmpty();
    }

    private void placeEdgeOnTop(TreeEdgeFigure edgeFigure) {
        assert (edgeFigure != null) : "Parameter 'edgeFigure' of method 'placeEdgeOnTop' must not be null";
        IFigure parent = edgeFigure.getParent();
        parent.remove((IFigure)edgeFigure);
        parent.add((IFigure)edgeFigure);
    }

    private void finishSelectionGesture() {
        this.m_connectedNodeBoxes.forEach(c -> this.m_canvas.removeFromFirstFloorLayer((IFigure)c));
        this.m_connectedNodeBoxes.clear();
        List edgeFigures = this.m_canvas.getConnectionFigures();
        if (this.m_selectedTreeEdgeFigureToDecorator.isEmpty() && this.m_secondaryTreeNodeFigureToSelectedNodeBox.isEmpty()) {
            this.m_lastSelectedSecondaryTreeNodeFigure = null;
            this.m_selectionProviderAdapter.handleSelectionChanged((Element)this.m_representation);
        } else {
            DrawNodeFigure toNodeFigure;
            THashSet connected = new THashSet();
            if (!this.m_selectedTreeEdgeFigureToDecorator.isEmpty()) {
                for (Map.Entry<TreeEdgeFigure, TreeEdgeFigureWeightDecorator> nextEntry : this.m_selectedTreeEdgeFigureToDecorator.entrySet()) {
                    TreeEdgeFigure next = nextEntry.getKey();
                    DrawNodeFigure fromNodeFigure = (DrawNodeFigure)next.getSourceAnchor().getOwner();
                    assert (fromNodeFigure != null && fromNodeFigure instanceof SecondaryTreeNodeFigure) : "Unexpected class in method 'finishSelectionGesture': " + String.valueOf(fromNodeFigure);
                    toNodeFigure = (DrawNodeFigure)next.getTargetAnchor().getOwner();
                    assert (toNodeFigure != null && toNodeFigure instanceof SecondaryTreeNodeFigure) : "Unexpected class in method 'finishSelectionGesture': " + String.valueOf(toNodeFigure);
                    if (!this.m_secondaryTreeNodeFigureToSelectedNodeBox.containsKey(fromNodeFigure)) {
                        connected.add((SecondaryTreeNodeFigure)fromNodeFigure);
                    }
                    if (!this.m_secondaryTreeNodeFigureToSelectedNodeBox.containsKey(toNodeFigure)) {
                        connected.add((SecondaryTreeNodeFigure)toNodeFigure);
                    }
                    this.placeEdgeOnTop(next);
                    next.update();
                    nextEntry.getValue().update(next);
                }
            }
            if (!this.m_secondaryTreeNodeFigureToSelectedNodeBox.isEmpty()) {
                for (DrawConnectionFigure nextEdgeFigure : edgeFigures) {
                    assert (nextEdgeFigure instanceof TreeEdgeFigure) : "Unexpected class in method 'finishSelectionGesture': " + String.valueOf(nextEdgeFigure);
                    DrawNodeFigure fromNodeFigure = (DrawNodeFigure)((TreeEdgeFigure)nextEdgeFigure).getSourceAnchor().getOwner();
                    assert (fromNodeFigure != null && fromNodeFigure instanceof SecondaryTreeNodeFigure) : "Unexpected class in method 'finishSelectionGesture': " + String.valueOf(fromNodeFigure);
                    ArchitecturalViewNode fromNode = (ArchitecturalViewNode)((SecondaryTreeNodeFigure)fromNodeFigure).getNode();
                    toNodeFigure = (DrawNodeFigure)((TreeEdgeFigure)nextEdgeFigure).getTargetAnchor().getOwner();
                    assert (toNodeFigure != null && toNodeFigure instanceof SecondaryTreeNodeFigure) : "Unexpected class in method 'finishSelectionGesture': " + String.valueOf(toNodeFigure);
                    ArchitecturalViewNode toNode = (ArchitecturalViewNode)((SecondaryTreeNodeFigure)toNodeFigure).getNode();
                    boolean fromNodeSelected = fromNode.isSelected();
                    boolean toNodeSelected = toNode.isSelected();
                    boolean fromNodeParentSelected = fromNode.isParentSelected();
                    boolean toNodeParentSelected = toNode.isParentSelected();
                    if (!fromNodeSelected && !toNodeSelected && !fromNodeParentSelected && !toNodeParentSelected) continue;
                    this.placeEdgeOnTop((TreeEdgeFigure)nextEdgeFigure);
                    if (!fromNodeSelected && !fromNodeParentSelected) {
                        connected.add((SecondaryTreeNodeFigure)fromNodeFigure);
                    }
                    if (toNodeSelected || toNodeParentSelected) continue;
                    connected.add((SecondaryTreeNodeFigure)toNodeFigure);
                }
            }
            for (SecondaryTreeNodeFigure nextConnected : connected) {
                ConnectedNodeBox nextBox = new ConnectedNodeBox((ExplorationViewLayout)this.m_canvas.getCanvasLayout(), nextConnected);
                this.m_connectedNodeBoxes.add(nextBox);
                this.m_canvas.addToFirstFloorLayer((IFigure)nextBox);
                this.m_canvas.addLayoutListener((LayoutListener)nextBox);
            }
            ArrayList<Element> selected = new ArrayList<Element>();
            if (!this.m_secondaryTreeNodeFigureToSelectedNodeBox.isEmpty()) {
                for (SecondaryTreeNodeFigure secondaryTreeNodeFigure : this.m_secondaryTreeNodeFigureToSelectedNodeBox.keySet()) {
                    selected.add((Element)secondaryTreeNodeFigure.getNode());
                    this.m_lastSelectedSecondaryTreeNodeFigure = secondaryTreeNodeFigure;
                }
            }
            if (!this.m_selectedTreeEdgeFigureToDecorator.isEmpty()) {
                for (TreeEdgeFigure treeEdgeFigure : this.m_selectedTreeEdgeFigureToDecorator.keySet()) {
                    selected.add((Element)treeEdgeFigure.getConnection());
                }
            }
            this.m_selectionProviderAdapter.handleSelectionChanged(selected);
        }
        edgeFigures.forEach(e -> e.revalidate());
    }

    void aboutToExpandOrCollapse() {
        this.m_selectionProviderAdapter.handleSelectionChanged();
    }

    void updateSelectionState() {
        this.finishSelectionGesture();
    }

    void handleNonShiftBasedNodeClick(SecondaryTreeNodeFigure clicked, boolean primaryKeyPressed) {
        assert (clicked != null) : "Parameter 'clicked' of method 'handleNonShiftBasedNodeClick' must not be null";
        boolean clear = false;
        SecondaryTreeNodeFigure add = null;
        if (this.m_secondaryTreeNodeFigureToSelectedNodeBox.containsKey((Object)clicked)) {
            if (primaryKeyPressed) {
                this.clearNodeSelection(clicked, true, true);
            } else {
                clear = true;
                add = clicked;
            }
        } else {
            if (!primaryKeyPressed) {
                clear = true;
            }
            add = clicked;
        }
        if (clear) {
            this.clearSelection(true);
        }
        if (add != null) {
            this.selectNodes(Collections.singletonList(add), true);
        }
        this.finishSelectionGesture();
    }

    void handleShiftNodeClick(SecondaryTreeNodeFigure clicked) {
        assert (clicked != null) : "Parameter 'clicked' of method 'handleShiftNodeClick' must not be null";
        if (!this.m_secondaryTreeNodeFigureToSelectedNodeBox.isEmpty()) {
            ArrayList<SecondaryTreeNodeFigure> add = new ArrayList<SecondaryTreeNodeFigure>();
            int index = clicked.getIndex();
            SecondaryTreeNodeFigure nearestSelected = null;
            for (SecondaryTreeNodeFigure next : this.m_secondaryTreeNodeFigureToSelectedNodeBox.keySet()) {
                if (nearestSelected == null) {
                    nearestSelected = next;
                    continue;
                }
                int currentNearestIndex = nearestSelected.getIndex();
                int nextIndex = next.getIndex();
                if (Math.abs(index - nextIndex) >= Math.abs(index - currentNearestIndex)) continue;
                nearestSelected = next;
            }
            assert (nearestSelected != null) : "'nearestSelected' of method 'handleShiftNodeClick' must not be null";
            int startIndex = 0;
            int endIndex = 0;
            if (index < nearestSelected.getIndex()) {
                startIndex = index * 2;
                endIndex = nearestSelected.getIndex() * 2;
            } else {
                startIndex = nearestSelected.getIndex() * 2;
                endIndex = index * 2;
            }
            List nodes = this.m_canvas.getNodeFigures();
            int i = startIndex;
            while (i < endIndex + 2) {
                DrawNodeFigure nextNodeFigure = (DrawNodeFigure)nodes.get(i);
                if (nextNodeFigure instanceof SecondaryTreeNodeFigure) {
                    add.add((SecondaryTreeNodeFigure)nextNodeFigure);
                }
                ++i;
            }
            this.clearSelection(true);
            this.selectNodes(add, true);
            this.finishSelectionGesture();
        }
    }

    private void finishShiftUpOrDownGesture(List<DrawNodeFigure<ArchitecturalViewNode>> nodes, SecondaryTreeNodeFigure nextInDirectionToBeSelected) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'finishShiftUpOrDownGesture' must not be empty";
        assert (nextInDirectionToBeSelected != null) : "Parameter 'nextInDirectionToBeSelected' of method 'finishShiftUpOrDownGesture' must not be null";
        if (!this.m_secondaryTreeNodeFigureToSelectedNodeBox.containsKey((Object)nextInDirectionToBeSelected)) {
            this.selectNodes(Collections.singletonList(nextInDirectionToBeSelected), true);
            this.finishSelectionGesture();
        } else {
            if (this.m_lastSelectedSecondaryTreeNodeFigure != null) {
                this.clearNodeSelection(this.m_lastSelectedSecondaryTreeNodeFigure, true, true);
            }
            this.finishSelectionGesture();
        }
    }

    void handleNonShiftBasedEdgeClick(TreeEdgeFigure treeEdgeFigure, boolean primaryKeyPressed) {
        assert (treeEdgeFigure != null) : "Parameter 'treeEdgeFigure' of method 'handleNonShiftBasedEdgeClick' must not be null";
        if (primaryKeyPressed) {
            if (!this.clearEdgeSelection(treeEdgeFigure)) {
                this.selectEdges(Collections.singletonList(treeEdgeFigure), true);
            }
        } else {
            this.clearSelection(true);
            this.selectEdges(Collections.singletonList(treeEdgeFigure), true);
        }
        this.finishSelectionGesture();
    }

    boolean handleArrowUp(boolean withShift) {
        int lastSelectedIndex;
        if (this.m_lastSelectedSecondaryTreeNodeFigure != null && (lastSelectedIndex = this.m_lastSelectedSecondaryTreeNodeFigure.getIndex()) > 0) {
            List nodes = this.m_canvas.getNodeFigures();
            assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'handleUp' must not be empty";
            int addIndex = (lastSelectedIndex - 1) * 2 + 1;
            DrawNodeFigure nodeFigure = (DrawNodeFigure)nodes.get(addIndex);
            assert (nodeFigure instanceof SecondaryTreeNodeFigure) : "Unexpected class in method 'handleUp': " + String.valueOf(nodeFigure);
            if (withShift) {
                this.finishShiftUpOrDownGesture(nodes, (SecondaryTreeNodeFigure)nodeFigure);
            } else {
                this.clearSelection(true);
                this.selectNodes(Collections.singletonList((SecondaryTreeNodeFigure)nodeFigure), true);
                this.finishSelectionGesture();
            }
            this.m_canvas.revealNode(nodeFigure);
            return true;
        }
        return false;
    }

    boolean handleArrowDown(boolean withShift) {
        if (this.m_lastSelectedSecondaryTreeNodeFigure != null) {
            List nodes = this.m_canvas.getNodeFigures();
            assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'handleDown' must not be empty";
            int lastSelectedIndex = this.m_lastSelectedSecondaryTreeNodeFigure.getIndex();
            int lastNodeIndex = (lastSelectedIndex + 1) * 2;
            if (lastNodeIndex < nodes.size() - 1) {
                int addIndex = lastNodeIndex + 1;
                DrawNodeFigure nodeFigure = (DrawNodeFigure)nodes.get(addIndex);
                assert (nodeFigure instanceof SecondaryTreeNodeFigure) : "Unexpected class in method 'handleDown': " + String.valueOf(nodeFigure);
                if (withShift) {
                    this.finishShiftUpOrDownGesture(nodes, (SecondaryTreeNodeFigure)nodeFigure);
                } else {
                    this.clearSelection(true);
                    this.selectNodes(Collections.singletonList((SecondaryTreeNodeFigure)nodeFigure), true);
                    this.finishSelectionGesture();
                }
                this.m_canvas.revealNode(nodeFigure);
                return true;
            }
        }
        return false;
    }

    boolean handleNoNodeOrEdgeClicked() {
        if (this.clearSelection(true)) {
            this.finishSelectionGesture();
            return true;
        }
        return false;
    }
}

