/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ApplyFocusOperationCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.LoadArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.LoadArchitecturalViewOnDemandCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.RevealCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.SetPresentationModeCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.SetSortModeCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewLoadedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewSplitEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewUnloadedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusRequest;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOnDemand;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOperationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewBaseProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.IExplorationViewRepresentationOwner;
import com.hello2morrow.sonargraph.core.model.explorationview.RevealRequest;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.export.IExportProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpRegistry;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewFigureProvider;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationViewLayout;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.FocusDialog;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.IArchitecturalViewSettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.OpenOnDemandAdvancedDialog;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.SearchInArchitecturalViewDialog;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeAndConnectionFigureCanvas;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeAndConnectionFigureCanvasLayout;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithHome;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithZoom;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.CanvasImageExporter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ExplorationViewShowInViewRequest;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class ExplorationView
extends WorkbenchSlaveView
implements IViewWithZoom,
IViewWithHome,
IArchitecturalViewSettingsProvider {
    private DrawNodeAndConnectionFigureCanvas<ArchitecturalViewNode, ArchitecturalViewNode.ArchitecturalViewDependency, ExplorationViewLayout> m_canvas;
    private ArchitecturalViewFigureProvider m_figureProvider;
    private IExplorationViewRepresentationOwner m_owner;
    private boolean m_isInitialNavigationState = true;
    private boolean m_autoExpand = true;
    private PresentationMode m_presentationMode = PresentationMode.MIXED;
    private ISortModeListener m_sortModeListener;

    public IViewId getViewId() {
        return ViewId.EXPLORATION_VIEW;
    }

    protected EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.allOf(WorkbenchView.EventCategory.class);
    }

    protected boolean supportsSleep() {
        return false;
    }

    public Search supportsSearch() {
        if (this.m_figureProvider == null) {
            return Search.NONE;
        }
        return this.getSoftwareSystemProvider().hasSoftwareSystem() && CommandRegistry.getInstance().isCommandLicensed((ICommandId)CoreCommandId.SEARCH_IN_EXPLORATION_VIEW) ? Search.FIND_ELEMENTS : Search.NONE;
    }

    public boolean showSearchInContextMenu(List<Element> selection) {
        assert (selection != null) : "Parameter 'selection' of method 'showSearchInContextMenu' must not be null";
        return true;
    }

    IExplorationViewRepresentationOwner getOwner() {
        return this.m_owner;
    }

    public String getPresentationName() {
        if (this.m_owner == null) {
            return "Exploration View";
        }
        return (this.m_owner.getOperationMode().isArchitectureModelling() ? "Architectural" : "Exploration") + " View [" + this.m_owner.getId() + "]";
    }

    protected void searchElementsRequested() {
        RevealRequest request;
        List selected;
        assert (this.m_owner != null) : "'m_file' of method 'searchElementsRequested' must not be null";
        assert (this.m_figureProvider != null) : "Parameter 'm_figureProvider' of method 'searchElementsRequested' must not be null";
        ISoftwareSystemProvider softwareSystemProvider = this.getSoftwareSystemProvider();
        assert (softwareSystemProvider.hasSoftwareSystem()) : "No system available";
        IArchitecturalViewProvider architecturalViewProvider = (IArchitecturalViewProvider)softwareSystemProvider.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class);
        List nodes = architecturalViewProvider.getSearchInNodes(this.getSelectedElements());
        String title = Search.FIND_ELEMENTS.getLabel() + " In " + (this.m_owner.getOperationMode().isArchitectureModelling() ? "Architectural" : "Exploration") + " View [" + this.m_owner.getId() + "]";
        SearchInArchitecturalViewDialog dialog = new SearchInArchitecturalViewDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), title, softwareSystemProvider, architecturalViewProvider, nodes, this.m_figureProvider.getRepresentation());
        if (dialog.open() == 0 && !(selected = dialog.getSelected()).isEmpty() && (request = architecturalViewProvider.getRevealRequest(selected, dialog.forceFocus())) != null) {
            RevealCommand command = new RevealCommand(softwareSystemProvider, new RevealCommand.IRevealInteraction(){

                public boolean collect(RevealCommand.RevealData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.setRequest(request);
                    return true;
                }

                public boolean collect(final ExplorationViewFocusProperties properties) {
                    if (!$assertionsDisabled && properties == null) {
                        throw new AssertionError((Object)"Parameter 'properties' of method 'collect' must not be null");
                    }
                    RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

                        public void run() {
                            FocusDialog dialog = new FocusDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), properties);
                            if (dialog.open() == 0) {
                                this.setResult(Boolean.TRUE);
                            } else {
                                this.setResult(Boolean.FALSE);
                            }
                        }
                    };
                    UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
                    return (Boolean)runnable.getResult();
                }
            });
            assert (command.isEnabled().isSuccess()) : "Not enabled: " + String.valueOf(command);
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
    }

    public boolean supportsImageExport() {
        return this.m_owner != null && this.m_canvas != null && this.m_figureProvider != null;
    }

    public String getExportImageSourceInfo() {
        return (this.m_owner.getOperationMode().isArchitectureModelling() ? "Architectural" : "Exploration") + " View [" + this.m_owner.getId() + "]";
    }

    public String getInitialExportImageName() {
        assert (this.m_owner != null) : "Parameter 'm_file' of method 'getInitialExportImageName' must not be null";
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        assert (softwareSystem != null) : "'softwareSystem' of method 'getInitialExportImageName' must not be null";
        return ((IArchitecturalViewProvider)softwareSystem.getExtension(IArchitecturalViewProvider.class)).getExportNameProposal(this.m_owner);
    }

    public OperationResult exportToImage(TFile targetFile) {
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportImage' must not be null";
        return CanvasImageExporter.exportToImage(this.m_canvas, (TFile)targetFile);
    }

    public NamedElement getLinkNamedElement(Element element) {
        return element instanceof ArchitecturalViewElement ? ((ArchitecturalViewElement)element).getFirstUnderlyingElement() : null;
    }

    public List<Control> getControlsForInteraction() {
        assert (this.m_canvas != null) : "'m_figureWidget' of method 'getControlsForInteraction' must not be null";
        return Collections.singletonList(this.m_canvas);
    }

    public ArchitecturalViewFile getModifiableFile() {
        return this.m_owner instanceof ArchitecturalViewFile ? (ArchitecturalViewFile)this.m_owner : null;
    }

    public List<Element> getSelectedElements() {
        return this.m_figureProvider == null ? Collections.emptyList() : new ArrayList<Element>(this.m_figureProvider.getSelectedElements());
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.m_canvas = new DrawNodeAndConnectionFigureCanvas(viewContentArea, (DrawNodeAndConnectionFigureCanvasLayout)new ExplorationViewLayout());
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewLoadedEvent>(ArchitecturalViewLoadedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewLoadedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ExplorationView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOwner() == ExplorationView.this.m_owner) {
                    if (ExplorationView.this.m_owner instanceof ExplorationViewOnDemand) {
                        ExplorationView.this.createRepresentation(null, ((ExplorationViewOnDemand)ExplorationView.this.m_owner).getNodeToBeRevealed());
                    } else {
                        ExplorationView.this.createRepresentation(null, null);
                    }
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewModifiedEvent>(ArchitecturalViewModifiedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ExplorationView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOwner() == ExplorationView.this.m_owner && ExplorationView.this.m_figureProvider != null) {
                    WorkbenchRegistry.getInstance().updatePartNameForModifiableFileState(ExplorationView.this.getPart(), ExplorationView.this.m_owner.getId());
                    ExplorationView.this.representationModified(event.getModification());
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewUnloadedEvent>(ArchitecturalViewUnloadedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewUnloadedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ExplorationView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOwner() == ExplorationView.this.m_owner) {
                    ExplorationView.this.resetPartName();
                    ExplorationView.this.hideView();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewSplitEvent>(ArchitecturalViewSplitEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewSplitEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ExplorationView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOwner() == ExplorationView.this.m_owner) {
                    ExplorationView.this.setOwner((IExplorationViewRepresentationOwner)event.getCreatedFile());
                    String identifyingPath = ExplorationView.this.m_owner.getId();
                    String secondaryId = ExplorationView.this.getSecondaryId();
                    if (!($assertionsDisabled || secondaryId != null && secondaryId.length() > 0)) {
                        throw new AssertionError((Object)"'secondaryId' of method 'handleEvent' must not be empty");
                    }
                    ViewNavigationManager.getInstance().changeSecondaryId(ExplorationView.this.getViewId(), secondaryId, identifyingPath);
                    ExplorationView.this.setSecondaryId(identifyingPath);
                    ExplorationView.this.setTitleTooltip(identifyingPath);
                    WorkbenchRegistry.getInstance().updatePartNameForModifiableFileState(ExplorationView.this.getPart(), ExplorationView.this.m_owner.getId());
                    ExplorationView.this.createRepresentation(null, null);
                    if (WorkbenchRegistry.getInstance().getCurrentlySelectedView() == ExplorationView.this) {
                        ExplorationView.this.getSelectionProviderAdapter().handleSelectionChanged(ExplorationView.this.getSelectedElements());
                    }
                }
            }
        });
        this.m_canvas.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'mouseScrolled' must not be null");
                }
                if ((event.stateMask & SWT.MOD1) != 0) {
                    if (event.count < 0) {
                        if (ExplorationView.this.zoomOutPossible()) {
                            ExplorationView.this.zoomOut(null);
                        }
                    } else if (event.count > 0 && ExplorationView.this.zoomInPossible()) {
                        ExplorationView.this.zoomIn(null);
                    }
                }
            }
        });
    }

    protected void destroyViewContent() {
        IArchitecturalViewBaseProvider provider;
        EventManager.getInstance().detach(ArchitecturalViewLoadedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewUnloadedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewSplitEvent.class, (Object)this);
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem != null && this.m_owner != null && (provider = (IArchitecturalViewBaseProvider)softwareSystem.getExtension(IArchitecturalViewBaseProvider.class)).hasBeenLoaded(this.m_owner)) {
            provider.unload(this.m_owner);
        }
        this.setOwner(null);
        if (this.m_figureProvider != null) {
            this.m_figureProvider.delete();
            this.m_figureProvider = null;
        }
        if (this.m_canvas != null) {
            this.m_canvas.dispose();
            this.m_canvas = null;
        }
        IEclipsePreferences settings = this.getPreferences();
        PreferencesUtility.save((IEclipsePreferences)settings);
        super.destroyViewContent();
    }

    public IContext getContext() {
        ExplorationViewRepresentation representation;
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem != null && this.m_figureProvider != null && (representation = this.m_figureProvider.getRepresentation()) != null && representation.isValid()) {
            return ((IArchitecturalViewBaseProvider)softwareSystem.getExtension(IArchitecturalViewBaseProvider.class)).getContext(representation);
        }
        return super.getContext();
    }

    private ExplorationViewFocusRequest getFocusRequest(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getFocusRequest' must not be null";
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        if (element instanceof ArchitecturalViewNode) {
            ArrayList dependencies = new ArrayList(((ArchitecturalViewNode)element).getIncomingDependencies());
            dependencies.addAll(((ArchitecturalViewNode)element).getOutgoingDependencies());
            if (!dependencies.isEmpty()) {
                return new ExplorationViewFocusRequest(((IArchitecturalViewBaseProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewBaseProvider.class)).getArchitecturalViewRepresentation(dependencies), Collections.emptyList(), dependencies);
            }
        } else if (element instanceof ArchitecturalViewNode.ArchitecturalViewDependency) {
            return new ExplorationViewFocusRequest(((IArchitecturalViewBaseProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewBaseProvider.class)).getArchitecturalViewRepresentation(Collections.singletonList((ArchitecturalViewNode.ArchitecturalViewDependency)element)), Collections.emptyList(), Collections.singletonList((ArchitecturalViewNode.ArchitecturalViewDependency)element));
        }
        return null;
    }

    public boolean doubleClicked(Element element) {
        assert (element != null) : "Parameter 'element' of method 'doubleClicked' must not be null";
        final ExplorationViewFocusRequest focusRequest = this.getFocusRequest(element);
        if (focusRequest != null) {
            ApplyFocusOperationCommand command = new ApplyFocusOperationCommand(WorkbenchRegistry.getInstance().getProvider(), new ApplyFocusOperationCommand.IApplyFocusOperationInteraction(){

                public boolean collect(ApplyFocusOperationCommand.FocusOperationtData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.set(ExplorationViewFocusProperties.FocusType.SET_FOCUS, focusRequest);
                    return true;
                }

                public boolean collect(ExplorationViewFocusProperties properties) {
                    if (!$assertionsDisabled && properties == null) {
                        throw new AssertionError((Object)"Parameter 'properties' of method 'collect' must not be null");
                    }
                    properties.setExpandToAssignableToArtifactLevel(true);
                    return true;
                }

                public void processApplyResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processApplyResult' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
        return true;
    }

    public boolean supportMouseWheelZoom() {
        return false;
    }

    public boolean zoomInPossible() {
        return this.m_canvas.zoomInPossible();
    }

    public void zoomIn(Point location) {
        this.m_canvas.zoomIn();
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    public boolean zoomOutPossible() {
        return this.m_canvas.zoomOutPossible();
    }

    public void zoomOut(Point location) {
        this.m_canvas.zoomOut();
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    private void createRepresentation(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger, ArchitecturalViewNode reveal) {
        assert (this.m_canvas != null) : "Parameter 'm_figureWidget' of method 'createRepresentation' must not be null";
        assert (this.m_owner != null) : "Parameter 'm_file' of method 'createRepresentation' must not be null";
        this.m_canvas.setRedraw(false);
        this.m_canvas.clear();
        boolean initialCreation = true;
        if (this.m_figureProvider != null) {
            this.m_figureProvider.delete();
            this.m_figureProvider = null;
            initialCreation = false;
        }
        ExplorationViewRepresentation representation = (ExplorationViewRepresentation)this.m_owner.getNamedElement().getUniqueExistingChild(ExplorationViewRepresentation.class);
        this.m_figureProvider = new ArchitecturalViewFigureProvider(this.getViewId(), this.getSecondaryId(), this.getElementInteractor(), this.getSelectionProviderAdapter(), this.getSoftwareSystemProvider(), this.m_canvas, representation, reveal);
        this.m_figureProvider.enableAutoExpand(this.m_autoExpand);
        this.m_canvas.setRedraw(true);
        if (initialCreation) {
            WorkbenchRegistry.getInstance().selectView((IWorkbenchView)this);
        }
        this.m_figureProvider.handleModification(trigger, initialCreation);
        this.m_presentationMode = representation.getPresentationMode();
        if (this.m_sortModeListener != null) {
            this.m_sortModeListener.modified(representation.getOperationMode(), representation.getSupportedSortModes(), representation.getSortMode());
        }
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    private void representationModified(ArchitecturalViewModifiedEvent.ArchitecturalViewModification modification) {
        assert (modification != null) : "Parameter 'modification' of method 'representationModified' must not be null";
        assert (this.m_figureProvider != null) : "'m_figureProvider' of method 'representationModified' must not be null";
        ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger = modification.getTrigger();
        if (trigger.structureModified()) {
            this.createRepresentation(trigger, modification.getReveal());
        } else {
            this.m_figureProvider.update(trigger);
        }
    }

    private void setOwner(IExplorationViewRepresentationOwner owner) {
        if (this.m_owner != owner) {
            if (this.m_owner != null) {
                HelpRegistry.getInstance().unregister((Object)this);
            }
            this.m_owner = owner;
            if (this.m_owner != null) {
                HelpRegistry.getInstance().register((Object)this, this.getHelpContextId());
            }
        }
    }

    public String getHelpContextId() {
        if (this.m_owner == null) {
            return "EXPLORATION_VIEW";
        }
        return this.m_owner.getOperationMode().isArchitectureModelling() ? "ARCHITECTURAL_VIEW" : "EXPLORATION_VIEW";
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        if (this.m_owner == null) {
            assert (elements != null && elements.size() == 1) : "Exactly 1 element expected";
            assert (elements.get(0) instanceof IExplorationViewRepresentationOwner) : "Unexpected class in method 'showInView': " + String.valueOf(elements.get(0));
            assert (options.size() == 1) : "Exactly 1 option expected";
            assert (options.get(0) instanceof ExplorationViewShowInViewRequest) : "Unexpected class in method 'showInView': " + String.valueOf(options.get(0));
            final ExplorationViewShowInViewRequest showInViewRequest = (ExplorationViewShowInViewRequest)options.get(0);
            this.setOwner((IExplorationViewRepresentationOwner)elements.get(0));
            this.getPart().setIconURI("platform:/plugin/com.hello2morrow.sonargraph.standalone/images/" + this.m_owner.getViewImageResourceName() + ".gif");
            if (showInViewRequest.getPresentationMode() != null) {
                this.m_presentationMode = showInViewRequest.getPresentationMode();
            }
            WorkbenchRegistry.getInstance().updatePartNameForModifiableFileState(this.getPart(), this.m_owner.getId());
            if (!((IArchitecturalViewBaseProvider)this.getSoftwareSystem().getExtension(IArchitecturalViewBaseProvider.class)).hasBeenLoaded(this.m_owner)) {
                LoadArchitecturalViewCommand command;
                if (this.m_owner instanceof ArchitecturalViewFile) {
                    command = new LoadArchitecturalViewCommand(this.getSoftwareSystemProvider(), new LoadArchitecturalViewCommand.ILoadArchitecturalViewInteraction(){

                        public boolean collect(LoadArchitecturalViewCommand.LoadArchitecturalViewData data) {
                            if (!$assertionsDisabled && data == null) {
                                throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                            }
                            data.setFile((ArchitecturalViewFile)ExplorationView.this.m_owner);
                            data.setPresentationMode(ExplorationView.this.m_presentationMode);
                            return true;
                        }

                        public void processCancelled() {
                            UserInterfaceAdapter.getInstance().displayUiElement(() -> {
                                ExplorationView.this.resetPartName();
                                ExplorationView.this.hideView();
                            });
                        }

                        public void processLoadResult(OperationResult result) {
                            if (!$assertionsDisabled && result == null) {
                                throw new AssertionError((Object)"Parameter 'result' of method 'processLoadResult' must not be null");
                            }
                            UserInterfaceAdapter.getInstance().process(result);
                            if (result.isFailure()) {
                                UserInterfaceAdapter.getInstance().displayUiElement(() -> {
                                    ExplorationView.this.resetPartName();
                                    ExplorationView.this.hideView();
                                });
                            }
                        }
                    });
                } else {
                    assert (this.m_owner instanceof ExplorationViewOnDemand) : "Unexpected class in method 'finishShowInView': " + String.valueOf(this.m_owner);
                    final ExplorationViewOnDemand onDemand = (ExplorationViewOnDemand)this.m_owner;
                    command = new LoadArchitecturalViewOnDemandCommand(this.getSoftwareSystemProvider(), new LoadArchitecturalViewOnDemandCommand.ILoadArchitecturalViewOnDemandInteraction(){

                        public boolean collect(final LoadArchitecturalViewOnDemandCommand.LoadArchitecturalViewOnDemandData data) {
                            if (!$assertionsDisabled && data == null) {
                                throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                            }
                            if (showInViewRequest.getType() == ExplorationViewShowInViewRequest.Type.ON_DEMAND_ADVANCED) {
                                RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

                                    public void run() {
                                        OpenOnDemandAdvancedDialog dialog = new OpenOnDemandAdvancedDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), showInViewRequest.getFocusProperties(), showInViewRequest.getOnDemand());
                                        if (dialog.open() == 0) {
                                            this.setResult(Boolean.TRUE);
                                            if (dialog.getSelectedOnDemand() != (this).ExplorationView.this.m_owner) {
                                                ExplorationView.this.setOwner((IExplorationViewRepresentationOwner)dialog.getSelectedOnDemand());
                                            }
                                            data.setData((ExplorationViewOnDemand)(this).ExplorationView.this.m_owner, (this).ExplorationView.this.m_presentationMode, dialog.useFocus() ? showInViewRequest.getFocusProperties() : null);
                                        } else {
                                            this.setResult(Boolean.FALSE);
                                            ExplorationView.this.resetPartName();
                                            ExplorationView.this.hideView();
                                        }
                                    }
                                };
                                UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
                                return (Boolean)runnable.getResult();
                            }
                            data.setData(onDemand, ExplorationView.this.m_presentationMode, showInViewRequest.getFocusProperties());
                            return true;
                        }

                        public void processCancelled() {
                            UserInterfaceAdapter.getInstance().displayUiElement(() -> {
                                ExplorationView.this.resetPartName();
                                ExplorationView.this.hideView();
                            });
                        }

                        public void processLoadOnDemandResult(OperationResult result) {
                            if (!$assertionsDisabled && result == null) {
                                throw new AssertionError((Object)"Parameter 'result' of method 'processLoadOnDemandResult' must not be null");
                            }
                            UserInterfaceAdapter.getInstance().process(result);
                            if (result.isFailure()) {
                                UserInterfaceAdapter.getInstance().displayUiElement(() -> {
                                    ExplorationView.this.resetPartName();
                                    ExplorationView.this.hideView();
                                });
                            }
                        }
                    });
                }
                UserInterfaceAdapter.getInstance().run((Command)command);
            }
        }
    }

    boolean isAutoExpandEnabled() {
        return this.m_autoExpand;
    }

    void enableAutoExpand(boolean enable) {
        if (this.m_figureProvider != null && this.m_figureProvider.enableAutoExpand(enable)) {
            this.m_autoExpand = enable;
        }
    }

    PresentationMode getPresentationMode() {
        return this.m_presentationMode;
    }

    void setLevelizationMode(final ExplorationViewSortMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'setLevelizationMode' must not be null";
        if (this.m_figureProvider != null && mode != this.m_figureProvider.getRepresentation().getSortMode()) {
            SetSortModeCommand command = new SetSortModeCommand(this.getSoftwareSystemProvider(), new SetSortModeCommand.ISetLevelizationModeInteraction(){

                public String getOwnerInfo() {
                    return ExplorationView.this.getPresentationName();
                }

                public boolean collect(SetSortModeCommand.SetLevelizationModeData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.setRepresentation(ExplorationView.this.m_figureProvider.getRepresentation());
                    data.setMode(mode);
                    return true;
                }

                public void processSetModeResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processSetPresentationModeResult' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
    }

    void setLevelizationModeListener(ISortModeListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'setLevelizationModeListener' must not be null";
        this.m_sortModeListener = listener;
        if (this.m_figureProvider != null) {
            ExplorationViewRepresentation representation = this.m_figureProvider.getRepresentation();
            this.m_sortModeListener.modified(representation.getOperationMode(), representation.getSupportedSortModes(), representation.getSortMode());
        }
    }

    void setPresentationMode(final PresentationMode presentationMode) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'setPresentationMode' must not be null";
        if (this.m_presentationMode != presentationMode) {
            this.m_presentationMode = presentationMode;
            if (this.m_figureProvider != null) {
                SetPresentationModeCommand command = new SetPresentationModeCommand(this.getSoftwareSystemProvider(), new SetPresentationModeCommand.ISetPresentationModeInteraction(){

                    public String getOwnerInfo() {
                        return ExplorationView.this.getPresentationName();
                    }

                    public boolean collect(SetPresentationModeCommand.SetPresentationModeData data) {
                        if (!$assertionsDisabled && data == null) {
                            throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                        }
                        data.setRepresentation(ExplorationView.this.m_figureProvider.getRepresentation());
                        data.setPresentationMode(presentationMode);
                        return true;
                    }

                    public void processSetPresentationModeResult(OperationResult result) {
                        if (!$assertionsDisabled && result == null) {
                            throw new AssertionError((Object)"Parameter 'result' of method 'processSetPresentationModeResult' must not be null");
                        }
                        UserInterfaceAdapter.getInstance().process(result);
                    }
                });
                UserInterfaceAdapter.getInstance().run((Command)command);
            }
        }
    }

    protected void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'completeViewNavigationState' must not be null";
        if (this.m_isInitialNavigationState) {
            ArchitecturalViewFigureProvider.completeInitialState(state, this.m_presentationMode, ExplorationViewSortMode.getDefault());
            this.m_isInitialNavigationState = false;
        } else if (this.m_figureProvider != null) {
            this.m_figureProvider.completeState(state);
        }
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreNavigationState' must not be null";
        if (this.m_figureProvider != null) {
            this.m_figureProvider.restoreState(state);
            this.m_presentationMode = this.m_figureProvider.getRepresentation().getPresentationMode();
            WorkbenchRegistry.getInstance().refreshUIElements();
        }
    }

    public boolean mayRequestHome() {
        return this.m_figureProvider != null && this.m_figureProvider.isHomePossible();
    }

    public void requestHome() {
        if (this.m_figureProvider != null) {
            this.m_figureProvider.home();
            ExplorationViewRepresentation representation = this.m_figureProvider.getRepresentation();
            this.m_presentationMode = representation.getPresentationMode();
            WorkbenchRegistry.getInstance().refreshUIElements();
            if (this.m_sortModeListener != null) {
                this.m_sortModeListener.modified(representation.getOperationMode(), representation.getSupportedSortModes(), representation.getSortMode());
            }
        }
    }

    public boolean supportsExcelExport() {
        return this.m_owner != null && this.m_figureProvider != null;
    }

    public String getExcelExportContentName() {
        return "Dependencies";
    }

    public String getExcelExportBaseFileName() {
        return (this.m_owner.getOperationMode().isArchitectureModelling() ? "Architectural" : "Exploration") + "ViewDependencies";
    }

    public List<ExportData> getExportData(IWorkerContext workerContext) {
        return ((IExportProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IExportProvider.class)).getExplorationViewInfo(this.m_figureProvider.getRepresentation(), workerContext);
    }

    public static interface ISortModeListener {
        public void modified(ExplorationViewOperationMode var1, EnumSet<ExplorationViewSortMode> var2, ExplorationViewSortMode var3);
    }
}

