/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.analyzersview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.DeleteAnalyzerConfigurationFileCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.system.IAnalyzerProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import java.util.List;

public final class DeleteAnalyzerConfigurationCommandAdapter
extends CompositeCommandAdapter {
    public CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.DELETE;
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.DELETE_ANALYZER_FILE;
    }

    public CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        AnalyzerConfigurationFile analyzerConfigurationFile;
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        if (elements.size() == 1 && provider.hasSoftwareSystem() && (analyzerConfigurationFile = ((IAnalyzerProvider)provider.getSoftwareSystem().getExtension(IAnalyzerProvider.class)).isDeletableAnalyzerConfigurationFile(elements.get(0))) != null) {
            return new CompositeCommandAdapter.Applicable(analyzerConfigurationFile.getPresentationKind() + " [" + analyzerConfigurationFile.getIdentifyingPath() + "]", analyzerConfigurationFile.getPresentationKind());
        }
        return null;
    }

    public static void perform(ISoftwareSystemProvider provider, final AnalyzerConfigurationFile analyzerConfigurationFile) {
        assert (provider != null) : "Parameter 'provider' of method 'perform' must not be null";
        assert (analyzerConfigurationFile != null) : "Parameter 'analyzerConfigurationFile' of method 'perform' must not be null";
        DeleteAnalyzerConfigurationFileCommand cmd = new DeleteAnalyzerConfigurationFileCommand(new DeleteAnalyzerConfigurationFileCommand.IInteraction(){

            public INavigationState getNavigationState() {
                return null;
            }

            public void processDeletionResult(OperationResult result) {
                UserInterfaceAdapter.getInstance().process(result);
            }

            public boolean collect(DeleteAnalyzerConfigurationFileCommand.InteractionData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                StringBuilder question = new StringBuilder();
                if (analyzerConfigurationFile.existsOnDisk()) {
                    question.append("This will delete '").append(analyzerConfigurationFile.getIdentifyingPath()).append("' on disk and reset the configuration to the default content.");
                } else {
                    question.append("This will reset the configuration to the default content.");
                }
                question.append("\nThis cannot be undone. Continue?");
                if (UserInterfaceAdapter.getInstance().question(question.toString(), false) == UserInterfaceAdapter.Feedback.CONFIRMED) {
                    data.setConfigurationFile(analyzerConfigurationFile);
                    return true;
                }
                return false;
            }
        }, provider);
        UserInterfaceAdapter.getInstance().run((Command)cmd);
    }

    public void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'apply' must not be null";
        assert (elements.size() == 1) : "Exactly one element expected: " + String.valueOf(elements);
        assert (provider.hasSoftwareSystem()) : "No system available";
        AnalyzerConfigurationFile analyzerConfigurationFile = ((IAnalyzerProvider)provider.getSoftwareSystem().getExtension(IAnalyzerProvider.class)).isDeletableAnalyzerConfigurationFile(elements.get(0));
        assert (analyzerConfigurationFile != null) : "'analyzerConfigurationFile' of method 'apply' must not be null";
        DeleteAnalyzerConfigurationCommandAdapter.perform(provider, analyzerConfigurationFile);
    }
}

