/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.model.element.IImportedModule;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ModuleBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public final class ModuleSelectionWizardPage<T extends Module>
extends StandardWizardPage
implements ISelectionChangedListener {
    static final String NAME = "Module Selection Page";
    private final Class<T> m_moduleClass;
    private T m_currentModule;
    private PropertyTableViewer<Module> m_viewer;

    public ModuleSelectionWizardPage(Class<T> moduleClass, T module) {
        super(NAME, "Select a module.");
        assert (moduleClass != null) : "Parameter 'moduleClass' of method 'ModuleSelectionWizardPage' must not be null";
        this.m_moduleClass = moduleClass;
        this.m_currentModule = module;
    }

    public static <E extends Module> List<E> getModulesOfferingRootDirectoryPathCreation(Class<E> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getModulesOfferingRootDirectoryPathCreation' must not be null";
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        if (!provider.hasSoftwareSystem()) {
            return Collections.emptyList();
        }
        List modules = ((Workspace)provider.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getChildren(clazz);
        ArrayList<Module> modulesOfferingPathCreation = new ArrayList<Module>();
        for (Module nextModule : modules) {
            if (nextModule.isAutomatic() || nextModule instanceof IImportedModule) continue;
            modulesOfferingPathCreation.add(nextModule);
        }
        return modulesOfferingPathCreation;
    }

    protected void createContent(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createContent' must not be null";
        this.m_viewer = new PropertyTableViewer(composite, (BeanPropertyReader.BeanAdapter)new ModuleBeanAdapter(), PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_viewer.addColumn("Module", "name", "name", "image", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_viewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_viewer.showData(ModuleSelectionWizardPage.getModulesOfferingRootDirectoryPathCreation(this.m_moduleClass));
        if (this.m_currentModule != null) {
            this.m_viewer.getTableViewer().setSelection((ISelection)new StructuredSelection(this.m_currentModule), true);
        }
        this.validate();
    }

    private void validate() {
        this.setPageComplete(this.m_currentModule != null);
    }

    protected final int getNumberOfColumns() {
        return 2;
    }

    public T getSelectedModule() {
        return this.m_currentModule;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
        this.m_currentModule = (Module)structuredSelection.getFirstElement();
        this.validate();
    }
}

