/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceprofile;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.CreateWorkspaceProfileCommand;
import com.hello2morrow.sonargraph.core.command.system.ModifyWorkspaceProfileCommand;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.system.FilterModification;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfilePattern;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfileProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.workspaceprofile.WorkspaceProfileFilterWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.workspaceprofile.WorkspaceProfilePatternsWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

public final class WorkspaceProfileWizard
extends NonLazySonargraphWizard {
    private final WorkspaceProfile m_toBeEdited;
    private NameAndDescriptionWizardPage m_nameAndDescriptionPage;
    private WorkspaceProfilePatternsWizardPage m_patternsPage;
    private WorkspaceProfileFilterWizardPage m_filtersPage;

    public int getPreferredWidth() {
        return 700;
    }

    public int getPreferredHeight() {
        return 500;
    }

    public int getMinimumWidth() {
        return 500;
    }

    public int getMinimumHeight() {
        return 400;
    }

    public WorkspaceProfileWizard(WorkspaceProfile toBeEdited) {
        super("Edit Workspace Profile");
        assert (toBeEdited != null) : "Parameter 'toBeEdited' of method 'WorkspaceProfilePatternBasedWizard' must not be null";
        this.m_toBeEdited = toBeEdited;
    }

    public WorkspaceProfileWizard() {
        super("New Workspace Profile");
        this.m_toBeEdited = null;
    }

    public void addPages() {
        FilterModification filterModifications;
        String filtersTitle;
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        SoftwareSystem softwareSystem = provider.getSoftwareSystem();
        IWorkspaceProfileProvider profileProvider = (IWorkspaceProfileProvider)softwareSystem.getExtension(IWorkspaceProfileProvider.class);
        String title = this.m_toBeEdited == null ? "Create Workspace Profile" : "Edit Workspace Profile";
        String name = this.m_toBeEdited == null ? "" : FileUtility.getFileNameWithoutExtension((TFile)this.m_toBeEdited.getFile());
        String description = this.m_toBeEdited == null ? "" : this.m_toBeEdited.getDescription();
        this.m_nameAndDescriptionPage = new NameAndDescriptionWizardPage("nameAndDescriptionPage", title, "Name", profileProvider.getNameValidator(), name, description){

            protected IDialogId getDialogId() {
                return CoreDialogId.CREATE_WORKSPACE_PROFILE;
            }
        };
        this.addPage((SonargraphWizardPage)this.m_nameAndDescriptionPage);
        this.m_patternsPage = new WorkspaceProfilePatternsWizardPage(this.m_toBeEdited);
        this.addPage((SonargraphWizardPage)this.m_patternsPage);
        if (this.m_toBeEdited == null) {
            filtersTitle = "Create Workspace Profile Filter";
            filterModifications = new FilterModification(((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getProductionCodeFilter(), true, false);
        } else {
            filtersTitle = "Edit Workspace Profile Filter";
            filterModifications = new FilterModification((ProductionCodeFilter)this.m_toBeEdited.getUniqueExistingChild(ProductionCodeFilter.class), false, this.m_toBeEdited.overrideWorkspaceFilter());
        }
        this.m_filtersPage = new WorkspaceProfileFilterWizardPage(filtersTitle, filterModifications);
        this.addPage((SonargraphWizardPage)this.m_filtersPage);
    }

    public boolean canFinish() {
        if (!super.canFinish()) {
            return false;
        }
        if (this.m_toBeEdited == null) {
            return true;
        }
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        return ((IWorkspaceProfileProvider)provider.getSoftwareSystem().getExtension(IWorkspaceProfileProvider.class)).hasChanged(this.m_toBeEdited, this.m_nameAndDescriptionPage.getElementName(), this.m_nameAndDescriptionPage.getElementDescription(), this.m_patternsPage.getPatterns(), this.m_filtersPage.getFilterModifiaction());
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        if (this.m_toBeEdited == null) {
            CreateWorkspaceProfileCommand createCommand = new CreateWorkspaceProfileCommand(provider, (CreateWorkspaceProfileCommand.ICreateInteraction)new CreateInteraction(this.m_nameAndDescriptionPage.getElementName(), this.m_nameAndDescriptionPage.getElementDescription(), this.m_patternsPage.getPatterns(), this.m_filtersPage.getFilterModifiaction()));
            UserInterfaceAdapter.getInstance().run((Command)createCommand);
        } else {
            ModifyWorkspaceProfileCommand modifyCommand = new ModifyWorkspaceProfileCommand(provider, (ModifyWorkspaceProfileCommand.IModifyInteraction)new ModifyInteraction(this.m_toBeEdited, this.m_nameAndDescriptionPage.getElementName(), this.m_nameAndDescriptionPage.getElementDescription(), this.m_patternsPage.getPatterns(), this.m_filtersPage.getFilterModifiaction()));
            UserInterfaceAdapter.getInstance().run((Command)modifyCommand);
        }
        return true;
    }

    private static class CreateInteraction
    implements CreateWorkspaceProfileCommand.ICreateInteraction {
        private final String m_name;
        private final String m_description;
        private final List<IWorkspaceProfilePattern> m_patterns;
        private final FilterModification m_filterModification;

        public CreateInteraction(String name, String description, List<IWorkspaceProfilePattern> patterns, FilterModification filterModification) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'CreateInteraction' must not be empty";
            assert (description != null) : "Parameter 'description' of method 'CreateInteraction' must not be null";
            assert (patterns != null) : "Parameter 'patterns' of method 'CreateInteraction' must not be null";
            assert (filterModification != null) : "Parameter 'filterModification' of method 'CreateInteraction' must not be null";
            this.m_name = name;
            this.m_description = description;
            this.m_patterns = patterns;
            this.m_filterModification = filterModification;
        }

        public boolean collect(CreateWorkspaceProfileCommand.CreateData data) {
            data.setName(this.m_name);
            data.setDescription(this.m_description);
            data.setPatterns(this.m_patterns);
            data.setFilters(this.m_filterModification);
            return true;
        }

        public void processCreateResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }

    private static class ModifyInteraction
    implements ModifyWorkspaceProfileCommand.IModifyInteraction {
        private final WorkspaceProfile m_profile;
        private final String m_name;
        private final String m_description;
        private final List<IWorkspaceProfilePattern> m_patterns;
        private final FilterModification m_filterModifications;

        public ModifyInteraction(WorkspaceProfile profile, String name, String description, List<IWorkspaceProfilePattern> patterns, FilterModification filterModifications) {
            assert (profile != null) : "Parameter 'profile' of method 'ModifyInteraction' must not be null";
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ModifyInteraction' must not be empty";
            assert (description != null) : "Parameter 'description' of method 'ModifyInteraction' must not be null";
            assert (patterns != null) : "Parameter 'patterns' of method 'ModifyInteraction' must not be null";
            assert (filterModifications != null) : "Parameter 'filterModifications' of method 'ModifyInteraction' must not be null";
            this.m_profile = profile;
            this.m_name = name;
            this.m_description = description;
            this.m_patterns = patterns;
            this.m_filterModifications = filterModifications;
        }

        public boolean collect(ModifyWorkspaceProfileCommand.ModifyData data) {
            data.setProfile(this.m_profile);
            data.setModifiedName(this.m_name);
            data.setDescription(this.m_description);
            data.setPatterns(this.m_patterns);
            data.setFilters(this.m_filterModifications);
            return true;
        }

        public void processModificationResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

