/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceprofile;

import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfileProvider;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfilePatternModification;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class WorkspaceProfilePatternDialog
extends StandardDialog {
    private final String m_moduleMatcher;
    private final String m_rootPathMatcher;
    private final String m_rootPathReplacement;
    private final IWorkspaceProfileProvider.MatcherPair m_currentMatchers = new IWorkspaceProfileProvider.MatcherPair();
    private String m_currentRootPathReplacement;
    private ValidatingTextWidget m_moduleMatcherText;
    private ValidatingTextWidget m_rootPathMatcherText;
    private ValidatingTextWidget m_rootPathReplacementText;

    public WorkspaceProfilePatternDialog(Shell parentShell, WorkspaceProfilePatternModification edit) {
        super(parentShell, "Edit Workspace Profile Pattern", 2160);
        this.m_moduleMatcher = edit.getModuleMatcher();
        this.m_rootPathMatcher = edit.getRootPathMatcher();
        this.m_rootPathReplacement = edit.getRootPathReplacement();
    }

    public WorkspaceProfilePatternDialog(Shell parentShell) {
        super(parentShell, "Create Workspace Profile Pattern", 2160);
        this.m_moduleMatcher = "";
        this.m_rootPathMatcher = "";
        this.m_rootPathReplacement = "";
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.WORKSPACE_PROFILE_PATTERN_DIALOG;
    }

    protected void applyData() {
        this.m_moduleMatcherText.setText(this.m_moduleMatcher.isEmpty() ? "(.*:)*(?<module>.*)" : this.m_moduleMatcher);
        this.m_rootPathMatcherText.setText(this.m_rootPathMatcher.isEmpty() ? "(?<path>.*)/classes" : this.m_rootPathMatcher);
        this.m_rootPathReplacementText.setText(this.m_rootPathReplacement.isEmpty() ? "${path}/${module}.jar" : this.m_rootPathReplacement);
    }

    protected Point getPreferredSize() {
        return new Point(400, 250);
    }

    protected void fillDialogArea(Composite composite) {
        IWorkspaceProfileProvider provider = (IWorkspaceProfileProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IWorkspaceProfileProvider.class);
        Label moduleMatcherLabel = new Label(composite, 0);
        moduleMatcherLabel.setText("Module name matcher: ");
        moduleMatcherLabel.setLayoutData((Object)new GridData(1, 128, false, false));
        this.m_moduleMatcherText = new ValidatingTextWidget(composite, provider.getMatchPatternValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                WorkspaceProfilePatternDialog.this.m_currentMatchers.setModuleMatcher(input);
                if (input != null) {
                    WorkspaceProfilePatternDialog.this.m_rootPathReplacementText.setText(WorkspaceProfilePatternDialog.this.m_rootPathReplacementText.getTextField().getText());
                }
                WorkspaceProfilePatternDialog.this.checkInputModified();
            }
        });
        this.m_moduleMatcherText.setLayoutData((Object)new GridData(4, 128, true, false));
        Label rootPathMatcherLabel = new Label(composite, 0);
        rootPathMatcherLabel.setText("Root path matcher: ");
        rootPathMatcherLabel.setLayoutData((Object)new GridData(1, 128, false, false));
        this.m_rootPathMatcherText = new ValidatingTextWidget(composite, provider.getMatchPatternValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                WorkspaceProfilePatternDialog.this.m_currentMatchers.setRootPathMatcher(input);
                if (input != null) {
                    WorkspaceProfilePatternDialog.this.m_rootPathReplacementText.setText(WorkspaceProfilePatternDialog.this.m_rootPathReplacementText.getTextField().getText());
                }
                WorkspaceProfilePatternDialog.this.checkInputModified();
            }
        });
        this.m_rootPathMatcherText.setLayoutData((Object)new GridData(4, 128, true, false));
        SwtUtility.placeHorizontalSeparator((Composite)composite, (int)this.getNumberOfColumns());
        Label rootPathReplacementLabel = new Label(composite, 0);
        rootPathReplacementLabel.setText("Root path replacement: ");
        rootPathReplacementLabel.setLayoutData((Object)new GridData(1, 128, false, false));
        this.m_rootPathReplacementText = new ValidatingTextWidget(composite, provider.getReplacementPatternValidator(this.m_currentMatchers), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                WorkspaceProfilePatternDialog.this.m_currentRootPathReplacement = input;
                WorkspaceProfilePatternDialog.this.checkInputModified();
            }
        });
        this.m_rootPathReplacementText.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    public String getModuleMatcher() {
        return this.m_currentMatchers.getModuleMatcher();
    }

    public String getRootPathMatcher() {
        return this.m_currentMatchers.getRootPathMatcher();
    }

    public String getRootPathReplacement() {
        return this.m_currentRootPathReplacement;
    }

    private void checkInputModified() {
        if (this.m_currentMatchers.getModuleMatcher() == null || this.m_currentMatchers.getRootPathMatcher() == null || this.m_currentRootPathReplacement == null) {
            this.getButton(0).setEnabled(false);
        } else if (this.m_moduleMatcher.equals(this.m_currentMatchers.getModuleMatcher()) && this.m_rootPathMatcher.equals(this.m_currentMatchers.getRootPathMatcher()) && this.m_rootPathReplacement.equals(this.m_currentRootPathReplacement)) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }
}

