/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.virtualmodelview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.path.VirtualModels;
import com.hello2morrow.sonargraph.core.model.system.IFiles;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.ui.standalone.base.wizard.StandaloneWizardAdapter;
import com.hello2morrow.sonargraph.ui.standalone.virtualmodelview.ModifiableModelWizard;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import java.util.List;

public final class ModifiableModelWizardAdapter
extends StandaloneWizardAdapter {
    public final SonargraphWizardAdapter.Category getCategory() {
        return SonargraphWizardAdapter.Category.MODEL;
    }

    private VirtualModel getBasedOn(ISoftwareSystemProvider provider, List<Element> selected, boolean selectionBasedOnly) {
        assert (provider != null) : "Parameter 'provider' of method 'getBasedOn' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'getBasedOn' must not be null";
        if (selected.size() == 1) {
            Element element = selected.get(0);
            if (element instanceof SoftwareSystem) {
                element = ((IFiles)((SoftwareSystem)element).getUniqueExistingChild(IFiles.class)).getParserModel();
            }
            if (element instanceof VirtualModel) {
                return (VirtualModel)element;
            }
        }
        if (!selectionBasedOnly && provider.hasSoftwareSystem()) {
            return ((IFiles)provider.getSoftwareSystem().getUniqueExistingChild(IFiles.class)).getParserModel();
        }
        return null;
    }

    public final boolean isEnabled(ISoftwareSystemProvider provider, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'isEnabled' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'isEnabled' must not be null";
        if (this.isAvailable() && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED})) {
            return this.getBasedOn(provider, selected, false) != null;
        }
        return false;
    }

    public final boolean showInContextMenu(ISoftwareSystemProvider provider, IWorkbenchView workbenchView, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'showInContextMenu' must not be null";
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'showInContextMenu' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'showInContextMenu' must not be null";
        if (workbenchView.getViewId() == ViewId.FILES_VIEW) {
            if (selected.isEmpty()) {
                return true;
            }
            if (selected.size() == 1) {
                Element element = selected.get(0);
                return element instanceof VirtualModel || element instanceof VirtualModels;
            }
        }
        return false;
    }

    public String getName() {
        return "New Model";
    }

    public String getImageResource() {
        return "NewModifiableModel";
    }

    public boolean isAvailable() {
        return CommandHandlerWithCorrespondingCommand.isAvailable((ICommandId)CoreCommandId.CREATE_MODIFIABLE_MODEL);
    }

    public SonargraphWizard create(ISoftwareSystemProvider provider, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'create' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'create' must not be null";
        assert (provider.hasSoftwareSystem()) : "No system available";
        return new ModifiableModelWizard(this.getBasedOn(provider, selected, false));
    }
}

