/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.virtualmodelview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.CreateModifiableModelCommand;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.IVirtualModelProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.common.StandardCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.virtualmodelview.CreateModifiableModelWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;

public final class ModifiableModelWizard
extends NonLazySonargraphWizard {
    private final VirtualModel m_basedOn;
    private CreateModifiableModelWizardPage m_page;

    public ModifiableModelWizard(VirtualModel basedOn) {
        super("New Model");
        assert (basedOn != null) : "Parameter 'basedOn' of method 'ModifiableModelWizard' must not be null";
        this.m_basedOn = basedOn;
    }

    public int getPreferredWidth() {
        return 150;
    }

    public int getPreferredHeight() {
        return 300;
    }

    public int getMinimumWidth() {
        return 150;
    }

    public int getMinimumHeight() {
        return 100;
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        SoftwareSystem softwareSystem = provider.getSoftwareSystem();
        IVirtualModelProvider virtualModelProvider = (IVirtualModelProvider)softwareSystem.getExtension(IVirtualModelProvider.class);
        this.m_page = new CreateModifiableModelWizardPage(virtualModelProvider.getModifiableModelNameValidator(), ((Files)softwareSystem.getUniqueExistingChild(Files.class)).getVirtualModels(), this.m_basedOn);
        this.addPage((SonargraphWizardPage)this.m_page);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            CreateModifiableModelCommand createCommand = new CreateModifiableModelCommand(provider, (CreateModifiableModelCommand.ICreateInteraction)new CreateModifiableModelInteraction());
            UserInterfaceAdapter.getInstance().run((Command)createCommand, new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    super.consume(exception);
                }
            });
            return true;
        }
        return false;
    }

    final class CreateModifiableModelInteraction
    extends StandardCommandInteraction
    implements CreateModifiableModelCommand.ICreateInteraction {
        CreateModifiableModelInteraction() {
        }

        public void processCreateResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processCreateResult' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
        }

        public boolean collect(CreateModifiableModelCommand.CreateModifiableModelData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            assert (ModifiableModelWizard.this.m_page != null) : "Parameter 'm_page' of method 'collect' must not be null";
            data.setModelName(ModifiableModelWizard.this.m_page.getElementName());
            data.setDescription(ModifiableModelWizard.this.m_page.getElementDescription());
            data.setModel(ModifiableModelWizard.this.m_page.setModel());
            data.setBasedOn(ModifiableModelWizard.this.m_page.getBasedOn());
            return true;
        }
    }
}

