/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.treemap.IssueCollectorValueSource;
import com.hello2morrow.sonargraph.ui.standalone.treemap.LayoutUtil;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ComboWithImages;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class IssueCollectorConfigurationComposite
extends Composite {
    private final ArrayList<Button> m_resolutionButtons = new ArrayList();
    private final ArrayList<Button> m_severityButtons = new ArrayList();
    private final IssueCollectorValueSource m_issueCollectorValueSource;

    IssueCollectorConfigurationComposite(Composite parent, final ComboWithImages valueSources, final IssueCollectorValueSource valueSource, final IListener listener) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'parent' of method 'IssueCollectorConfigurationComposite' must not be null";
        assert (valueSources != null) : "Parameter 'valueSources' of method 'IssueCollectorConfigurationComposite' must not be null";
        assert (valueSource != null) : "Parameter 'valueSource' of method 'IssueCollectorConfigurationComposite' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'IssueCollectorConfigurationComposite' must not be null";
        this.m_issueCollectorValueSource = valueSource;
        this.setLayout((Layout)LayoutUtil.createCompositeGridLayout(1));
        Composite title = new Composite((Composite)this, 0);
        title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        title.setLayout((Layout)LayoutUtil.createCompositeGridLayout(3));
        Label titleSeparator = new Label(title, 258);
        titleSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label text = new Label(title, 0);
        text.setText("Issue Collector Configuration");
        text.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        titleSeparator = new Label(title, 258);
        titleSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite configuration = new Composite((Composite)this, 0);
        configuration.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        configuration.setLayout((Layout)LayoutUtil.createCompositeGridLayout(2));
        Label resolutionModeLabel = new Label(configuration, 0);
        resolutionModeLabel.setText("Include issues with resolution:");
        resolutionModeLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Composite resolutionModeComposite = new Composite(configuration, 0);
        resolutionModeComposite.setLayout((Layout)LayoutUtil.createCompositeGridLayout(valueSource.getAvailableResolutionModes().size()));
        resolutionModeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        for (final ResolutionMode next : valueSource.getAvailableResolutionModes()) {
            final Button nextButton = new Button(resolutionModeComposite, 32);
            nextButton.setData((Object)next);
            this.m_resolutionButtons.add(nextButton);
            nextButton.setText(next.getPresentationName());
            nextButton.setSelection(valueSource.getResolutionModes().contains(next));
            nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (nextButton.getSelection()) {
                        valueSource.addResolutionMode(next);
                    } else {
                        valueSource.removeResolutionMode(next);
                    }
                    valueSources.updateDecoration(valueSource.isValid());
                    listener.modified(IssueCollectorConfigurationComposite.this);
                }
            });
        }
        this.m_resolutionButtons.trimToSize();
        Label severityLabel = new Label(configuration, 0);
        severityLabel.setText("Include issues with severity:");
        severityLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Composite severityComposite = new Composite(configuration, 0);
        severityComposite.setLayout((Layout)LayoutUtil.createCompositeGridLayout(valueSource.getAvailableSeverities().size()));
        severityComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        for (final Severity next : valueSource.getAvailableSeverities()) {
            final Button nextButton = new Button(severityComposite, 32);
            nextButton.setData((Object)next);
            this.m_severityButtons.add(nextButton);
            nextButton.setText(next.getPresentationName());
            nextButton.setSelection(valueSource.getSeverities().contains(next));
            nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (nextButton.getSelection()) {
                        valueSource.addSeverity(next);
                    } else {
                        valueSource.removeSeverity(next);
                    }
                    valueSources.updateDecoration(valueSource.isValid());
                    listener.modified(IssueCollectorConfigurationComposite.this);
                }
            });
        }
        this.m_severityButtons.trimToSize();
    }

    void updateFromModel() {
        for (Button nextButton : this.m_resolutionButtons) {
            nextButton.setSelection(this.m_issueCollectorValueSource.containsResolutionMode((ResolutionMode)nextButton.getData()));
        }
        for (Button nextButton : this.m_severityButtons) {
            nextButton.setSelection(this.m_issueCollectorValueSource.containsSeverity((Severity)nextButton.getData()));
        }
    }

    public static interface IListener {
        public void modified(IssueCollectorConfigurationComposite var1);
    }
}

