/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.sourceview;

import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.ContextsModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.LanguageBasedSourceViewWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SourceViewWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SourceViewWidgetBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.standalone.sourceview.SingleSourceView;
import com.hello2morrow.sonargraph.ui.standalone.sourceview.StandardSourceViewWidget;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.Gesture;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithZoom;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IContextWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.SourceViewShowInViewSupport;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchAuxiliaryView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.ElementGroup;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class SourceView
extends SingleSourceView
implements IViewWithZoom,
IContextWorkbenchView {
    private StandardSourceViewWidget m_sourceViewWidget;
    private SourceViewWidgetBasedTextSearchHandler m_textSearchProvider;
    private IContextWorkbenchView.ContextAndElement<Element> m_contextAndElement;

    public IViewId getViewId() {
        return ViewId.SOURCE_VIEW;
    }

    public List<Control> getControlsForInteraction() {
        assert (this.m_sourceViewWidget != null) : "'m_sourceViewWidget' of method 'getControlsForInteraction' must not be null";
        return Collections.singletonList(this.m_sourceViewWidget.getMainControl());
    }

    public void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.m_sourceViewWidget = new StandardSourceViewWidget(viewContentArea, (IWorkbenchView)this);
        this.m_sourceViewWidget.setLayoutData(new GridData(4, 4, true, true));
        this.m_textSearchProvider = new SourceViewWidgetBasedTextSearchHandler(this.m_sourceViewWidget, false, this.getViewId().getPresentationName());
        EventManager.getInstance().attach((EventHandler)new EventHandler<ContextsModifiedEvent>(ContextsModifiedEvent.class, (Object)this){

            public void handleEvent(ContextsModifiedEvent event) {
                if (SourceView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && SourceView.this.m_contextAndElement != null && !SourceView.this.m_contextAndElement.isValid()) {
                    SourceView.this.clearAndHideView();
                }
            }
        });
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(ContextsModifiedEvent.class, (Object)this);
        this.m_contextAndElement = null;
        if (this.m_sourceViewWidget != null) {
            this.m_sourceViewWidget.clear();
            this.m_sourceViewWidget.dispose();
            this.m_sourceViewWidget = null;
        }
        super.destroyViewContent();
    }

    public IContext getContext() {
        if (this.m_contextAndElement != null) {
            return this.m_contextAndElement.getContext();
        }
        return super.getContext();
    }

    public String getPresentationName() {
        FilePath sourceFile;
        Element element;
        if (this.m_contextAndElement != null && this.m_contextAndElement.isValid() && (element = this.m_contextAndElement.getElement()) != null && (sourceFile = SourceViewShowInViewSupport.getSourceFile(Collections.singletonList(element))) != null) {
            return "Source View [" + sourceFile.getShortName() + "]";
        }
        return super.getPresentationName();
    }

    @Override
    protected SourceViewWidget getSourceViewWidget() {
        return this.m_sourceViewWidget;
    }

    private void clearAndHideView() {
        this.m_contextAndElement = null;
        this.m_sourceViewWidget.clear();
        this.hideView();
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        super.softwareSystemModified(modification, restoredFromHistory);
        if (modification.contains(Modification.WORKSPACE_CLEARED)) {
            this.clearAndHideView();
            return;
        }
        if (modification.contains(Modification.WORKSPACE_MODIFIED) || modification.contains(Modification.VIRTUAL_MODEL_CHANGED) || modification.contains(Modification.VIRTUAL_MODEL_MODIFIED)) {
            NavigationState lastNavigationState = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId());
            if (lastNavigationState == null) {
                this.clearAndHideView();
                return;
            }
            List elements = lastNavigationState.getElements((IElementGroup)ElementGroup.ELEMENTS_FOR_VIEW, Element.class, this.getElementResolver());
            if (!elements.isEmpty()) {
                this.updateViewContent(this.m_contextAndElement.getContext(), new ArrayList<Element>(elements), false, true);
            } else {
                this.clearAndHideView();
            }
        }
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        FilePath sourceFile;
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED) && (sourceFile = this.m_sourceViewWidget.getSourceFile()) != null) {
            this.processIssues((NamedElement)sourceFile);
        }
        super.analyzerModification(modification, analyzerId);
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.clearAndHideView();
    }

    public void showInView(IContext context, List<Element> elements, List<IStandardEnumeration> options, boolean secondaryIdReused) {
        assert (context != null) : "Parameter 'context' of method 'showInView' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'select' must not be null";
        this.updateViewContent(context, elements, true, false);
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'finishShowInView' must not be empty";
        LanguageBasedSourceViewWidget.performOutOfDateCheck(this.getSoftwareSystem(), this.m_sourceViewWidget);
        WorkbenchRegistry.getInstance().selectView((IWorkbenchView)this);
        this.getSelectionProviderAdapter().handleSelectionChanged(this.getSelectedElements());
    }

    private void updateViewContent(IContext context, List<Element> elements, boolean setSelection, boolean forceRefresh) {
        assert (context != null) : "Parameter 'context' of method 'updateViewContent' must not be null";
        assert (elements != null && elements.size() == 1) : "Parameter 'elements' of method 'updateViewContent' is expected to have exactly one element";
        this.m_contextAndElement = new IContextWorkbenchView.ContextAndElement(context, elements.get(0));
        FilePath sourceFile = SourceViewShowInViewSupport.getSourceFile(elements);
        assert (sourceFile != null) : "'sourceFile' of method 'updateViewContent' must not be null";
        this.setTitleTooltip(sourceFile.getIdentifyingPath());
        this.setPartName(sourceFile.getShortName());
        Element element = this.m_contextAndElement.getElement();
        int lineNumber = element.getLineNumber();
        if (lineNumber == -1) {
            if (element instanceof ParserDependency) {
                element = ((ParserDependency)element).getFrom();
            }
            if (element instanceof ProgrammingElement) {
                ProgrammingElement programmingElement = (ProgrammingElement)element;
                List out = programmingElement.getOutgoingDependenciesRecursively();
                for (ParserDependency nextOut : out) {
                    if (nextOut.getLineNumber() == -1) continue;
                    lineNumber = nextOut.getLineNumber();
                    break;
                }
            }
        }
        this.m_sourceViewWidget.setRedraw(false);
        this.m_sourceViewWidget.showSource(sourceFile, lineNumber, lineNumber != -1, forceRefresh, null);
        this.processIssues((NamedElement)sourceFile);
        this.m_sourceViewWidget.setRedraw(true);
        if (setSelection) {
            this.getSelectionProviderAdapter().handleSelectionChanged(element);
        }
    }

    public List<Element> getSelectedElements() {
        SelectionProviderAdapter selectionProviderAdapter;
        FilePath sourceFile;
        if (this.m_sourceViewWidget != null && !this.m_sourceViewWidget.isDisposed() && (sourceFile = this.m_sourceViewWidget.getSourceFile()) != null && (selectionProviderAdapter = this.getSelectionProviderAdapter()) != null) {
            return selectionProviderAdapter.getElementList((Element)sourceFile);
        }
        return Collections.emptyList();
    }

    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchProvider;
    }

    private boolean isApplicableForView(IViewId viewId) {
        if (viewId instanceof ViewId) {
            switch ((ViewId)viewId) {
                case OUTGOING_PARSER_DEPENDENCIES_VIEW: 
                case MARKERS_VIEW: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public int getCurrentLine() {
        StyledText sourceWidget = this.m_sourceViewWidget.getSourceWidget();
        if (sourceWidget == null || sourceWidget.isDisposed()) {
            return -1;
        }
        return sourceWidget.getLineAtOffset(sourceWidget.getCaretOffset()) + 1;
    }

    public StrictPair<Integer, Integer> getVisibleLineRange() {
        StyledText sourceWidget = this.m_sourceViewWidget.getSourceWidget();
        if (sourceWidget == null || sourceWidget.isDisposed()) {
            return new StrictPair((Object)-1, (Object)-1);
        }
        int topIndex = JFaceTextUtil.getPartialTopIndex((StyledText)sourceWidget) + 1;
        int bottomIndex = JFaceTextUtil.getPartialBottomIndex((StyledText)sourceWidget) + 1;
        return new StrictPair((Object)topIndex, (Object)bottomIndex);
    }

    public int getFirstVisibleLineNumber() {
        return this.m_sourceViewWidget.isDisposed() ? -1 : this.m_sourceViewWidget.getFirstVisibleLineNumber() - 1;
    }

    public int getFirstSelectedLine() {
        return this.m_sourceViewWidget.isDisposed() ? -1 : this.m_sourceViewWidget.getSelectedTextInfo().getLineNumber();
    }

    public void performViewSelectionChanged(IWorkbenchView view, List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'selectionChanged' must not be null";
        if (view != null && view instanceof WorkbenchAuxiliaryView && !elements.isEmpty() && this.isApplicableForView(view.getViewId()) && ((WorkbenchAuxiliaryView)view).getConnectedView() == this && this.m_sourceViewWidget.isSourceAvailable()) {
            int lineNumber = elements.get(0).getLineNumber();
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            this.m_sourceViewWidget.gotoLine(lineNumber, true);
        }
    }

    protected EnumSet<Gesture> getDisabledGestures() {
        return EnumSet.of(Gesture.DOUBLE_CLICK);
    }

    public void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'completeViewNavigationState' must not be null";
        if (this.m_sourceViewWidget != null && this.m_sourceViewWidget.isSourceAvailable()) {
            state.addElementsInformation((IElementGroup)ElementGroup.ELEMENTS_FOR_VIEW, NavigationState.getDescriptors(Collections.singletonList(this.m_sourceViewWidget.getSourceFile()), (IElementResolver)this.getElementResolver()));
        }
    }

    public void zoomIn(Point location) {
        this.m_sourceViewWidget.zoomIn();
    }

    public void zoomOut(Point location) {
        this.m_sourceViewWidget.zoomOut();
    }
}

