/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise;

import com.hello2morrow.sonargraph.core.model.enterprise.ISonargraphEnterpriseProvider;
import com.hello2morrow.sonargraph.core.model.enterprise.RemoteSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.AbstractRequestRemoteInfoWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.RemoteSystemInfoBeanPropertyAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public final class RemoteSystemWizardPage
extends AbstractRequestRemoteInfoWizardPage<RemoteSystemInfo> {
    private static final IDialogId ID = CoreDialogId.REMOTE_SYSTEMS_PAGE;
    private final ISoftwareSystemProvider m_systemProvider;

    public RemoteSystemWizardPage(ISoftwareSystemProvider systemProvider, ISonargraphEnterpriseProvider enterpriseExtension, ProxySettings proxySettings) {
        super(ID, enterpriseExtension, proxySettings);
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'SystemFromServerWizardPage' must not be null";
        this.m_systemProvider = systemProvider;
    }

    protected IDialogId getDialogId() {
        return ID;
    }

    @Override
    protected PropertyTableViewer<RemoteSystemInfo> createPropertyTable(Composite parent) {
        PropertyTableViewer remoteSystemsTable = new PropertyTableViewer(parent, (BeanPropertyReader.BeanAdapter)new RemoteSystemInfoBeanPropertyAdapter(), "name", true, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        remoteSystemsTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        remoteSystemsTable.addColumn("Name", "name", "name", null, 200, PropertyTableViewer.ColumnType.TEXT);
        remoteSystemsTable.addColumn("Description", "description", "description", null, 300, PropertyTableViewer.ColumnType.TEXT);
        remoteSystemsTable.addColumn("Last Updated", "lastUpdated", "lastUpdated", null, 200, PropertyTableViewer.ColumnType.TEXT);
        remoteSystemsTable.addColumn("Id", "id", "id", null, 100, PropertyTableViewer.ColumnType.TEXT);
        return remoteSystemsTable;
    }

    @Override
    protected OperationResultWithOutcome<List<RemoteSystemInfo>> executeRequest(ISonargraphEnterpriseProvider enterpriseExtension, ISonargraphEnterpriseProvider.IEnterpriseInfoProvider infoProvider) {
        OperationResultWithOutcome systemsResult = enterpriseExtension.listSystems(infoProvider);
        if (systemsResult == null || systemsResult.getOutcome() == null) {
            UserInterfaceAdapter.getInstance().error("Failed to Load Systems", "No systems could be loaded from Sonargraph-Enterprise server.");
        } else if (((List)systemsResult.getOutcome()).isEmpty()) {
            UserInterfaceAdapter.getInstance().error("Failed to Load Systems", "There are no systems available on Sonargraph-Enterprise server.");
        }
        return systemsResult;
    }

    @Override
    public void execute() {
        super.execute();
        if (this.m_systemProvider.hasSoftwareSystem()) {
            SoftwareSystem currentSystem = this.m_systemProvider.getSoftwareSystem();
            RemoteSystemInfo currentInfo = new RemoteSystemInfo(currentSystem.getId(), currentSystem.getName(), currentSystem.getId(), "");
            for (RemoteSystemInfo next : this.getData()) {
                if (!next.getId().equals(currentInfo.getId())) continue;
                this.setSelection(next);
            }
        }
    }
}

