/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise;

import com.hello2morrow.sonargraph.core.command.enterprise.DownloadSnapshotFromServerCommand;
import com.hello2morrow.sonargraph.core.model.enterprise.ISonargraphEnterpriseProvider;
import com.hello2morrow.sonargraph.core.model.enterprise.SnapshotInfo;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.AbstractDownloadWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.SnapshotInfoBeanPropertyAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

final class RemoteSnapshotWizardPage
extends AbstractDownloadWizardPage<SnapshotInfo> {
    private static final IDialogId ID = CoreDialogId.REMOTE_SNAPSHOTS_PAGE;
    private SnapshotInfo m_snapshot;

    public RemoteSnapshotWizardPage(ISonargraphEnterpriseProvider enterpriseExtension, ProxySettings proxySettings, TFile snapshotDirectory) {
        super(ID, enterpriseExtension, proxySettings, snapshotDirectory, "Snapshot Directory:");
    }

    @Override
    protected PropertyTableViewer<SnapshotInfo> createPropertyTable(Composite parent) {
        PropertyTableViewer remoteSnapshotsTable = new PropertyTableViewer(parent, (BeanPropertyReader.BeanAdapter)new SnapshotInfoBeanPropertyAdapter(), "timestamp", true, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        remoteSnapshotsTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        remoteSnapshotsTable.addColumn("Timestamp", "timestamp", "timestamp", null, 200, PropertyTableViewer.ColumnType.TEXT);
        return remoteSnapshotsTable;
    }

    @Override
    protected void updateFileName() {
        this.m_snapshot = (SnapshotInfo)this.getSelection();
        Date dateTime = Iso8601DateFormat.parseDataAndTime((String)this.m_snapshot.getTimestamp(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSSX");
        String timestamp = Iso8601DateFormat.formatDateAndTimeForFileName((Date)dateTime);
        String fileNameCandidate = this.getRemoteSystem().getName() + "_" + timestamp + CoreFileType.SNAPSHOT.getDefaultExtension();
        if (this.getDirectory() != null) {
            String actualFileName = DownloadSnapshotFromServerCommand.getSnapshotFileName((ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider(), (TFile)this.getDirectory(), (String)fileNameCandidate);
            this.setFileName(actualFileName);
        } else {
            this.setFileName(fileNameCandidate);
        }
    }

    @Override
    protected OperationResultWithOutcome<List<SnapshotInfo>> executeRequest(ISonargraphEnterpriseProvider enterpriseExtension, ISonargraphEnterpriseProvider.IEnterpriseInfoProvider infoProvider) {
        assert (enterpriseExtension != null) : "Parameter 'enterpriseExtension' of method 'executeRequest' must not be null";
        assert (infoProvider != null) : "Parameter 'infoProvider' of method 'executeRequest' must not be null";
        OperationResultWithOutcome snapshotsResult = enterpriseExtension.listSnapshots(this.getRemoteSystem().getId(), this.getRemoteSystem().getName(), infoProvider);
        if (snapshotsResult == null || snapshotsResult.getOutcome() == null) {
            UserInterfaceAdapter.getInstance().error("Failed to Load Snapshots", "No snapshots could be loaded from Sonargraph-Enterprise server.");
        } else if (((List)snapshotsResult.getOutcome()).isEmpty()) {
            UserInterfaceAdapter.getInstance().error("Failed to Load Snapshots", "There are no snapshots available on Sonargraph-Enterprise server.");
        }
        return snapshotsResult;
    }
}

