/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.enterprise.AbstractDownloadFromServerCommand;
import com.hello2morrow.sonargraph.core.command.enterprise.DownloadSnapshotFromServerCommand;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.AttachSnapshotCommand;
import com.hello2morrow.sonargraph.core.command.system.LoadSnapshotCommand;
import com.hello2morrow.sonargraph.core.model.enterprise.IConnectionValidator;
import com.hello2morrow.sonargraph.core.model.enterprise.ISonargraphEnterpriseProvider;
import com.hello2morrow.sonargraph.core.model.enterprise.RemoteSystemInfo;
import com.hello2morrow.sonargraph.core.model.enterprise.SnapshotInfo;
import com.hello2morrow.sonargraph.core.model.enterprise.SonargraphEnterpriseConnection;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionConsumer;
import com.hello2morrow.sonargraph.foundation.utilities.IConnectionConsumer;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.StandaloneProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenInteraction;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.AbstractRequestRemoteInfoWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.ConnectionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.RemoteSnapshotWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.RemoteSystemWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.SnapshotActionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.SonargraphEnterprisePreferenceProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.ActivityEventBasedWorkerContext;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.widgets.Control;

final class DownloadSnapshotWizard
extends NonLazySonargraphWizard
implements IPageChangingListener,
IPageChangedListener {
    private SonargraphEnterprisePreferenceProvider m_preferenceProvider;
    private ConnectionWizardPage m_connectionWizardPage;
    private RemoteSystemWizardPage m_remoteSystemWizardPage;
    private RemoteSnapshotWizardPage m_remoteSnapshotWizardPage;
    private SnapshotActionWizardPage m_actionWizardPage;
    private final ISoftwareSystemProvider m_systemProvider;

    public DownloadSnapshotWizard(ISoftwareSystemProvider systemProvider) {
        super("Download Snapshot from Sonargraph-Enterprise");
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'DownloadSnapshotWizard' must not be null";
        this.m_systemProvider = systemProvider;
    }

    public void addPages() {
        this.m_preferenceProvider = new SonargraphEnterprisePreferenceProvider();
        Installation installation = this.m_systemProvider.getInstallation();
        ISonargraphEnterpriseProvider enterpriseExtension = (ISonargraphEnterpriseProvider)installation.getExtension(ISonargraphEnterpriseProvider.class);
        SonargraphEnterpriseConnection connectionData = this.m_preferenceProvider.loadConnectionData();
        IConnectionValidator validator = enterpriseExtension.getConnectionValidator();
        this.m_connectionWizardPage = new ConnectionWizardPage(validator, connectionData);
        this.addPage((SonargraphWizardPage)this.m_connectionWizardPage);
        StandaloneProxySettingsProvider proxyProvider = new StandaloneProxySettingsProvider();
        ProxySettings proxySettings = proxyProvider.getProxySettings(true);
        this.m_remoteSystemWizardPage = new RemoteSystemWizardPage(this.m_systemProvider, enterpriseExtension, proxySettings);
        this.addPage((SonargraphWizardPage)this.m_remoteSystemWizardPage);
        this.m_remoteSnapshotWizardPage = new RemoteSnapshotWizardPage(enterpriseExtension, proxySettings, this.m_preferenceProvider.getSnapshotDirectory());
        this.addPage((SonargraphWizardPage)this.m_remoteSnapshotWizardPage);
        this.m_actionWizardPage = new SnapshotActionWizardPage();
        this.addPage((SonargraphWizardPage)this.m_actionWizardPage);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            SonargraphEnterpriseConnection connection = this.m_connectionWizardPage.getConnectionData();
            this.m_preferenceProvider.saveConnectionData(connection.getServer(), connection.getPort(), connection.getClientKey(), connection.useProxy());
            this.m_preferenceProvider.saveSnapshotDirectory(this.m_remoteSnapshotWizardPage.getTargetFile().getParentFile());
            this.m_preferenceProvider.saveAction(this.m_actionWizardPage.getSelectedAction());
            TFile targetFile = this.m_remoteSnapshotWizardPage.getTargetFile();
            switch (this.m_actionWizardPage.getSelectedAction()) {
                case OPEN_FROM_SNAPSHOT: {
                    this.openFromSnapshot(targetFile);
                    break;
                }
                case ATTACH_SNAPSHOT: {
                    assert (this.m_systemProvider.hasSoftwareSystem()) : "Missing software system for attaching snapshot!";
                    this.attachSnapshot(targetFile);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private void openFromSnapshot(final TFile targetFile) {
        assert (targetFile != null) : "Parameter 'targetFile' of method 'openFromSnapshot' must not be null";
        LoadSnapshotCommand loadSnapshotCommand = new LoadSnapshotCommand(this.m_systemProvider, (AbstractOpenCommand.IOpenInteraction)new OpenInteraction(){

            public boolean collectOpenData(AbstractOpenCommand.OpenData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collectOpenData' must not be null");
                }
                data.setLocation(targetFile);
                return true;
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)loadSnapshotCommand);
    }

    private void attachSnapshot(TFile snapshotFile) {
        assert (snapshotFile != null) : "Parameter 'snapshotFile' of method 'attachSnapshot' must not be null";
        AttachSnapshotCommand attachSnapshotCommand = new AttachSnapshotCommand(this.m_systemProvider, (AttachSnapshotCommand.IAttachSnapshotInteraction)new AttachSnapshotInteraction(snapshotFile));
        UserInterfaceAdapter.getInstance().run((Command)attachSnapshotCommand);
    }

    public void handlePageChanging(final PageChangingEvent event) {
        assert (event != null) : "Parameter 'event' of method 'handlePageChanging' must not be null";
        if (event.getCurrentPage() instanceof AbstractRequestRemoteInfoWizardPage) {
            ((AbstractRequestRemoteInfoWizardPage)((Object)event.getCurrentPage())).disableEscapeKeyListener();
        }
        if (event.getCurrentPage() == this.m_remoteSnapshotWizardPage && event.getTargetPage() == this.m_actionWizardPage) {
            UserInterfaceAdapter.Feedback feedback;
            final SonargraphEnterpriseConnection connection = this.m_connectionWizardPage.getConnectionData();
            final RemoteSystemInfo systemInfo = (RemoteSystemInfo)this.m_remoteSystemWizardPage.getSelection();
            final SnapshotInfo snapshotInfo = (SnapshotInfo)this.m_remoteSnapshotWizardPage.getSelection();
            final TFile targetFile = this.m_remoteSnapshotWizardPage.getTargetFile();
            StandaloneProxySettingsProvider proxyProvider = new StandaloneProxySettingsProvider();
            final ProxySettings proxySettings = proxyProvider.getProxySettings(true);
            boolean download = targetFile.exists() ? (feedback = UserInterfaceAdapter.getInstance().question("Snapshot file already exists. Do you want to download again?", false)) == UserInterfaceAdapter.Feedback.CONFIRMED : true;
            if (download) {
                ActivityEventBasedWorkerContext cancelableWorkerContext = new ActivityEventBasedWorkerContext(this.m_systemProvider);
                final OperationResultWithOutcome commandResult = new OperationResultWithOutcome("Downloading snapshot");
                DownloadSnapshotFromServerCommand downloadCommand = new DownloadSnapshotFromServerCommand(this.m_systemProvider, (AbstractDownloadFromServerCommand.IInteraction)new AbstractDownloadFromServerCommand.IInteraction<SnapshotInfo>((IWorkerContext)cancelableWorkerContext){
                    private final /* synthetic */ IWorkerContext val$cancelableWorkerContext;
                    {
                        this.val$cancelableWorkerContext = iWorkerContext;
                    }

                    public void processResult(OperationResultWithOutcome<TFile> result) {
                        if (result.isFailure()) {
                            event.doit = false;
                            UserInterfaceAdapter.getInstance().process(result);
                        } else {
                            commandResult.setOutcome((Object)((TFile)result.getOutcome()));
                        }
                    }

                    public boolean collect(AbstractDownloadFromServerCommand.CommandInteractionData<SnapshotInfo> data) {
                        data.setInfoProvider(DownloadSnapshotFromServerCommand.getInfoProvider((ISoftwareSystemProvider)DownloadSnapshotWizard.this.m_systemProvider, (SonargraphEnterpriseConnection)connection, (ProxySettings)proxySettings, (IConnectionConsumer)new HttpConnectionConsumer(){

                            public boolean hasBeenCanceled() {
                                return val$cancelableWorkerContext.hasBeenCanceled();
                            }
                        }));
                        data.setRemoteSystem(systemInfo);
                        data.setRemoteInfo((Object)snapshotInfo);
                        data.setTargetFile(targetFile);
                        return true;
                    }
                });
                UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)downloadCommand, (IWorkerContext)cancelableWorkerContext);
                if (commandResult.getOutcome() != null) {
                    this.m_actionWizardPage.setTargetFile((TFile)commandResult.getOutcome());
                }
                if (cancelableWorkerContext.hasBeenCanceled()) {
                    event.doit = false;
                }
            } else {
                this.m_actionWizardPage.setTargetFile(targetFile);
            }
        }
    }

    public void pageChanged(PageChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'pageChanged' must not be null";
        IWizardContainer container = this.getContainer();
        if (container != null) {
            SwtUtility.consumeUiEvents((Control)container.getShell());
        }
        if (event.getSelectedPage() == this.m_remoteSystemWizardPage) {
            SonargraphEnterpriseConnection connection = this.m_connectionWizardPage.getConnectionData();
            boolean changedConnection = this.m_remoteSystemWizardPage.setConnection(connection);
            if (changedConnection) {
                this.m_remoteSystemWizardPage.execute();
            }
        } else if (event.getSelectedPage() == this.m_remoteSnapshotWizardPage) {
            SonargraphEnterpriseConnection connection = this.m_connectionWizardPage.getConnectionData();
            boolean changedConnection = this.m_remoteSnapshotWizardPage.setConnection(connection);
            RemoteSystemInfo remoteSystem = (RemoteSystemInfo)this.m_remoteSystemWizardPage.getSelection();
            boolean changedSystem = this.m_remoteSnapshotWizardPage.updateInfo(remoteSystem);
            if (changedConnection || changedSystem) {
                this.m_remoteSnapshotWizardPage.execute();
            }
        } else if (event.getSelectedPage() == this.m_actionWizardPage) {
            boolean enableAttach;
            RemoteSystemInfo remoteSystem = (RemoteSystemInfo)this.m_remoteSystemWizardPage.getSelection();
            if (this.m_systemProvider.hasSoftwareSystem()) {
                SoftwareSystem currentSystem = this.m_systemProvider.getSoftwareSystem();
                boolean idMatches = currentSystem.getId().equals(remoteSystem.getId()) || remoteSystem.getId().equals(remoteSystem.getName()) && remoteSystem.getName().equals(currentSystem.getName());
                enableAttach = idMatches && currentSystem.getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT;
            } else {
                enableAttach = false;
            }
            SnapshotActionWizardPage.SnapshotAction preferredAction = this.m_preferenceProvider.getSnapshotAction(SnapshotActionWizardPage.SnapshotAction.OPEN_FROM_SNAPSHOT);
            if (preferredAction == SnapshotActionWizardPage.SnapshotAction.ATTACH_SNAPSHOT && !enableAttach) {
                preferredAction = SnapshotActionWizardPage.SnapshotAction.OPEN_FROM_SNAPSHOT;
            }
            this.m_actionWizardPage.enableAttachSnapshotAction(enableAttach, preferredAction);
        }
    }

    private static final class AttachSnapshotInteraction
    extends SaveCommandInteraction
    implements AttachSnapshotCommand.IAttachSnapshotInteraction {
        private final TFile m_snapshotFile;

        AttachSnapshotInteraction(TFile snapshotFile) {
            super(true);
            assert (snapshotFile != null) : "Parameter 'snapshotFile' of method 'AttachSnapshotInteraction' must not be null";
            this.m_snapshotFile = snapshotFile;
        }

        public boolean collect(AttachSnapshotCommand.SnapshotData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            data.setFilePath(this.m_snapshotFile.getNormalizedAbsolutePath());
            return true;
        }

        public boolean confirm(String message) {
            assert (message != null && message.length() > 0) : "Parameter 'message' of method 'confirm' must not be empty";
            return UserInterfaceAdapter.getInstance().question(message, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }

        public void processAttachResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processAttachResult' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

