/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.RequestMetricValuesCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.dashboard.Box;
import com.hello2morrow.sonargraph.core.model.dashboard.BoxElement;
import com.hello2morrow.sonargraph.core.model.dashboard.Dashboard;
import com.hello2morrow.sonargraph.core.model.dashboard.IDashboardProvider;
import com.hello2morrow.sonargraph.core.model.dashboard.Row;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IIssueFilter;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerExecutionLevelChangedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersFinishedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersStartedEvent;
import com.hello2morrow.sonargraph.core.model.event.MetricValuesAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpRegistry;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.BoxComposite;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.LastRecentlyUsedSystemsWidget;
import com.hello2morrow.sonargraph.ui.swt.base.HorizontalSeparator;
import com.hello2morrow.sonargraph.ui.swt.base.LinkWithImage;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.ISoftwareSystemView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SoftwareSystemView
extends WorkbenchView
implements ISoftwareSystemView,
BoxComposite.IContentChangedListener,
IOriginator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoftwareSystemView.class);
    private static final String INSTALLATION_ISSUES = "Installation Issues";
    private final List<BoxComposite> m_boxViews = new ArrayList<BoxComposite>();
    private ScrolledComposite m_scrolledComposite;
    private Composite m_scrolledCompositeContent;
    private Composite m_header;
    private LinkWithImage m_installationIssues;
    private LinkWithImage m_systemOpen;
    private LinkWithImage m_systemOpenSnapshot;
    private LinkWithImage m_systemRefresh;
    private LinkWithImage m_systemClear;
    private LinkWithImage m_systemClose;
    private LinkWithImage m_userManual;
    private LinkWithImage m_hello2morrowBlog;
    private HorizontalSeparator m_systemDashboardSeparator;
    private Composite m_dashboardComposite;
    private GridData m_dashboardLayoutData;
    private Composite m_systemDashboardContent;
    private LastRecentlyUsedSystemsWidget m_lastUsedSystems;
    private GridData m_lastUsedSystemsGridData;

    public IViewId getViewId() {
        return ViewId.SOFTWARE_SYSTEM_VIEW;
    }

    private void reLayout() {
        if (this.m_lastUsedSystems.isVisible()) {
            this.m_lastUsedSystems.layout(true, true);
        }
        if (this.m_dashboardComposite.isVisible()) {
            this.m_dashboardComposite.layout(true, true);
        }
        this.m_scrolledCompositeContent.layout(true, true);
        this.m_scrolledComposite.layout(true, true);
        this.m_scrolledComposite.setMinSize(this.m_scrolledCompositeContent.computeSize(-1, -1));
    }

    private void executeCommand(String commandId) {
        assert (commandId != null && commandId.length() > 0) : "Parameter 'commandId' of method 'executeCommand' must not be empty";
        ECommandService commandService = (ECommandService)this.getEclipseContext().get(ECommandService.class);
        org.eclipse.core.commands.Command command = commandService.getCommand(commandId);
        if (command != null && command.isEnabled()) {
            EHandlerService handlerService = (EHandlerService)this.getEclipseContext().get(EHandlerService.class);
            ParameterizedCommand parameterizedCommand = commandService.createCommand(commandId, Collections.emptyMap());
            if (parameterizedCommand != null) {
                handlerService.executeHandler(parameterizedCommand);
            }
        }
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.m_scrolledComposite = new ScrolledComposite(viewContentArea, 768);
        this.m_scrolledComposite.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_scrolledCompositeContent = new Composite((Composite)this.m_scrolledComposite, 0);
        this.m_scrolledCompositeContent.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_scrolledCompositeContent.setLayout((Layout)new GridLayout(1, false));
        this.m_scrolledCompositeContent.setBackgroundMode(2);
        this.m_header = new Composite(this.m_scrolledCompositeContent, 0);
        this.m_header.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_header.setLayout((Layout)new GridLayout(8, false));
        this.m_installationIssues = new LinkWithImage(this.m_header, INSTALLATION_ISSUES, "Installation");
        this.m_installationIssues.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_installationIssues.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                RcpUtility.activateView((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (EPartService)WorkbenchRegistry.getInstance().getPartService(), (IViewId)ViewId.ISSUES_VIEW);
            }
        });
        this.m_systemOpen = new LinkWithImage(this.m_header, "Open", "OpenSystem");
        this.m_systemOpen.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_systemOpen.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                SoftwareSystemView.this.executeCommand("com.hello2morrow.sonargraph.standalone.command.openSoftwareSystem");
            }
        });
        this.m_systemOpenSnapshot = new LinkWithImage(this.m_header, "Open Snapshot", "LoadSnapshot");
        this.m_systemOpenSnapshot.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_systemOpenSnapshot.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                SoftwareSystemView.this.executeCommand("com.hello2morrow.sonargraph.standalone.command.openSoftwareSystemFromSnapshot");
            }
        });
        this.m_systemRefresh = new LinkWithImage(this.m_header, "Refresh", "Refresh");
        this.m_systemRefresh.setEnabled(false);
        this.m_systemRefresh.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_systemRefresh.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                SoftwareSystemView.this.executeCommand("com.hello2morrow.sonargraph.standalone.command.refreshSoftwareSystem");
            }
        });
        this.m_systemClear = new LinkWithImage(this.m_header, "Clear", "Clear");
        this.m_systemClear.setEnabled(false);
        this.m_systemClear.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_systemClear.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                SoftwareSystemView.this.executeCommand("com.hello2morrow.sonargraph.standalone.command.clearSoftwareSystem");
            }
        });
        this.m_systemClose = new LinkWithImage(this.m_header, "Close", "Close");
        this.m_systemClose.setEnabled(false);
        this.m_systemClose.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_systemClose.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                SoftwareSystemView.this.executeCommand("com.hello2morrow.sonargraph.standalone.command.closeSoftwareSystem");
            }
        });
        this.m_userManual = new LinkWithImage(this.m_header, "User Manual", "Help");
        this.m_userManual.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_userManual.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)HelpRegistry.getInstance().getUrlForLocalHtmlFile("motivation.html"));
            }
        });
        this.m_hello2morrowBlog = new LinkWithImage(this.m_header, "Blog", "Blog");
        this.m_hello2morrowBlog.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_hello2morrowBlog.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)"http://blog.hello2morrow.com");
            }
        });
        this.m_systemDashboardSeparator = new HorizontalSeparator(this.m_header, " No System Opened ");
        this.m_systemDashboardSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 8, 1));
        this.m_lastUsedSystems = new LastRecentlyUsedSystemsWidget(this.m_scrolledCompositeContent, this.getEclipseContext(), this.getSoftwareSystemProvider());
        this.m_lastUsedSystemsGridData = new GridData(4, 4, true, true);
        this.m_lastUsedSystems.setLayoutData(this.m_lastUsedSystemsGridData);
        this.m_lastUsedSystems.recreateEntries();
        this.m_dashboardComposite = new Composite(this.m_scrolledCompositeContent, 0);
        this.m_dashboardComposite.setLayout((Layout)new GridLayout(1, false));
        this.m_dashboardLayoutData = new GridData(4, 4, true, false);
        this.m_dashboardComposite.setLayoutData((Object)this.m_dashboardLayoutData);
        this.m_dashboardComposite.setVisible(false);
        this.m_scrolledComposite.setContent((Control)this.m_scrolledCompositeContent);
        this.m_scrolledComposite.setExpandVertical(true);
        this.m_scrolledComposite.setExpandHorizontal(true);
        EventManager.getInstance().attach((EventHandler)new EventHandler<MetricValuesAvailableEvent>(MetricValuesAvailableEvent.class, (Object)this){

            public void handleEvent(MetricValuesAvailableEvent event) {
                if (SoftwareSystemView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    LOGGER.debug("Received metric values available event");
                    SoftwareSystemView.this.handleMetricValuesAvailableEvent(event);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersStartedEvent>(AnalyzersStartedEvent.class, (Object)this){

            public void handleEvent(AnalyzersStartedEvent event) {
                if (SoftwareSystemView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    SoftwareSystemView.this.notifyCalculationStateChanged(true);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersFinishedEvent>(AnalyzersFinishedEvent.class, (Object)this){

            public void handleEvent(AnalyzersFinishedEvent event) {
                if (SoftwareSystemView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    SoftwareSystemView.this.notifyCalculationStateChanged(false);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultAvailableEvent>(AnalyzerResultAvailableEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultAvailableEvent event) {
                if (SoftwareSystemView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    if (event.getResult().getId() == CoreAnalyzerId.SYSTEM_DIFF) {
                        SoftwareSystemView.this.handleSystemDiff((SoftwareSystemDiff)event.getResult().getUniqueChild(SoftwareSystemDiff.class));
                    }
                    if (event.getResult().getId() == CoreAnalyzerId.QUALITY_GATES) {
                        SoftwareSystemView.this.handleQualityGateInfo(event.getResult().getChildren(QualityGateResult.class));
                    }
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultClearedEvent>(AnalyzerResultClearedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultClearedEvent event) {
                if (SoftwareSystemView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    if (event.contains((IAnalyzerId)CoreAnalyzerId.SYSTEM_DIFF)) {
                        SoftwareSystemView.this.handleSystemDiff(null);
                    }
                    if (event.contains((IAnalyzerId)CoreAnalyzerId.QUALITY_GATES)) {
                        SoftwareSystemView.this.handleQualityGateInfo(null);
                    }
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerExecutionLevelChangedEvent>(AnalyzerExecutionLevelChangedEvent.class, (Object)this){

            public void handleEvent(AnalyzerExecutionLevelChangedEvent event) {
                if (SoftwareSystemView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    SoftwareSystemView.this.handleAnalyzerExecutionLevelChanged();
                }
            }
        });
        this.showLastUsedSystems(!this.getSoftwareSystemProvider().hasSoftwareSystem());
        this.reLayout();
    }

    private Composite createDashboard(Composite parent, Dashboard dashboard, SoftwareSystem system, Collection<Issue> issues, IMetricsProvider metricsProvider, Set<IMetricDescriptor> metricDescriptors) {
        assert (parent != null) : "Parameter 'parent' of method 'createDashboard' must not be null";
        assert (dashboard != null) : "Parameter 'dashboard' of method 'createDashboard' must not be null";
        assert (system != null) : "Parameter 'system' of method 'createDashboard' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'createDashboard' must not be null";
        assert (metricsProvider != null) : "Parameter 'metricsProvider' of method 'createDashboard' must not be null";
        assert (metricDescriptors != null) : "Parameter 'metricDescriptors' of method 'createDashboard' must not be null";
        Composite dashboardComposite = new Composite(parent, 0);
        dashboardComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, true);
        dashboardComposite.setLayout((Layout)gridLayout);
        boolean showTrend = ((ISystemDiffProvider)system.getExtension(ISystemDiffProvider.class)).getActiveBaselineFile() != null;
        int firstColumnWidth = this.computeFirstColumnWidth(dashboard, dashboardComposite);
        for (Row nextRow : dashboard.getChildren(Row.class)) {
            for (Box box : nextRow.getChildren(Box.class)) {
                BoxComposite nextBoxView = new BoxComposite(dashboardComposite, box, system, issues, metricsProvider, metricDescriptors, showTrend, firstColumnWidth);
                nextBoxView.setLayoutData(new GridData(4, 4, true, true));
                nextBoxView.setContentChangedListener(this);
                this.m_boxViews.add(nextBoxView);
            }
        }
        return dashboardComposite;
    }

    private int computeFirstColumnWidth(Dashboard dashboard, Composite composite) {
        GC gc = new GC((Drawable)composite);
        gc.setFont(composite.getFont());
        int maxLength = 0;
        int maxWidth = 0;
        for (Row nextRow : dashboard.getChildren(Row.class)) {
            for (Box nextBox : nextRow.getChildren(Box.class)) {
                for (BoxElement nextElement : nextBox.getChildren(BoxElement.class)) {
                    int length;
                    if (nextElement.getLabel() == null || (length = nextElement.getLabel().length()) <= maxLength - 10) continue;
                    int width = gc.textExtent((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u00012"}, (String)nextElement.getLabel()))).x;
                    if (width > maxWidth) {
                        maxWidth = width;
                    }
                    if (length <= maxLength) continue;
                    maxLength = length;
                }
            }
        }
        gc.dispose();
        return maxWidth;
    }

    private void handleMetricValuesAvailableEvent(MetricValuesAvailableEvent event) {
        assert (event != null) : "Parameter 'event' of method 'handleMetricValuesAvailableEvent' must not be null";
        IMetricsProvider metricsProvider = (IMetricsProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IMetricsProvider.class);
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        assert (softwareSystem != null) : "'softwareSystem' of method 'handleMetricValuesAvailableEvent' must not be null";
        boolean showTrend = ((ISystemDiffProvider)softwareSystem.getExtension(ISystemDiffProvider.class)).getActiveBaselineFile() != null;
        SoftwareSystemDiff systemDiff = ((ISystemDiffProvider)softwareSystem.getExtension(ISystemDiffProvider.class)).getSoftwareSystemDiff();
        boolean resetTrend = systemDiff == null;
        for (BoxComposite nextBox : this.m_boxViews) {
            nextBox.processAvailableMetricValues(this.getSoftwareSystem(), metricsProvider, event, showTrend, resetTrend);
        }
        SoftwareSystemDiff diff = ((ISystemDiffProvider)this.getSoftwareSystem().getExtension(ISystemDiffProvider.class)).getSoftwareSystemDiff();
        if (diff != null) {
            this.handleSystemDiff(diff);
        }
    }

    private void handleAnalyzerExecutionLevelChanged() {
        for (BoxComposite nextBoxView : this.m_boxViews) {
            nextBoxView.handleAnalyzerExecutionLevelChanged();
        }
    }

    private void handleSystemDiff(SoftwareSystemDiff systemDiff) {
        SoftwareSystem system = this.getSoftwareSystem();
        assert (system != null) : "'system' of method 'handleSystemDiff' must not be null";
        if (systemDiff == null) {
            boolean isSystemDiffEnabled = ((ISystemDiffProvider)system.getExtension(ISystemDiffProvider.class)).getActiveBaselineFile() != null;
            for (BoxComposite nextBoxView : this.m_boxViews) {
                nextBoxView.clearTrendInfo(system, isSystemDiffEnabled);
            }
        } else {
            ISystemDiffProvider systemDiffProvider = (ISystemDiffProvider)system.getExtension(ISystemDiffProvider.class);
            IMetricsProvider metricsProvider = (IMetricsProvider)WorkbenchRegistry.getInstance().getProvider().getInstallation().getExtension(IMetricsProvider.class);
            for (BoxComposite nextBoxView : this.m_boxViews) {
                nextBoxView.processSystemDiff(system, systemDiffProvider, systemDiff, metricsProvider);
            }
        }
    }

    protected void handleQualityGateInfo(List<QualityGateResult> qualityGateResults) {
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'handleQualityGateInfo' must not be null";
        for (BoxComposite nextBoxView : this.m_boxViews) {
            nextBoxView.processQualityGateStatus(qualityGateResults, softwareSystem);
        }
    }

    private void notifyCalculationStateChanged(boolean calculating) {
        SoftwareSystem system = this.getSoftwareSystem();
        assert (system != null) : "'system' of method 'notifyCalculationStateChanged' must not be null";
        for (BoxComposite nextBoxView : this.m_boxViews) {
            nextBoxView.calculationStateChanged(system, calculating);
        }
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(MetricValuesAvailableEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzersStartedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzersFinishedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultAvailableEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultClearedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerExecutionLevelChangedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    protected void installationModified() {
        IssueFilter filter = new IssueFilter(new IStandardEnumeration[0]);
        filter.add((IStandardEnumeration)IssueCategory.INSTALLATION_CONFIGURATION);
        int issues = WorkbenchRegistry.getInstance().getProvider().getInstallation().getCurrentModel().getIssueList((IIssueFilter)filter).getNumberOfIssues();
        this.m_installationIssues.setText("Installation Issues (" + issues + ")");
    }

    public List<Element> getSelectedElements() {
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        return softwareSystem != null ? Collections.singletonList(softwareSystem) : Collections.emptyList();
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.getContentArea().setRedraw(false);
        this.m_systemRefresh.setEnabled(false);
        this.m_systemClear.setEnabled(false);
        this.m_systemClose.setEnabled(false);
        this.m_systemDashboardSeparator.reset();
        this.m_dashboardComposite.setVisible(false);
        if (this.m_systemDashboardContent != null) {
            this.m_systemDashboardContent.dispose();
            this.m_systemDashboardContent = null;
        }
        this.m_boxViews.clear();
        this.showLastUsedSystems(true);
        this.reLayout();
        this.getContentArea().setRedraw(true);
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        SoftwareSystem system = this.getSoftwareSystem();
        assert (system != null) : "'system' of method 'softwareSystemShow' must not be null";
        this.getContentArea().setRedraw(false);
        this.showLastUsedSystems(false);
        this.m_systemRefresh.setEnabled(SonargraphCommand.isAvailable((ICommandId)CoreCommandId.REFRESH_SOFTWARE_SYSTEM, (SoftwareSystem)system));
        this.m_systemRefresh.setForeground(UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_BLUE));
        this.m_systemClear.setEnabled(SonargraphCommand.isAvailable((ICommandId)CoreCommandId.CLEAR_SOFTWARE_SYSTEM, (SoftwareSystem)system));
        this.m_systemClear.setForeground(UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_BLUE));
        this.m_systemClose.setEnabled(true);
        this.m_systemClose.setForeground(UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_BLUE));
        this.updateDashboarSeparator(system);
        Collection issues = system.getCurrentModel().getAllIssues(false, false, false);
        Dashboard currentDashboard = ((IDashboardProvider)system.getExtension(IDashboardProvider.class)).getDashboard();
        IMetricsProvider metricsProvider = (IMetricsProvider)WorkbenchRegistry.getInstance().getProvider().getInstallation().getExtension(IMetricsProvider.class);
        THashSet metricDescriptors = new THashSet();
        this.m_systemDashboardContent = this.createDashboard(this.m_dashboardComposite, currentDashboard, system, issues, metricsProvider, (Set<IMetricDescriptor>)metricDescriptors);
        this.m_dashboardComposite.setVisible(true);
        this.reLayout();
        this.getContentArea().setRedraw(true);
        if (!metricDescriptors.isEmpty()) {
            LOGGER.debug("Request metric values...");
            UserInterfaceAdapter.getInstance().run((Command)new RequestMetricValuesCommand(this.getSoftwareSystemProvider(), (Set)metricDescriptors, (NamedElement)system, false, (IOriginator)this));
        }
        this.handleQualityGateInfo(Collections.emptyList());
        super.softwareSystemShow(mode);
    }

    private void collectAndRequestMetricValues() {
        IMetricsProvider metricsProvider = (IMetricsProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IMetricsProvider.class);
        THashSet metricDescriptors = new THashSet();
        for (BoxComposite nextBox : this.m_boxViews) {
            nextBox.collectNeededMetricDescriptors(metricsProvider, (Set<IMetricDescriptor>)metricDescriptors);
        }
        if (!metricDescriptors.isEmpty()) {
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'collectAndRequestMetricValues' must not be null";
            UserInterfaceAdapter.getInstance().run((Command)new RequestMetricValuesCommand(this.getSoftwareSystemProvider(), (Set)metricDescriptors, (NamedElement)softwareSystem, false, (IOriginator)this));
        }
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        THashSet metricDescriptors;
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        SoftwareSystem system = this.getSoftwareSystem();
        assert (system != null) : "'system' of method 'softwareSystemModified' must not be null";
        Collection issues = system.getCurrentModel().getAllIssues(false, false, false);
        assert (this.m_systemDashboardContent != null) : "'m_systemDashBoardContent' of method 'softwareSystemModified' must not be null";
        this.getContentArea().setRedraw(false);
        if (modification.contains(Modification.AVAILABLE_LANGUAGES_MODIFIED)) {
            this.m_systemDashboardContent.dispose();
            this.m_systemDashboardContent = null;
            this.m_boxViews.clear();
            Dashboard currentDashboard = this.updateDashboarSeparator(system);
            IMetricsProvider metricsProvider = (IMetricsProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IMetricsProvider.class);
            metricDescriptors = new THashSet();
            this.m_systemDashboardContent = this.createDashboard(this.m_dashboardComposite, currentDashboard, system, issues, metricsProvider, (Set<IMetricDescriptor>)metricDescriptors);
            this.m_dashboardComposite.setVisible(true);
        } else {
            metricDescriptors = Collections.emptySet();
            int firstColumnWidth = this.computeFirstColumnWidth(((IDashboardProvider)system.getExtension(IDashboardProvider.class)).getDashboard(), this.m_dashboardComposite);
            for (BoxComposite nextBox : this.m_boxViews) {
                nextBox.softwareSystemModified(system, issues, modification, firstColumnWidth);
            }
            if (!modification.contains(Modification.WORKSPACE_CLEARED)) {
                this.collectAndRequestMetricValues();
            }
        }
        this.reLayout();
        this.getContentArea().setRedraw(true);
        if (!metricDescriptors.isEmpty()) {
            UserInterfaceAdapter.getInstance().run((Command)new RequestMetricValuesCommand(this.getSoftwareSystemProvider(), (Set)metricDescriptors, (NamedElement)system, false, (IOriginator)this));
        }
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    private Dashboard updateDashboarSeparator(SoftwareSystem system) {
        Dashboard currentDashboard = ((IDashboardProvider)system.getExtension(IDashboardProvider.class)).getDashboard();
        this.m_systemDashboardSeparator.set(" " + FileUtility.getFileNameWithoutExtension((TFile)currentDashboard.getFile()) + " ", UiResourceManager.getInstance().getImage("icon_16x16"));
        return currentDashboard;
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        this.getContentArea().setRedraw(false);
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED)) {
            SoftwareSystem system = this.getSoftwareSystem();
            Collection issues = system.getCurrentModel().getAllIssues(false, false, false);
            for (BoxComposite nextBoxView : this.m_boxViews) {
                nextBoxView.analyzerModification(system, issues);
            }
        }
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.METRIC_VALUE_ADDED) || modification.contains(AnalyzerModificationEvent.AnalyzerModification.METRIC_DESCRIPTOR_ADDED)) {
            this.collectAndRequestMetricValues();
        }
        this.getContentArea().setRedraw(true);
        super.analyzerModification(modification, analyzerId);
    }

    public void softwareSystemOpenDataModified() {
        if (this.m_lastUsedSystems.isVisible()) {
            this.getContentArea().setRedraw(false);
            this.m_lastUsedSystems.recreateEntries();
            this.reLayout();
            this.getContentArea().setRedraw(true);
        } else {
            this.m_lastUsedSystems.recreateEntries();
        }
    }

    protected void showLastUsedSystems(boolean show) {
        this.m_lastUsedSystems.setVisible(show);
        this.m_lastUsedSystemsGridData.exclude = !show;
        this.m_dashboardComposite.setVisible(!show);
        this.m_dashboardLayoutData.exclude = show;
        if (show) {
            this.m_lastUsedSystems.recreateEntries();
        }
    }

    @Override
    public void contentChanged() {
        this.getContentArea().setRedraw(false);
        this.reLayout();
        this.getContentArea().setRedraw(true);
    }
}

