/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.RevertModifiedModifiableFilesCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.RevertDialog;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SoftwareSystemBasedHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class RevertModifiableFileHandler
extends SoftwareSystemBasedHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.REVERT;
    }

    @Override
    protected boolean showInContextMenuFor(Element element) {
        assert (element != null) : "Parameter 'element' of method 'showInContextMenuFor' must not be null";
        if (super.showInContextMenuFor(element)) {
            return true;
        }
        return element instanceof ModifiableFile && ((ModifiableFile)element).needsSave();
    }

    @CanExecute
    public boolean canExecute(@Optional MMenuItem menuItem) {
        if (this.isAvailable(menuItem)) {
            return WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.MODIFIABLE_FILE_NEEDS_SAVE});
        }
        return false;
    }

    @Execute
    public void execute() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider != null) : "'provider' of method 'internalExecute' must not be null";
        assert (provider.hasSoftwareSystem()) : "No software system available";
        List modifiableFilesNeedingSave = ((Files)provider.getSoftwareSystem().getUniqueExistingChild(Files.class)).getModifiableFilesNeedingSave();
        assert (!modifiableFilesNeedingSave.isEmpty()) : "No files need save";
        UserInterfaceAdapter.getInstance().run((Command)new RevertModifiedModifiableFilesCommand((RevertModifiedModifiableFilesCommand.IInteraction)new RevertCommandInteraction(), WorkbenchRegistry.getInstance().getProvider()));
    }

    public class RevertCommandInteraction
    implements RevertModifiedModifiableFilesCommand.IInteraction {
        public boolean collect(final RevertModifiedModifiableFilesCommand.ModifiableFilesToBeRevertedData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            RunnableWithResult<Boolean> result = new RunnableWithResult<Boolean>(){

                public void run() {
                    RevertDialog revertDialog = new RevertDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "Revert Modified File(s)", data.getNeedingSave(), data.getNeedingSave(), true);
                    if (revertDialog.open() == 0) {
                        data.setToBeReverted(revertDialog.getToBeSaved());
                        this.setResult(Boolean.TRUE);
                    } else {
                        this.setResult(Boolean.FALSE);
                    }
                }
            };
            return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)result);
        }

        public boolean processModifiableFilesRevertedResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
            return true;
        }
    }
}

