/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.RefreshCommand;
import com.hello2morrow.sonargraph.core.command.system.RefreshSoftwareSystemFilesCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.RefreshSoftwareSystemInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class RefreshSoftwareSystemFilesHandler
extends CommandHandler {
    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                if (!$assertionsDisabled && workbenchView == null) {
                    throw new AssertionError((Object)"Parameter 'workbenchView' of method 'showInContextMenu' must not be null");
                }
                if (!$assertionsDisabled && currentSelection == null) {
                    throw new AssertionError((Object)"Parameter 'currentSelection' of method 'showInContextMenu' must not be null");
                }
                return currentSelection.isEmpty() && workbenchView.getViewId() == ViewId.FILES_VIEW;
            }
        };
    }

    @CanExecute
    public boolean canExecute(@Optional MMenuItem menuItem) {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        boolean available = false;
        if (provider.hasSoftwareSystem()) {
            SoftwareSystemMode mode = provider.getSoftwareSystem().getMode();
            switch (mode) {
                case SYSTEM: {
                    available = CommandHandlerWithCorrespondingCommand.isAvailable((ICommandId)CoreCommandId.REFRESH_SOFTWARE_SYSTEM_FILES);
                    break;
                }
                case SYSTEM_LOADED_FROM_SNAPSHOT: 
                case SYSTEM_ATTACHED_TO_SNAPSHOT: 
                case SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT: {
                    available = false;
                    break;
                }
                default: {
                    assert (false) : "Unhandled mode: " + String.valueOf(mode);
                    available = false;
                }
            }
        }
        RefreshSoftwareSystemFilesHandler.setVisibility((MMenuItem)menuItem, (boolean)available);
        return available;
    }

    @Execute
    public void execute() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        SoftwareSystem softwareSystem = provider.getSoftwareSystem();
        SoftwareSystemMode mode = softwareSystem.getMode();
        switch (mode) {
            case SYSTEM: {
                RefreshSoftwareSystemFilesCommand command = new RefreshSoftwareSystemFilesCommand(provider, (RefreshCommand.IRefreshInteraction)new RefreshSoftwareSystemFilesInteraction(((Files)provider.getSoftwareSystem().getUniqueExistingChild(Files.class)).getSystemDirectory().getFile()));
                UserInterfaceAdapter.getInstance().run((Command)command);
                break;
            }
            case SYSTEM_LOADED_FROM_SNAPSHOT: 
            case SYSTEM_ATTACHED_TO_SNAPSHOT: 
            case SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT: {
                assert (false) : "Unexpected mode: " + String.valueOf(mode);
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf(mode);
                break;
            }
        }
    }

    static final class RefreshSoftwareSystemFilesInteraction
    extends RefreshSoftwareSystemInteraction {
        RefreshSoftwareSystemFilesInteraction(TFile systemDirectory) {
            super(systemDirectory);
        }

        @Override
        public void collectRefreshData(RefreshCommand.RefreshData data) {
            assert (data != null) : "Parameter 'data' of method 'collectRefreshData' must not be null";
        }
    }
}

