/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.LoadSnapshotCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenHandler;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenInteraction;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenSnapshotInAttachedModeDialog;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.FileDialog;

public final class OpenSoftwareSystemFromSnapshotHandler
extends OpenHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.OPEN_SOFTWARE_SYSTEM_FROM_SNAPSHOT;
    }

    @Execute
    public void execute(final IEclipseContext eclipseContext) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'execute' must not be null";
        LoadSnapshotCommand cmd = new LoadSnapshotCommand(WorkbenchRegistry.getInstance().getProvider(), (AbstractOpenCommand.IOpenInteraction)new OpenInteraction(){

            public boolean collectOpenData(AbstractOpenCommand.OpenData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collectOpenData' must not be null");
                }
                RunnableWithResult<String> result = new RunnableWithResult<String>(){

                    public void run() {
                        FileDialog fileDialog = new FileDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), 4096);
                        fileDialog.setText("Sonargraph - Open Snapshot File");
                        ArrayList<CallSite> extensions = new ArrayList<CallSite>(CoreFileType.SNAPSHOT.getExtensions().length);
                        String[] stringArray = CoreFileType.SNAPSHOT.getExtensions();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String next = stringArray[n2];
                            extensions.add((CallSite)((Object)("*" + next)));
                            ++n2;
                        }
                        fileDialog.setFilterExtensions(extensions.toArray(new String[extensions.size()]));
                        fileDialog.setFilterPath(WorkbenchRegistry.getInstance().getProvider().getLocation("LoadSnapshot"));
                        this.setResult(fileDialog.open());
                        WorkbenchRegistry.getInstance().getProvider().setLocation("LoadSnapshot", fileDialog.getFilterPath());
                    }
                };
                UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)result);
                String filePath = (String)result.getResult();
                if (filePath != null && !filePath.isEmpty()) {
                    data.setLocation(new TFile(filePath));
                    return true;
                }
                return false;
            }

            public boolean confirmOpenSnapshotAttached(final AbstractOpenCommand.OpenSnapshotData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'confirmOpenSnapshotAttached' must not be null");
                }
                RunnableWithResult<Boolean> result = new RunnableWithResult<Boolean>(){

                    public void run() {
                        OpenSnapshotInAttachedModeDialog dialog = new OpenSnapshotInAttachedModeDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), data.getDefaultTargetDirectory());
                        if (dialog.open() == 0) {
                            data.setTargetDirectory(dialog.getTargetDirectory());
                            this.setResult(Boolean.TRUE);
                        } else {
                            this.setResult(Boolean.FALSE);
                        }
                    }
                };
                UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)result);
                return (Boolean)result.getResult();
            }

            public boolean confirmFileReplaceInOpenSnapshotAttached(String question) {
                if (!($assertionsDisabled || question != null && question.length() > 0)) {
                    throw new AssertionError((Object)"Parameter 'question' of method 'confirmTargetSystemDirectoryReplaceInOpenSnapshotAttached' must not be empty");
                }
                return UserInterfaceAdapter.getInstance().question(question, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)cmd, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                OpenSoftwareSystemFromSnapshotHandler.finishExecute(eclipseContext);
                super.consume(exception);
            }
        });
    }
}

