/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.OpenSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.LoadLastSnapshotOnOpenHandler;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenHandler;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenInteraction;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.RefreshSoftwareSystemOnOpenHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;

public final class OpenRecentlyUsedSoftwareSystemHandler
extends OpenHandler {
    public static final String COMMAND_ID = "com.hello2morrow.sonargraph.standalone.command.recentlyUsedOpenSoftwareSystem";
    public static final String PARAM_ID_FILE_NAME = "com.hello2morrow.sonargraph.standalone.command.recentlyUsedOpenSoftwareSystem.fileParam";

    public final ICommandId getCorrespondingCommandId() {
        return CoreCommandId.OPEN_SOFTWARE_SYSTEM;
    }

    static void performOpen(final IEclipseContext eclipseContext, final TFile file, final boolean askToCloseCurrentSystem) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'performOpen' must not be null";
        assert (file != null) : "Parameter 'file' of method 'performOpen' must not be null";
        boolean performRefresh = RefreshSoftwareSystemOnOpenHandler.isActive();
        final boolean loadLastSnapshot = LoadLastSnapshotOnOpenHandler.isActive();
        OpenSoftwareSystemCommand cmd = new OpenSoftwareSystemCommand(WorkbenchRegistry.getInstance().getProvider(), (AbstractOpenCommand.IOpenInteraction)new OpenInteraction(){

            @Override
            public boolean closeSoftwareSystem() {
                if (askToCloseCurrentSystem) {
                    return UserInterfaceAdapter.getInstance().question("Close current system?", false) == UserInterfaceAdapter.Feedback.CONFIRMED;
                }
                return true;
            }

            public boolean collectOpenData(AbstractOpenCommand.OpenData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                if (loadLastSnapshot) {
                    data.addFlags(new ISoftwareSystemProvider.OpenOption[]{ISoftwareSystemProvider.OpenOption.READ_SNAPSHOT});
                }
                data.setLocation(file);
                return true;
            }
        }, performRefresh);
        UserInterfaceAdapter.getInstance().run((Command)cmd, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                OpenRecentlyUsedSoftwareSystemHandler.finishExecute(eclipseContext);
                super.consume(exception);
            }
        });
    }

    @Execute
    public void execute(IEclipseContext eclipseContext, @Named(value="com.hello2morrow.sonargraph.standalone.command.recentlyUsedOpenSoftwareSystem.fileParam") String filePath) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'execute' must not be null";
        assert (filePath != null && filePath.length() > 0) : "Parameter 'filePath' of method 'execute' must not be empty";
        OpenRecentlyUsedSoftwareSystemHandler.performOpen(eclipseContext, new TFile(filePath), true);
    }
}

