/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.CloseExtractedAndAttachedSystemDialog;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveCommandInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;

public class CloseCommandInteraction
extends SaveCommandInteraction
implements CloseSoftwareSystemCommand.ICloseInteraction {
    public CloseCommandInteraction(boolean allowCancel) {
        super(allowCancel);
    }

    @Override
    protected boolean askToProceedInCaseOfFailure() {
        return true;
    }

    public boolean closeSoftwareSystem() {
        return UserInterfaceAdapter.getInstance().question("Close current system?", false) == UserInterfaceAdapter.Feedback.CONFIRMED;
    }

    public boolean collectCloseExtractedAndAttachedSystemData(final CloseSoftwareSystemCommand.CloseExtractedAndAttachedSystemData data) {
        assert (data != null) : "Parameter 'data' of method 'collectCloseExtractedAndAttachedSystenData' must not be null";
        RunnableWithResult<Boolean> result = new RunnableWithResult<Boolean>(){

            public void run() {
                CloseExtractedAndAttachedSystemDialog dialog = new CloseExtractedAndAttachedSystemDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), data);
                if (dialog.open() == 0) {
                    this.setResult(Boolean.TRUE);
                } else {
                    this.setResult(Boolean.FALSE);
                }
            }
        };
        UserInterfaceAdapter.getInstance().displayUiElement((Runnable)result);
        return (Boolean)result.getResult();
    }

    public boolean confirmUpdateOfExisitingSnapshot(String message) {
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'confirmUpdateOfExisitingSnapshot' must not be empty";
        return UserInterfaceAdapter.getInstance().question(message, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
    }

    public void processCloseSoftwareSystemResult(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'processCloseSoftwareSystemResult' must not be null";
        UserInterfaceAdapter.getInstance().process(result);
    }
}

