/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ButtonControl {
    private final Map<String, Button> m_buttons = new HashMap<String, Button>();
    private final Composite m_buttonGroupOptions;

    public ButtonControl(Composite container) {
        this.m_buttonGroupOptions = new Composite(container, 0);
        GridData gridData = new GridData(4, 4, false, false);
        this.m_buttonGroupOptions.setLayoutData((Object)gridData);
        this.m_buttonGroupOptions.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
    }

    public void addButton(String name, final Handler handler, boolean enabled) {
        this.addButton(name, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                handler.doIt();
            }
        }, enabled);
    }

    public void addButton(String name, SelectionListener listener, boolean enabled) {
        Button button = new Button(this.m_buttonGroupOptions, 0);
        button.setText(name);
        button.setLayoutData((Object)new GridData(4, 128, false, false));
        button.addSelectionListener(listener);
        button.setEnabled(enabled);
        this.m_buttons.put(name, button);
    }

    public void addPlaceholder() {
        Label placeHolder = new Label(this.m_buttonGroupOptions, 0);
        placeHolder.setText("    ");
    }

    public void setEnabled(String name, boolean enabled) {
        Button button = this.m_buttons.get(name);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    public static interface Handler {
        public void doIt();
    }
}

