/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.model.analysis.AbstractCheckedFilesConfiguration;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.DecoratingImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractFileEntryBeanAdapter<T extends AbstractCheckedFilesConfiguration>
extends BeanPropertyReader.BeanAdapter<String> {
    private final T m_configuration;
    private String m_data;
    private final String m_imageFileName;

    public AbstractFileEntryBeanAdapter(T configuration, String imageFileName) {
        assert (configuration != null) : "Parameter 'configuration' of method 'ArchitectureFileEntryBeanAdapter' must not be null";
        assert (imageFileName != null && imageFileName.length() > 0) : "Parameter 'imageFileName' of method 'AbstractFileEntryBeanAdapter' must not be empty";
        this.m_configuration = configuration;
        this.m_imageFileName = imageFileName;
    }

    protected final void setAdaptedObject(String data) {
        this.m_data = data;
    }

    public final String getFile() {
        return this.m_data;
    }

    public final Image getFileImage() {
        if (this.m_data != null && !this.m_data.isEmpty() && this.m_configuration.getWarning(this.m_data) != null) {
            CompositeImageDescriptor descriptor = new CompositeImageDescriptor(this.m_imageFileName);
            descriptor.addMarker(DecoratingImageDescriptor.Corner.LOWER_RIGHT, "WarningMarker");
            return UiResourceManager.getInstance().getImage(descriptor);
        }
        return UiResourceManager.getInstance().getImage(this.m_imageFileName);
    }

    public final String getFileTooltip() {
        String tooltip = null;
        if (this.m_data != null && !this.m_data.isEmpty()) {
            tooltip = this.m_configuration.getWarning(this.m_data);
        }
        return tooltip;
    }
}

