/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.searchview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.SearchInSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.Path;
import com.hello2morrow.sonargraph.core.model.programming.SearchCriteria;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspace.ComponentContainer;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.searchview.MatchedElementBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.searchview.SearchDialog;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SearchInSoftwareSystemDialog
extends SearchDialog<NamedElement> {
    private PropertyTableViewer<NamedElement> m_matchingNamedElementsListViewer;
    private Text m_searchPattern;
    private Button m_byName;
    private Button m_byFullName;
    private Button m_autoMatchTrailingCharacters;
    private Button m_ignoreCase;
    private Button m_all;
    private Button m_excludedOnly;
    private Button m_issueIgnoringOnly;
    private Button m_omitMembers;
    private Composite m_containedInComposite;
    private GridData m_containedCompositeGridData;
    private Label m_componentContainerImage;
    private Text m_componentContainerText;
    private Label m_parentPathImage;
    private Text m_parentPathText;

    public SearchInSoftwareSystemDialog(Shell parentShell, ISoftwareSystemProvider softwareSystemProvider) {
        super(parentShell, "Search In System", softwareSystemProvider);
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.SEARCH_DIALOG;
    }

    protected void applyData() {
        IEclipsePreferences settings = this.getPreferences("com.hello2morrow.sonargraph.standalone");
        boolean isSearchByFullName = settings.getBoolean(SearchCriteria.FULL_NAME.name(), false);
        this.m_byName.setSelection(!isSearchByFullName);
        this.m_byFullName.setSelection(isSearchByFullName);
        this.m_omitMembers.setSelection(settings.getBoolean(SearchCriteria.OMIT_MEMBERS.name(), true));
        this.m_autoMatchTrailingCharacters.setSelection(settings.getBoolean(SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS.name(), true));
        this.m_ignoreCase.setSelection(settings.getBoolean(SearchCriteria.IGNORE_CASE.name(), true));
        this.m_excludedOnly.setSelection(settings.getBoolean(SearchCriteria.EXCLUDED_ONLY.name(), false));
        this.m_issueIgnoringOnly.setSelection(settings.getBoolean(SearchCriteria.ISSUE_IGNORING_ONLY.name(), false));
        if (this.m_excludedOnly.getSelection() || this.m_issueIgnoringOnly.getSelection()) {
            this.m_all.setSelection(false);
        }
        this.m_searchPattern.setText("*");
        this.m_searchPattern.setSelection(0, this.m_searchPattern.getText().length());
    }

    protected IEclipsePreferences saveData() {
        IEclipsePreferences settings = this.getPreferences("com.hello2morrow.sonargraph.standalone");
        settings.putBoolean(SearchCriteria.FULL_NAME.name(), this.m_byFullName.getSelection());
        settings.putBoolean(SearchCriteria.OMIT_MEMBERS.name(), this.m_omitMembers.getSelection());
        settings.putBoolean(SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS.name(), this.m_autoMatchTrailingCharacters.getSelection());
        settings.putBoolean(SearchCriteria.IGNORE_CASE.name(), this.m_ignoreCase.getSelection());
        settings.putBoolean(SearchCriteria.EXCLUDED_ONLY.name(), this.m_excludedOnly.getSelection());
        settings.putBoolean(SearchCriteria.ISSUE_IGNORING_ONLY.name(), this.m_issueIgnoringOnly.getSelection());
        return settings;
    }

    protected int getNumberOfColumns() {
        return 6;
    }

    protected void fillDialogArea(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createDialogArea' must not be null";
        Label elementStateLabel = new Label(parent, 0);
        elementStateLabel.setText("Elements:");
        elementStateLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Composite elementStateRadioButtonGroup = new Composite(parent, 0);
        elementStateRadioButtonGroup.setLayoutData((Object)new GridData(1, 0x1000000, true, false, this.getNumberOfColumns() - 1, 1));
        elementStateRadioButtonGroup.setLayout((Layout)this.createGridLayout(4));
        this.m_all = new Button(elementStateRadioButtonGroup, 16);
        this.m_all.setText("All");
        this.m_all.setSelection(true);
        this.m_all.addSelectionListener((SelectionListener)this);
        this.m_excludedOnly = new Button(elementStateRadioButtonGroup, 16);
        this.m_excludedOnly.setText("Excluded");
        this.m_excludedOnly.setSelection(false);
        this.m_excludedOnly.addSelectionListener((SelectionListener)this);
        this.m_issueIgnoringOnly = new Button(elementStateRadioButtonGroup, 16);
        this.m_issueIgnoringOnly.setText("Issue ignoring");
        this.m_issueIgnoringOnly.setSelection(false);
        this.m_issueIgnoringOnly.addSelectionListener((SelectionListener)this);
        Label criteriaLabel = new Label(parent, 0);
        criteriaLabel.setText("Search criteria:");
        criteriaLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Composite nameRadioButtonsGroup = new Composite(parent, 0);
        nameRadioButtonsGroup.setLayout((Layout)this.createGridLayout(2));
        this.m_byName = new Button(nameRadioButtonsGroup, 16);
        this.m_byName.setText("Name");
        this.m_byName.setSelection(true);
        this.m_byFullName = new Button(nameRadioButtonsGroup, 16);
        this.m_byFullName.setText("Full name");
        this.m_byFullName.setSelection(false);
        this.m_byName.addSelectionListener((SelectionListener)this);
        this.m_byFullName.addSelectionListener((SelectionListener)this);
        Label additionalOptionsSeparator = new Label(parent, 0);
        additionalOptionsSeparator.setText("| ");
        this.m_autoMatchTrailingCharacters = new Button(parent, 32);
        this.m_autoMatchTrailingCharacters.setText("Auto match trailing characters");
        this.m_autoMatchTrailingCharacters.setSelection(true);
        this.m_autoMatchTrailingCharacters.addSelectionListener((SelectionListener)this);
        this.m_autoMatchTrailingCharacters.setToolTipText("If enabled every pattern is automatically appended with ** to match names starting with the specified pattern");
        this.m_ignoreCase = new Button(parent, 32);
        this.m_ignoreCase.setText("Ignore case");
        this.m_ignoreCase.setSelection(true);
        this.m_ignoreCase.addSelectionListener((SelectionListener)this);
        this.m_omitMembers = new Button(parent, 32);
        this.m_omitMembers.setText("Omit fields/methods");
        this.m_omitMembers.setSelection(true);
        this.m_omitMembers.addSelectionListener((SelectionListener)this);
        Label searchPatternLabel = new Label(parent, 0);
        searchPatternLabel.setText("Search pattern:");
        searchPatternLabel.setToolTipText("Wildcards: ?=any character, *=any sequence between dots or slashes, **=any sequence.\nSearches for components, source files and programming elements.\nTo reveal a found element in the navigation view either select it and press OK or simply double click it.");
        searchPatternLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_searchPattern = new Text(parent, 2048);
        this.m_searchPattern.setLayoutData((Object)new GridData(4, 0x1000000, true, false, this.getNumberOfColumns() - 1, 1));
        this.m_searchPattern.addModifyListener((ModifyListener)this);
        this.m_searchPattern.addVerifyListener((VerifyListener)this);
        this.m_searchPattern.addKeyListener((KeyListener)this);
        this.m_matchingNamedElementsListViewer = new PropertyTableViewer(parent, (BeanPropertyReader.BeanAdapter)new MatchedElementBeanAdapter(), "name", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_matchingNamedElementsListViewer.addColumn("Name", "name", "name", "image", 80, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingNamedElementsListViewer.addColumn(" ", "info", "info", null, 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingNamedElementsListViewer.setLayoutData((Object)new GridData(4, 4, true, true, this.getNumberOfColumns(), 1));
        this.m_matchingNamedElementsListViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_matchingNamedElementsListViewer.getTableViewer().addDoubleClickListener((IDoubleClickListener)this);
        this.m_matchingNamedElementsListViewer.getTable().addKeyListener((KeyListener)this);
        this.m_containedInComposite = new Composite(parent, 0);
        this.m_containedCompositeGridData = new GridData(4, 0x1000000, true, false, this.getNumberOfColumns(), 1);
        this.m_containedInComposite.setLayoutData((Object)this.m_containedCompositeGridData);
        this.m_containedInComposite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin((int)3));
        Label textParentPath = new Label(this.m_containedInComposite, 0);
        textParentPath.setText("Contained in: ");
        textParentPath.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_componentContainerImage = new Label(this.m_containedInComposite, 0);
        this.m_componentContainerImage.setImage(UiResourceManager.getInstance().getImage(Module.IMAGE_RESOURCE_NAME));
        this.m_componentContainerText = new Text(this.m_containedInComposite, 8);
        this.m_componentContainerText.setBackground(this.m_containedInComposite.getBackground());
        this.m_componentContainerText.setLayoutData((Object)new GridData(4, 4, false, false));
        SwtUtility.createFillerForGridLayoutCell((Composite)this.m_containedInComposite);
        this.m_parentPathImage = new Label(this.m_containedInComposite, 0);
        this.m_parentPathText = new Text(this.m_containedInComposite, 72);
        this.m_parentPathText.setBackground(this.m_containedInComposite.getBackground());
        this.m_parentPathText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_containedInComposite.setVisible(false);
        this.m_containedCompositeGridData.exclude = true;
        this.m_searchPattern.setFocus();
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        boolean hasElements;
        super.selectionChanged(event);
        List selected = this.getSelected();
        boolean bl = hasElements = !selected.isEmpty();
        if (hasElements) {
            NamedElement last = (NamedElement)selected.get(selected.size() - 1);
            ComponentContainer componentContainer = (ComponentContainer)last.getParent(ComponentContainer.class, new Class[0]);
            this.m_componentContainerImage.setImage(UiResourceManager.getInstance().getImage((Element)componentContainer));
            this.m_componentContainerText.setText(componentContainer.getName());
            Path parent = (Path)last.getParent(Path.class, new Class[0]);
            this.m_parentPathImage.setImage(UiResourceManager.getInstance().getImage((Element)parent));
            this.m_parentPathText.setText(parent.getIdentifyingPath());
            this.setStatusLineVisible(true);
        } else {
            this.m_componentContainerText.setText("");
            this.m_parentPathText.setText("");
            this.setStatusLineVisible(false);
        }
    }

    private void setStatusLineVisible(boolean isVisible) {
        if (this.m_containedInComposite.isVisible() != isVisible) {
            this.m_containedInComposite.setVisible(isVisible);
            this.m_containedCompositeGridData.exclude = !isVisible;
        }
        this.m_containedInComposite.getParent().layout(true);
    }

    @Override
    protected Text getSearchPatternText() {
        return this.m_searchPattern;
    }

    @Override
    protected PropertyTableViewer<NamedElement> getMatchingElementsViewer() {
        return this.m_matchingNamedElementsListViewer;
    }

    @Override
    protected void validateSearchPattern() {
        String pattern = this.m_searchPattern.getText();
        EnumSet<SearchCriteria> criteria = EnumSet.noneOf(SearchCriteria.class);
        if (this.m_byFullName.getSelection()) {
            criteria.add(SearchCriteria.FULL_NAME);
        }
        if (this.m_excludedOnly.getSelection()) {
            criteria.add(SearchCriteria.EXCLUDED_ONLY);
        }
        if (this.m_issueIgnoringOnly.getSelection()) {
            criteria.add(SearchCriteria.ISSUE_IGNORING_ONLY);
        }
        if (this.m_omitMembers.getSelection()) {
            criteria.add(SearchCriteria.OMIT_MEMBERS);
        }
        if (this.m_autoMatchTrailingCharacters.getSelection()) {
            criteria.add(SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS);
        }
        if (this.m_ignoreCase.getSelection()) {
            criteria.add(SearchCriteria.IGNORE_CASE);
        }
        if (SearchInSoftwareSystemCommand.isPatternValid((ISoftwareSystemProvider)this.getSoftwareSystemProvider(), (String)pattern, criteria)) {
            this.cancelSearch();
            final SearchInSoftwareSystemCommand command = new SearchInSoftwareSystemCommand(this.getSoftwareSystemProvider(), pattern, criteria);
            assert (command.isEnabled().isSuccess()) : "Not enabled: " + String.valueOf(command);
            UserInterfaceAdapter.getInstance().run((Command)command, this.getCurrentWorkerContext((SonargraphCommand)command), new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    super.consume(exception);
                    if (SearchInSoftwareSystemDialog.this.getCurrentCommand() == command && exception == null && SearchInSoftwareSystemDialog.this.getContents() != null && !SearchInSoftwareSystemDialog.this.m_matchingNamedElementsListViewer.isDisposed()) {
                        List result = command.getMatching();
                        SearchInSoftwareSystemDialog.this.m_matchingNamedElementsListViewer.showData((Collection)result);
                    }
                }
            });
        } else {
            this.m_matchingNamedElementsListViewer.showData(Collections.emptyList());
        }
        this.setStatusLineVisible(false);
    }
}

