/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.command.system.script.CompileGroovyScriptCommand;
import com.hello2morrow.sonargraph.core.command.system.script.GroovyScriptData;
import com.hello2morrow.sonargraph.core.command.system.script.RunGroovyScriptCommand;
import com.hello2morrow.sonargraph.core.command.system.script.UpdateAutomatedScriptCommand;
import com.hello2morrow.sonargraph.core.foundation.common.tree.TreeNode;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.AutoCompletionProposal;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileCreatedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ScriptCompiledEvent;
import com.hello2morrow.sonargraph.core.model.event.ScriptExecutedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.history.IUndoRedoEntry;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.programming.AggregatedDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IGroovyProvider;
import com.hello2morrow.sonargraph.core.model.script.IGroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.ScriptResultSet;
import com.hello2morrow.sonargraph.core.model.script.ScriptTreeNode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.AutoCompletionProposalViewer;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.EditableSourceViewWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.IViewWithAutoCompletion;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.IViewWithSourceOperations;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.IViewWithUndoRedo;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SourceViewWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SourceViewWidgetBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.NamedElementViewComparator;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.AggregatedDependencyBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.NamedElementBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.ParserDependencyBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.ScriptSourceViewWidget;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.ScriptTreeNodeContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.ScriptViewContext;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.preview.PreviewIssueBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.preview.PreviewIssueRecord;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.preview.PreviewMetricBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.preview.PreviewMetricRecord;
import com.hello2morrow.sonargraph.ui.standalone.sourceview.SingleSourceView;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.FilteredTreeViewer;
import com.hello2morrow.sonargraph.ui.swt.base.view.Gesture;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithZoom;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ComboWithImages;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchAuxiliaryView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptView
extends SingleSourceView
implements ISelectionChangedListener,
IOriginator,
SelectionListener,
IViewWithSourceOperations,
IViewWithZoom,
IViewWithAutoCompletion,
IViewWithUndoRedo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptView.class);
    private static final String UPDATE_AUTOMATED_SCRIPT = "&Update Automated Script";
    private static final String RUN = "&Run  ";
    private static final String COMPILE = "&Compile";
    private static final String RESULT_VIEW_TITLE_ELEMENTS = "&Elements";
    private static final String RESULT_VIEW_TITLE_AGGREGATED_DEPENDENCIES = "&Aggregated Dependencies";
    private static final String RESULT_VIEW_TITLE_PARSER_DEPENDENCIES = "&Parser Dependencies";
    private static final String RESULT_VIEW_TITLE_TREE = "&Tree";
    private static final String RESULT_VIEW_TITLE_ISSUES = "&Issues Preview";
    private static final String RESULT_VIEW_TITLE_METRICS = "&Metrics Preview";
    private final ScriptViewContext m_context;
    private final boolean m_scriptFeatureLicensed;
    private ScriptSourceViewWidget m_sourceViewWidget;
    private CTabFolder m_bottomTabFolder;
    private CTabItem m_resultElementsTab;
    private CTabItem m_resultAggregatedDependenciesTab;
    private CTabItem m_resultParserDependenciesTab;
    private CTabItem m_resultTreeTab;
    private CTabItem m_resultIssuesTab;
    private CTabItem m_resultMetricsTab;
    private PropertyTableViewer<NamedElement> m_resultElementsView;
    private PropertyTableViewer<AggregatedDependency> m_resultAggregatedDependenciesView;
    private PropertyTableViewer<ParserDependency> m_resultParserDependenciesView;
    private FilteredTreeViewer<ScriptTreeNode> m_resultTreeView;
    private PropertyTableViewer<PreviewIssueRecord> m_resultIssuesView;
    private PropertyTableViewer<PreviewMetricRecord> m_resultMetricsView;
    private ComboWithImages m_runConfigurationCombo;
    private Button m_compileAndRunButton;
    private GroovyScript m_groovyScript;
    private Control m_focusControl;
    private Button m_updateButton;
    private Composite m_updateButtonComposite;
    private Composite m_controlAndResultComposite;
    private SourceViewWidgetBasedTextSearchHandler m_textSearchProvider;

    public ScriptView() {
        EventManager.getInstance().attach((EventHandler)new EventHandler<MultipleModifiableFileModifiedEvent>(MultipleModifiableFileModifiedEvent.class, (Object)this){

            public void handleEvent(MultipleModifiableFileModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ScriptView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    for (IModifiableFile next : event.getModifiableFiles()) {
                        ScriptView.this.handleModifiableFileModifiedEvent(next, event.getModificationTrigger(next), event.getAspects(next));
                    }
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileDeletedEvent>(ModifiableFileDeletedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileDeletedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ScriptView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    ScriptView.this.handleModifiableFileDeletedEvent(event.getModifiableFiles());
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileCreatedEvent>(ModifiableFileCreatedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileCreatedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ScriptView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    ScriptView.this.handleModifiableFileCreatedEvent(event.getModifiableFiles());
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ScriptCompiledEvent>(ScriptCompiledEvent.class, (Object)this){

            public void handleEvent(ScriptCompiledEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ScriptView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    ScriptView.this.handleScriptCompiledEvent((IModifiableFile)event.getModifiableFile());
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ScriptExecutedEvent>(ScriptExecutedEvent.class, (Object)this){

            public void handleEvent(ScriptExecutedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ScriptView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    ScriptView.this.handleScriptExecutedEvent((IModifiableFile)event.getModifiableFile());
                }
            }
        });
        this.m_scriptFeatureLicensed = CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.SCRIPTS);
        this.m_context = new ScriptViewContext(super.getContext());
    }

    public IViewId getViewId() {
        return ViewId.SCRIPT_VIEW;
    }

    public IContext getContext() {
        return this.m_context;
    }

    private void updateCompileAndExecuteButton() {
        if (this.m_groovyScript == null || !this.m_groovyScript.isExecutable()) {
            this.m_compileAndRunButton.setText(COMPILE);
            this.m_compileAndRunButton.setImage(UiResourceManager.getInstance().getImage("Compile"));
        } else {
            this.m_compileAndRunButton.setText(RUN);
            this.m_compileAndRunButton.setImage(UiResourceManager.getInstance().getImage("Run"));
        }
        this.m_compileAndRunButton.pack();
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        SashForm sashForm = new SashForm(viewContentArea, 512);
        SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
        boolean isReadOnly = !SonargraphCommand.isAvailable((ICommandId)CoreCommandId.MODIFY_GROOVY_SCRIPT_SOURCE, (SoftwareSystem)this.getSoftwareSystem());
        this.m_sourceViewWidget = new ScriptSourceViewWidget((Composite)sashForm, isReadOnly, this);
        if (!isReadOnly && LOGGER.isTraceEnabled()) {
            this.m_sourceViewWidget.getMainControl().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent event) {
                }

                public void keyPressed(KeyEvent event) {
                    if (!$assertionsDisabled && event == null) {
                        throw new AssertionError((Object)"Parameter 'event' of method 'keyPressed' must not be null");
                    }
                    if (event.keyCode == 32 && event.stateMask == 262144) {
                        ScriptView.this.autoCompletionRequested();
                    }
                }
            });
        }
        this.m_textSearchProvider = new SourceViewWidgetBasedTextSearchHandler(this.m_sourceViewWidget, !isReadOnly, this.getViewId().getPresentationName());
        this.m_controlAndResultComposite = new Composite((Composite)sashForm, 0);
        this.m_controlAndResultComposite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithoutMargin((int)3));
        this.m_runConfigurationCombo = new ComboWithImages(this.m_controlAndResultComposite, 200, "Select Run Configuration", new ComboWithImages.ILabelProvider(){

            public String getToolTipText(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof IRunConfiguration)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getToolTipText': " + String.valueOf(item)));
                }
                return ((IRunConfiguration)item).getParameterInfo();
            }

            public String getText(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof IRunConfiguration)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return ((IRunConfiguration)item).getRunConfigurationName();
            }

            public Image getImage(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof IRunConfiguration)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getImage': " + String.valueOf(item)));
                }
                return UiResourceManager.getInstance().getImage((Element)((IRunConfiguration)item).getNamedElement());
            }
        });
        this.m_runConfigurationCombo.setLayoutData((Object)new GridData(1, 2, false, false));
        this.m_compileAndRunButton = new Button(this.m_controlAndResultComposite, 0x1800008);
        this.m_compileAndRunButton.setLayoutData((Object)new GridData(1, 2, false, false));
        this.m_compileAndRunButton.setEnabled(false);
        this.m_compileAndRunButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!$assertionsDisabled && ScriptView.this.m_groovyScript.getStatus() == IGroovyScript.Status.EXECUTING) {
                    throw new AssertionError((Object)"Script must not be executing!");
                }
                if (!ScriptView.this.m_groovyScript.isExecutable()) {
                    ScriptView.this.compileScript();
                } else {
                    ScriptView.this.executeScript();
                }
            }
        });
        if (CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.SCRIPTS_AUTOMATED)) {
            this.m_updateButtonComposite = new Composite(this.m_controlAndResultComposite, 0);
            this.m_updateButtonComposite.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
            this.m_updateButtonComposite.setLayoutData((Object)new GridData(4, 2, true, false));
            this.m_updateButton = new Button(this.m_updateButtonComposite, 0x800008);
            this.m_updateButton.setLayoutData((Object)new GridData(3, 4, true, false));
            this.m_updateButton.setText(UPDATE_AUTOMATED_SCRIPT);
            this.m_updateButton.setImage(UiResourceManager.getInstance().getImage("UpdateConfiguration"));
            this.m_updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UpdateAutomatedScriptCommand update = new UpdateAutomatedScriptCommand(ScriptView.this.getSoftwareSystemProvider(), new UpdateAutomatedScriptCommand.IInteraction(){

                        public boolean collect(UpdateAutomatedScriptCommand.UpdateData data) {
                            data.setScript((this).ScriptView.this.m_groovyScript);
                            return true;
                        }
                    });
                    UserInterfaceAdapter.getInstance().run((Command)update, new CommandResultConsumer(){

                        public void consume(CommandException exception) {
                            super.consume(exception);
                            if (ScriptView.this.isActive()) {
                                ScriptView.this.updateUpdateButton();
                            }
                        }
                    });
                }
            });
            this.m_updateButtonComposite.setBackground(this.m_compileAndRunButton.getBackground());
        }
        this.updateCompileAndExecuteButton();
        this.m_controlAndResultComposite.setBackground(this.m_compileAndRunButton.getBackground());
        this.m_bottomTabFolder = SwtUtility.createTabFolder((Composite)this.m_controlAndResultComposite);
        this.m_bottomTabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.m_resultElementsTab = new CTabItem(this.m_bottomTabFolder, 0);
        this.m_resultElementsTab.setText(RESULT_VIEW_TITLE_ELEMENTS);
        this.m_resultElementsView = new PropertyTableViewer((Composite)this.m_bottomTabFolder, (BeanPropertyReader.BeanAdapter)new NamedElementBeanAdapter(), "name", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_resultElementsView.addColumn("Name", "name", null, "image", 1000, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultElementsTab.setControl(this.m_resultElementsView);
        this.m_resultElementsTab.setImage(UiResourceManager.getInstance().getImage("ElementsView"));
        this.m_resultAggregatedDependenciesTab = new CTabItem(this.m_bottomTabFolder, 0);
        this.m_resultAggregatedDependenciesTab.setText(RESULT_VIEW_TITLE_AGGREGATED_DEPENDENCIES);
        this.m_resultAggregatedDependenciesView = new PropertyTableViewer((Composite)this.m_bottomTabFolder, new AggregatedDependencyBeanAdapter(), "from", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_resultAggregatedDependenciesView.addColumn("From", "from", "from", "fromImage", 450, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultAggregatedDependenciesView.addColumn("Dependency", "dependencyInfo", "dependencyInfo", "dependencyImage", 250, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultAggregatedDependenciesView.addColumn("To", "to", "to", "toImage", 450, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultAggregatedDependenciesTab.setControl(this.m_resultAggregatedDependenciesView);
        this.m_resultAggregatedDependenciesTab.setImage(UiResourceManager.getInstance().getImage("DependenciesView"));
        this.m_resultParserDependenciesTab = new CTabItem(this.m_bottomTabFolder, 0);
        this.m_resultParserDependenciesTab.setText(RESULT_VIEW_TITLE_PARSER_DEPENDENCIES);
        this.m_resultParserDependenciesView = new PropertyTableViewer((Composite)this.m_bottomTabFolder, (BeanPropertyReader.BeanAdapter)new ParserDependencyBeanAdapter(), "from", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_resultParserDependenciesView.addColumn("From File", "file", "file", "fileImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultParserDependenciesView.addColumn("Line", "line", "line", null, 10, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultParserDependenciesView.addColumn("From", "from", "from", "fromImage", 30, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultParserDependenciesView.addColumn("Dependency", "dependencyInfo", "dependencyInfo", "dependencyImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultParserDependenciesView.addColumn("To", "to", "to", "toImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultParserDependenciesTab.setControl(this.m_resultParserDependenciesView);
        this.m_resultParserDependenciesTab.setImage(UiResourceManager.getInstance().getImage("DependenciesView"));
        this.m_resultTreeTab = new CTabItem(this.m_bottomTabFolder, 0);
        this.m_resultTreeTab.setText(RESULT_VIEW_TITLE_TREE);
        this.m_resultTreeView = new FilteredTreeViewer((Composite)this.m_bottomTabFolder, 66306, ScriptTreeNode.class, TreeNode::isLeaf, TreeNode::getChildren, 1);
        ScriptTreeNodeContentAndLabelProvider provider = new ScriptTreeNodeContentAndLabelProvider();
        this.m_resultTreeView.getTreeViewer().setContentProvider((IContentProvider)provider);
        this.m_resultTreeView.getTreeViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.m_resultTreeTab.setControl(this.m_resultTreeView);
        this.m_resultTreeTab.setImage(UiResourceManager.getInstance().getImage("ScriptResultTree"));
        this.m_resultIssuesTab = new CTabItem(this.m_bottomTabFolder, 0);
        this.m_resultIssuesTab.setText(RESULT_VIEW_TITLE_ISSUES);
        this.m_resultIssuesView = new PropertyTableViewer((Composite)this.m_bottomTabFolder, (BeanPropertyReader.BeanAdapter)new PreviewIssueBeanAdapter(), "severitySort", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_resultIssuesView.addColumn("Severity", "severity", "severitySort", "severityImage", 30, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultIssuesView.addColumn("Issue", "issue", "issue", "issueImage", 30, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultIssuesView.addColumn("Description", "description", "description", null, 60, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultIssuesView.addColumn("Element", "element", "element", "elementImage", 60, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultIssuesView.addColumn("Line", "line", null, null, 30, PropertyTableViewer.ColumnType.NUMBER);
        this.m_resultIssuesView.addColumn("To Element", "toElement", "toElement", "toElementImage", 60, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultIssuesTab.setControl(this.m_resultIssuesView);
        this.m_resultIssuesTab.setImage(UiResourceManager.getInstance().getImage("Issue"));
        this.m_resultMetricsTab = new CTabItem(this.m_bottomTabFolder, 0);
        this.m_resultMetricsTab.setText(RESULT_VIEW_TITLE_METRICS);
        this.m_resultMetricsView = new PropertyTableViewer((Composite)this.m_bottomTabFolder, (BeanPropertyReader.BeanAdapter)new PreviewMetricBeanAdapter(), "id", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_resultMetricsView.addColumn("Id", "id", "id", "metricImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultMetricsView.addColumn("Level", "level", "levelSort", null, 10, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultMetricsView.addColumn("Element", "element", "element", "elementImage", 60, PropertyTableViewer.ColumnType.TEXT);
        this.m_resultMetricsView.addColumn("Value", "value", "value", "valueImage", 10, PropertyTableViewer.ColumnType.NUMBER);
        this.m_resultMetricsTab.setControl(this.m_resultMetricsView);
        this.m_resultMetricsTab.setImage(UiResourceManager.getInstance().getImage("Metric"));
        this.m_bottomTabFolder.setSelection(this.m_resultElementsTab);
        this.m_bottomTabFolder.addSelectionListener((SelectionListener)this);
        sashForm.setWeights(new int[]{70, 30});
        this.m_resultElementsView.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_resultAggregatedDependenciesView.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_resultParserDependenciesView.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_resultTreeView.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_resultIssuesView.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_resultMetricsView.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_focusControl = this.m_sourceViewWidget;
    }

    protected void destroyViewContent() {
        if (this.m_sourceViewWidget != null) {
            this.m_sourceViewWidget.clear();
            this.m_sourceViewWidget.dispose();
            this.m_sourceViewWidget = null;
        }
        this.m_focusControl = null;
        EventManager.getInstance().detach(MultipleModifiableFileModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableFileCreatedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableFileDeletedEvent.class, (Object)this);
        EventManager.getInstance().detach(ScriptCompiledEvent.class, (Object)this);
        EventManager.getInstance().detach(ScriptExecutedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    @Override
    protected SourceViewWidget getSourceViewWidget() {
        return this.m_sourceViewWidget;
    }

    private void handleModifiableFileCreatedEvent(Collection<IModifiableFile> modifiableFiles) {
        assert (modifiableFiles != null) : "Parameter 'modifiableFiles' of method 'handleModifiableFileCreatedEvent' must not be null";
        boolean updateRunConfigurations = false;
        for (IModifiableFile nextModifiableFile : modifiableFiles) {
            if (!(nextModifiableFile instanceof FileBasedRunConfiguration) || !this.m_groovyScript.isRunConfiguration(nextModifiableFile)) continue;
            updateRunConfigurations = true;
            break;
        }
        if (updateRunConfigurations) {
            this.showRunConfigurations();
        }
    }

    private void handleModifiableFileDeletedEvent(Collection<IModifiableFile> modifiableFiles) {
        assert (modifiableFiles != null) : "Parameter 'modifiableFiles' of method 'handleSavedFileEvent' must not be null";
        if (modifiableFiles.contains(this.m_groovyScript)) {
            this.clearAndCloseView();
            return;
        }
        boolean updateUpdateButton = false;
        boolean updateRunConfigurations = false;
        for (IModifiableFile deleted : modifiableFiles) {
            if (deleted instanceof AnalyzerConfigurationFile && ((AnalyzerConfigurationFile)deleted).getAnalyzerId() == CoreAnalyzerId.SCRIPT_RUNNER) {
                updateUpdateButton = true;
                continue;
            }
            if (!(deleted instanceof FileBasedRunConfiguration)) continue;
            updateRunConfigurations = true;
        }
        if (updateUpdateButton) {
            this.updateUpdateButton();
        }
        if (updateRunConfigurations) {
            this.showRunConfigurations();
        }
    }

    public IModifiableFile getModifiableFile() {
        return this.m_groovyScript;
    }

    private void handleModifiableFileModifiedEvent(IModifiableFile modifiableFile, IOriginator modificationTrigger, EnumSet<MultipleModifiableFileModifiedEvent.Aspect> aspects) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'handleModifiableFileModifiedEvent' must not be null";
        assert (aspects != null) : "Parameter 'aspects' of method 'handleModifiableFileModifiedEvent' must not be null";
        if (this.m_groovyScript == null) {
            return;
        }
        if (this.m_groovyScript == modifiableFile) {
            if (modificationTrigger != this) {
                String content = this.m_groovyScript.getScriptContent().getSource();
                this.m_sourceViewWidget.showSource((FilePath)this.m_groovyScript, -1, false, true, content);
                this.m_sourceViewWidget.clearUndoRedo();
                this.evaluateScript(modificationTrigger == null);
                this.showRunConfigurations();
                WorkbenchRegistry.getInstance().updatePartNameForModifiableFileState(this.getPart(), this.m_groovyScript.getShortName());
            }
        } else if (modifiableFile == ((IGroovyProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IGroovyProvider.class)).getScriptRunnerConfigurationFile()) {
            this.updateUpdateButton();
        } else if (this.m_groovyScript.isRunConfiguration(modifiableFile)) {
            this.updateUpdateButton();
            this.showRunConfigurations();
        }
    }

    private void refreshPreviews() {
        this.m_resultElementsView.refresh();
        this.m_resultAggregatedDependenciesView.refresh();
        this.m_resultParserDependenciesView.refresh();
        this.m_resultTreeView.getTreeViewer().refresh();
        this.m_resultIssuesView.refresh();
        this.m_resultMetricsView.refresh();
    }

    private void clearPreviews() {
        this.m_resultElementsTab.setText(RESULT_VIEW_TITLE_ELEMENTS);
        this.m_resultAggregatedDependenciesTab.setText(RESULT_VIEW_TITLE_AGGREGATED_DEPENDENCIES);
        this.m_resultParserDependenciesTab.setText(RESULT_VIEW_TITLE_PARSER_DEPENDENCIES);
        this.m_resultTreeTab.setText(RESULT_VIEW_TITLE_TREE);
        this.m_resultIssuesTab.setText(RESULT_VIEW_TITLE_ISSUES);
        this.m_resultMetricsTab.setText(RESULT_VIEW_TITLE_METRICS);
        this.m_resultElementsView.showData(null);
        this.m_resultAggregatedDependenciesView.showData(null);
        this.m_resultParserDependenciesView.showData(null);
        this.m_resultTreeView.getTreeViewer().getControl().setRedraw(false);
        this.m_resultTreeView.showData(null);
        this.m_resultTreeView.getTreeViewer().getControl().setRedraw(true);
        this.m_resultIssuesView.showData(null);
        this.m_resultMetricsView.showData(null);
    }

    private void updatePreviews() {
        ScriptResultSet resultSet = this.m_groovyScript.getResultSet();
        if (resultSet == null) {
            this.clearPreviews();
            return;
        }
        this.m_resultElementsTab.setText((resultSet.hasNamedElements() ? "(!) " : "") + RESULT_VIEW_TITLE_ELEMENTS);
        this.m_resultAggregatedDependenciesTab.setText((resultSet.hasAggregatedDependencies() ? "(!) " : "") + RESULT_VIEW_TITLE_AGGREGATED_DEPENDENCIES);
        this.m_resultParserDependenciesTab.setText((resultSet.hasParserDependencies() ? "(!) " : "") + RESULT_VIEW_TITLE_PARSER_DEPENDENCIES);
        this.m_resultTreeTab.setText((resultSet.hasTreeNodes() ? "(!) " : "") + RESULT_VIEW_TITLE_TREE);
        this.m_resultIssuesTab.setText((resultSet.hasIssueNodes() ? "(!) " : "") + RESULT_VIEW_TITLE_ISSUES);
        this.m_resultMetricsTab.setText((resultSet.hasMetricNodes() ? "(!) " : "") + RESULT_VIEW_TITLE_METRICS);
        this.m_resultElementsView.showData((Collection)(resultSet.hasNamedElements() ? resultSet.getNamedElements() : null));
        this.m_resultAggregatedDependenciesView.showData((Collection)(resultSet.hasAggregatedDependencies() ? resultSet.getAggregatedDependencies() : null));
        this.m_resultParserDependenciesView.showData((Collection)(resultSet.hasParserDependencies() ? resultSet.getParserDependencies() : null));
        this.m_resultTreeView.getTreeViewer().getControl().setRedraw(false);
        if (resultSet.hasTreeNodes()) {
            this.m_resultTreeView.showData((Object)resultSet.getTreeRootNode());
        } else {
            this.m_resultTreeView.showData(null);
        }
        this.m_resultTreeView.getTreeViewer().getControl().setRedraw(true);
        if (resultSet.hasIssueNodes()) {
            this.m_resultIssuesView.showData(PreviewIssueRecord.convertToList(resultSet.getIssueRootNode()));
        } else {
            this.m_resultIssuesView.showData(null);
        }
        if (resultSet.hasMetricNodes()) {
            this.m_resultMetricsView.showData(PreviewMetricRecord.convertToList(resultSet.getMetricRootNode()));
        } else {
            this.m_resultMetricsView.showData(null);
        }
    }

    private void updateUpdateButton() {
        assert (this.m_groovyScript != null) : "'m_groovyScript' of method 'updateUpdateButton' must not be null";
        if (this.m_updateButtonComposite != null) {
            assert (this.m_updateButton != null) : "'m_updateButton' of method 'updateUpdateButton' must not be null";
            Result result = ((IGroovyProvider)this.getSoftwareSystem().getExtension(IGroovyProvider.class)).canContentBeTransferedToAutomatedScript(this.m_groovyScript);
            if (result.isSuccess()) {
                this.m_updateButtonComposite.setToolTipText(null);
                this.m_updateButton.setEnabled(this.m_scriptFeatureLicensed);
                this.m_updateButton.setToolTipText("Update the automated script with the new content");
            } else {
                this.m_updateButton.setToolTipText(null);
                this.m_updateButton.setEnabled(false);
                this.m_updateButtonComposite.setToolTipText(result.getErrorMessage());
            }
        }
    }

    private void handleScriptCompiledEvent(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'handleScriptCompiledEvent' must not be null";
        if (this.m_groovyScript == modifiableFile) {
            this.evaluateScript(false);
        }
    }

    private void handleScriptExecutedEvent(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'handleScriptExecutedEvent' must not be null";
        if (this.m_groovyScript == modifiableFile) {
            this.evaluateScript(true);
        }
    }

    public void showInView(IContext context, List<Element> elements, List<IStandardEnumeration> options, boolean secondaryIdReused) {
        assert (elements != null && elements.size() == 1) : "Excaclty 1 element expected for parameter 'elements' in method 'showInVie'";
        Element element = elements.get(0);
        assert (element != null && element instanceof GroovyScript) : "Unexpected class in method 'showInView': " + String.valueOf(element);
        this.m_groovyScript = (GroovyScript)element;
        assert (this.m_groovyScript != null) : "Parameter 'm_groovyScript' of method 'updateViewContent' must not be null";
        this.showRunConfigurations();
        this.updateUpdateButton();
        WorkbenchRegistry.getInstance().updatePartNameForModifiableFileState(this.getPart(), this.m_groovyScript.getShortName());
        if (!this.m_groovyScript.isExecutable()) {
            this.compileScript();
        }
        this.m_sourceViewWidget.setRedraw(false);
        this.m_sourceViewWidget.showSource((FilePath)this.m_groovyScript, this.m_groovyScript.getLineNumber(), true, false, this.m_groovyScript.getScriptContent().getSource());
        this.evaluateScript(true);
        this.m_sourceViewWidget.setRedraw(true);
        this.getSelectionProviderAdapter().handleSelectionChanged((Element)this.m_groovyScript);
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null) : "Parameter 'elements' of method 'finishShowInView' must not be null";
        WorkbenchRegistry.getInstance().selectView((IWorkbenchView)this);
    }

    private void showRunConfigurations() {
        assert (this.m_groovyScript != null) : "'m_groovyScript' of method 'showRunConfigurations' must not be null";
        List runConfigurations = this.m_groovyScript.getRunConfigurations();
        assert (!runConfigurations.isEmpty()) : "No run configurations";
        ArrayList<NamedElement> runConfigurationsAsNamedElements = new ArrayList<NamedElement>(runConfigurations.size());
        for (IRunConfiguration nextRunConfiguration : runConfigurations) {
            runConfigurationsAsNamedElements.add(nextRunConfiguration.getNamedElement());
        }
        Collections.sort(runConfigurationsAsNamedElements, new NamedElementViewComparator());
        Object runConfiguration = this.m_runConfigurationCombo.getSelectedItem();
        String fqNameOfCurrentlySelectedRunConfiguration = null;
        if (runConfiguration instanceof NamedElement) {
            fqNameOfCurrentlySelectedRunConfiguration = ((NamedElement)runConfiguration).getFullyQualifiedName();
        }
        NamedElement selectRunConfiguration = null;
        if (fqNameOfCurrentlySelectedRunConfiguration != null) {
            for (NamedElement nextRunConfiguration : runConfigurationsAsNamedElements) {
                if (!fqNameOfCurrentlySelectedRunConfiguration.equals(nextRunConfiguration.getFullyQualifiedName())) continue;
                selectRunConfiguration = nextRunConfiguration;
                break;
            }
        }
        if (selectRunConfiguration == null) {
            selectRunConfiguration = runConfigurations.size() == 1 ? (NamedElement)runConfigurationsAsNamedElements.get(0) : (NamedElement)runConfigurationsAsNamedElements.get(1);
        }
        this.m_runConfigurationCombo.setItems(runConfigurationsAsNamedElements, selectRunConfiguration);
    }

    public List<Control> getControlsForInteraction() {
        return new ArrayList<Control>(Arrays.asList(this.m_sourceViewWidget.getMainControl(), this.m_resultAggregatedDependenciesView.getTable(), this.m_resultParserDependenciesView.getTable(), this.m_resultElementsView.getTable(), this.m_resultTreeView.getTreeViewer().getTree(), this.m_resultIssuesView.getTable(), this.m_resultMetricsView.getTable()));
    }

    protected EnumSet<Gesture> getDisabledGestures() {
        return EnumSet.of(Gesture.DOUBLE_CLICK);
    }

    public void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        if (control != this.m_sourceViewWidget.getMainControl()) {
            if (control == this.m_resultElementsView || control == this.m_resultElementsView.getTable()) {
                this.m_resultElementsView.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            } else if (control == this.m_resultAggregatedDependenciesView || control == this.m_resultAggregatedDependenciesView.getTable()) {
                this.m_resultAggregatedDependenciesView.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            } else if (control == this.m_resultParserDependenciesView || control == this.m_resultParserDependenciesView.getTable()) {
                this.m_resultParserDependenciesView.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            } else if (control == this.m_resultTreeView.getTreeViewer().getTree()) {
                this.m_resultTreeView.getTreeViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            } else if (control == this.m_resultIssuesView || control == this.m_resultIssuesView.getTable()) {
                this.m_resultIssuesView.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            } else if (control == this.m_resultMetricsView || control == this.m_resultMetricsView.getTable()) {
                this.m_resultMetricsView.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            } else assert (false) : "Unhandled control: " + String.valueOf(control);
        }
    }

    public List<Control> getViewComponents() {
        return new ArrayList<Control>(Arrays.asList(this.m_sourceViewWidget.getMainControl(), this.m_resultElementsView, this.m_resultElementsView.getTable(), this.m_resultAggregatedDependenciesView, this.m_resultAggregatedDependenciesView.getTable(), this.m_resultParserDependenciesView, this.m_resultParserDependenciesView.getTable(), this.m_resultTreeView.getTreeViewer().getTree(), this.m_resultIssuesView.getTable(), this.m_resultMetricsView.getTable()));
    }

    public Control getSelectedViewComponent() {
        if (this.m_focusControl == this.m_sourceViewWidget) {
            return this.m_sourceViewWidget.getMainControl();
        }
        if (this.m_focusControl == this.m_resultElementsView) {
            return this.m_resultElementsView.getTable();
        }
        if (this.m_focusControl == this.m_resultAggregatedDependenciesView) {
            return this.m_resultAggregatedDependenciesView.getTable();
        }
        if (this.m_focusControl == this.m_resultParserDependenciesView) {
            return this.m_resultParserDependenciesView.getTable();
        }
        if (this.m_focusControl == this.m_resultTreeView.getTreeViewer().getTree()) {
            return this.m_resultTreeView.getTreeViewer().getTree();
        }
        if (this.m_focusControl == this.m_resultIssuesView) {
            return this.m_resultIssuesView.getTable();
        }
        if (this.m_focusControl == this.m_resultMetricsView) {
            return this.m_resultMetricsView.getTable();
        }
        assert (false) : "No selected view component";
        return null;
    }

    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'componentSelected' must not be null";
        if (component == this.m_sourceViewWidget.getMainControl()) {
            this.m_focusControl = this.m_sourceViewWidget;
        } else if (component == this.m_resultElementsView || component == this.m_resultElementsView.getTable()) {
            this.m_focusControl = this.m_resultElementsView;
        } else if (component == this.m_resultAggregatedDependenciesView || component == this.m_resultAggregatedDependenciesView.getTable()) {
            this.m_focusControl = this.m_resultAggregatedDependenciesView;
        } else if (component == this.m_resultParserDependenciesView || component == this.m_resultParserDependenciesView.getTable()) {
            this.m_focusControl = this.m_resultParserDependenciesView;
        } else if (component == this.m_resultTreeView.getTreeViewer().getTree()) {
            this.m_focusControl = this.m_resultTreeView.getTreeViewer().getTree();
        } else if (component == this.m_resultIssuesView || component == this.m_resultIssuesView.getTable()) {
            this.m_focusControl = this.m_resultIssuesView;
        } else if (component == this.m_resultMetricsView || component == this.m_resultMetricsView.getTable()) {
            this.m_focusControl = this.m_resultMetricsView;
        } else assert (false) : "Unhandled component: " + String.valueOf(component);
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        boolean scriptIsInvalid;
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        boolean bl = scriptIsInvalid = this.m_groovyScript == null || !this.m_groovyScript.isValid();
        if (scriptIsInvalid || modification.contains(Modification.WORKSPACE_CLEARED) || modification.contains(Modification.WORKSPACE_MODIFIED)) {
            this.clearPreviews();
        } else if (modification.contains(Modification.VIRTUAL_MODEL_CHANGED) || modification.contains(Modification.VIRTUAL_MODEL_MODIFIED) || modification.contains(Modification.REFACTORINGS_MODIFIED)) {
            this.refreshPreviews();
        }
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (this.m_groovyScript != null && this.m_groovyScript.isValid() && modification.contains(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED)) {
            this.refreshPreviews();
        }
        super.analyzerModification(modification, analyzerId);
    }

    private void clearAndCloseView() {
        this.m_runConfigurationCombo.removeItems();
        this.m_groovyScript = null;
        this.m_sourceViewWidget.clear();
        this.getSelectionProviderAdapter().handleSelectionChanged();
        this.resetPartName();
        this.hideView();
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.clearAndCloseView();
    }

    @Override
    public boolean isAutoCompletionPossible() {
        SoftwareSystem system = this.getSoftwareSystem();
        return system != null && SonargraphCommand.isAvailable((ICommandId)CoreCommandId.CREATE_GROOVY_SCRIPT, (SoftwareSystem)system);
    }

    @Override
    public void autoCompletionRequested() {
        AutoCompletionProposal proposal;
        Display display;
        assert (this.m_groovyScript != null) : "'m_groovyScript' of method 'autoCompletionRequested' must not be null";
        IGroovyProvider provider = (IGroovyProvider)this.getSoftwareSystem().getExtension(IGroovyProvider.class);
        StyledText sourceWidget = this.m_sourceViewWidget.getSourceWidget();
        int caretOffset = sourceWidget.getCaretOffset();
        int line = sourceWidget.getLineAtOffset(caretOffset);
        String text = sourceWidget.getText();
        List proposals = provider.getAutoCompletionProposals(this.m_groovyScript, text, caretOffset, line + 1);
        if (!proposals.isEmpty() && (display = WorkbenchRegistry.getInstance().getDisplay()) != null && !display.isDisposed() && (proposal = AutoCompletionProposalViewer.getProposal(this.getShell(), display.map((Control)sourceWidget, null, sourceWidget.getLocationAtOffset(caretOffset)), proposals)) != null) {
            sourceWidget.replaceTextRange(proposal.getReplacementOffset(), proposal.getReplacementLength(), proposal.getProposal());
            sourceWidget.setCaretOffset(proposal.getReplacementOffset() + proposal.getProposal().length() + proposal.getOffsetIncrement());
        }
    }

    public List<Element> getSelectedElements() {
        assert (this.m_resultElementsView != null) : "Parameter 'm_scriptResultElementView' of method 'getSelected' must not be null";
        assert (this.m_resultAggregatedDependenciesView != null) : "Parameter 'm_scriptResultDependencyView' of method 'getSelected' must not be null";
        assert (this.m_resultTreeView != null) : "Parameter 'm_resultTreeView' of method 'getSelected' must not be null";
        IStructuredSelection selection = null;
        if (this.m_focusControl == this.m_sourceViewWidget) {
            if (this.m_groovyScript != null) {
                return Collections.singletonList(this.m_groovyScript);
            }
            return Collections.emptyList();
        }
        if (this.m_focusControl == this.m_resultElementsView) {
            selection = this.m_resultElementsView.getSelection();
        } else if (this.m_focusControl == this.m_resultAggregatedDependenciesView) {
            selection = this.m_resultAggregatedDependenciesView.getSelection();
        } else if (this.m_focusControl == this.m_resultParserDependenciesView) {
            selection = this.m_resultParserDependenciesView.getSelection();
        } else if (this.m_focusControl == this.m_resultTreeView.getTreeViewer().getTree()) {
            selection = (IStructuredSelection)this.m_resultTreeView.getTreeViewer().getSelection();
        } else if (this.m_focusControl == this.m_resultIssuesView) {
            selection = this.m_resultIssuesView.getSelection();
        } else if (this.m_focusControl == this.m_resultMetricsView) {
            selection = this.m_resultMetricsView.getSelection();
        } else assert (false) : "No focus control";
        if (selection == null || selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> selected = new ArrayList<Element>(selection.size());
        for (Object next : selection.toList()) {
            Element nextElement;
            if (next instanceof Element) {
                selected.add((Element)next);
                continue;
            }
            if (next instanceof ScriptTreeNode) {
                nextElement = ((ScriptTreeNode)next).getElement();
                if (nextElement == null) continue;
                selected.add(nextElement);
                continue;
            }
            if (next instanceof PreviewIssueRecord) {
                nextElement = ((PreviewIssueRecord)next).getAffectedElement().getElement();
                if (nextElement == null) continue;
                selected.add(nextElement);
                continue;
            }
            if (next instanceof PreviewMetricRecord) {
                nextElement = ((PreviewMetricRecord)next).getElement();
                if (nextElement == null) continue;
                selected.add(nextElement);
                continue;
            }
            assert (false) : "Unhandled selected element: " + String.valueOf(next);
        }
        return selected;
    }

    public boolean supportsPaste() {
        return !this.m_sourceViewWidget.isReadOnly() && this.m_focusControl == this.m_sourceViewWidget;
    }

    public void paste() {
        this.m_sourceViewWidget.setInPasteOperation(true);
        this.m_sourceViewWidget.getSourceWidget().paste();
        this.m_sourceViewWidget.setInPasteOperation(false);
    }

    public boolean supportsCut() {
        return !this.m_sourceViewWidget.getSelectedTextInfo().isEmpty() && !this.m_sourceViewWidget.isReadOnly() && this.m_focusControl == this.m_sourceViewWidget;
    }

    public void cut() {
        this.m_sourceViewWidget.getSourceWidget().cut();
    }

    public boolean supportsCopy() {
        if (this.m_focusControl == this.m_sourceViewWidget) {
            String selection = this.m_sourceViewWidget.getSelectedTextInfo().getSelectedText();
            return selection != null && selection.length() > 0;
        }
        return false;
    }

    public String copy() {
        if (this.m_focusControl == this.m_sourceViewWidget) {
            String selection = this.m_sourceViewWidget.getSelectedTextInfo().getSelectedText();
            assert (selection != null && selection.length() > 0) : "'selection' of method 'getCopyToClipBoardData' must not be empty";
            return selection;
        }
        return "";
    }

    public String getPresentationName() {
        return super.getPresentationName() + (String)(this.m_groovyScript != null ? " [" + this.m_groovyScript.getIdentifyingPath() + "]" : "");
    }

    public Search supportsSearch() {
        if (this.m_sourceViewWidget.isReadOnly()) {
            return Search.FIND_TEXT;
        }
        return Search.FIND_REPLACE_TEXT;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchProvider;
    }

    @Override
    public void handleOperation(EditableSourceViewWidget.Operation blockOperation) {
        assert (blockOperation != null) : "Parameter 'blockOperation' of method 'handleBlockOperation' must not be null";
        this.m_sourceViewWidget.handleOperation(blockOperation);
    }

    @Override
    public boolean canExecuteOperation() {
        return !this.m_sourceViewWidget.isReadOnly() && this.m_focusControl == this.m_sourceViewWidget;
    }

    private void evaluateScript(boolean updatePreviews) {
        assert (this.m_groovyScript != null) : "'m_groovyScript' of method 'evaluateScript' must not be null";
        this.processIssues((NamedElement)this.m_groovyScript);
        this.m_compileAndRunButton.setEnabled(this.m_scriptFeatureLicensed);
        this.updateCompileAndExecuteButton();
        this.updateUpdateButton();
        if (updatePreviews) {
            this.updatePreviews();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        if (event.getSource() == this.m_sourceViewWidget.getMainControl()) {
            this.m_focusControl = this.m_sourceViewWidget;
        }
        if (event.getSource() == this.m_resultElementsView.getTableViewer()) {
            this.m_focusControl = this.m_resultElementsView;
        } else if (event.getSource() == this.m_resultAggregatedDependenciesView.getTableViewer()) {
            this.m_focusControl = this.m_resultAggregatedDependenciesView;
        } else if (event.getSource() == this.m_resultParserDependenciesView.getTableViewer()) {
            this.m_focusControl = this.m_resultParserDependenciesView;
        } else if (event.getSource() == this.m_resultTreeView.getTreeViewer()) {
            this.m_focusControl = this.m_resultTreeView.getTreeViewer().getControl();
        } else if (event.getSource() == this.m_resultIssuesView.getTableViewer()) {
            this.m_focusControl = this.m_resultIssuesView;
        } else if (event.getSource() == this.m_resultMetricsView.getTableViewer()) {
            this.m_focusControl = this.m_resultMetricsView;
        } else assert (false) : "Unhandled: " + String.valueOf(event.getSource());
        this.getSelectionProviderAdapter().handleSelectionChanged(this.getSelectedElements());
    }

    public void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'performRestoreNavigationState' must not be null";
        this.m_sourceViewWidget.getSourceWidget().forceFocus();
    }

    public void performViewSelectionChanged(IWorkbenchView view, List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'selectionChanged' must not be null";
        if (view != null && view instanceof WorkbenchAuxiliaryView && !elements.isEmpty() && view.getViewId() == ViewId.MARKERS_VIEW && ((WorkbenchAuxiliaryView)view).getConnectedView() == this) {
            assert (this.m_sourceViewWidget != null) : "'m_sourceViewWidget' of method 'selectionChanged' must not be null";
            Element first = elements.get(0);
            int lineNumber = first.getLineNumber();
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            this.m_sourceViewWidget.gotoLine(lineNumber, true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        TableViewer source;
        if (e.item == this.m_resultElementsTab) {
            source = this.m_resultElementsView.getTableViewer();
        } else if (e.item == this.m_resultAggregatedDependenciesTab) {
            source = this.m_resultAggregatedDependenciesView.getTableViewer();
        } else if (e.item == this.m_resultParserDependenciesTab) {
            source = this.m_resultParserDependenciesView.getTableViewer();
        } else if (e.item == this.m_resultTreeTab) {
            source = this.m_resultTreeView.getTreeViewer();
        } else if (e.item == this.m_resultIssuesTab) {
            source = this.m_resultIssuesView.getTableViewer();
        } else if (e.item == this.m_resultMetricsTab) {
            source = this.m_resultMetricsView.getTableViewer();
        } else {
            assert (false) : "Unexpected Tab selected";
            return;
        }
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)source, source.getSelection()));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void enableUserInteraction() {
        this.m_sourceViewWidget.setEnabled(true);
        this.m_compileAndRunButton.setEnabled(this.m_scriptFeatureLicensed);
        if (this.m_updateButton != null && this.m_groovyScript != null) {
            this.m_updateButton.setEnabled(this.m_scriptFeatureLicensed && ((IGroovyProvider)this.getSoftwareSystem().getExtension(IGroovyProvider.class)).canContentBeTransferedToAutomatedScript(this.m_groovyScript).isSuccess());
        }
        this.getElementInteractor().enable();
    }

    private void disableUserInteraction() {
        this.getElementInteractor().disable();
        this.m_sourceViewWidget.setEnabled(false);
        this.m_compileAndRunButton.setEnabled(false);
        if (this.m_updateButton != null) {
            this.m_updateButton.setEnabled(false);
        }
    }

    private void compileScript() {
        this.disableUserInteraction();
        CompileGroovyScriptCommand compile = new CompileGroovyScriptCommand(this.getSoftwareSystemProvider(), new CompileGroovyScriptCommand.ICompileGroovyScriptInteraction(){

            public boolean collect(GroovyScriptData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setScript(ScriptView.this.m_groovyScript);
                return true;
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)compile, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                super.consume(exception);
                if (ScriptView.this.isActive()) {
                    ScriptView.this.updateCompileAndExecuteButton();
                    ScriptView.this.enableUserInteraction();
                }
            }
        });
    }

    private void executeScript() {
        this.disableUserInteraction();
        if (!CommandHandler.performCheck((CommandHandler.Check)CommandHandler.Check.PARSER_MODEL_AND_LEVEL, (boolean)true)) {
            this.enableUserInteraction();
            return;
        }
        final IRunConfiguration runConfiguration = (IRunConfiguration)this.m_runConfigurationCombo.getSelectedItem();
        assert (this.m_groovyScript.isExecutable()) : "Script '" + this.m_groovyScript.getIdentifyingPath() + "' must be executable";
        assert (((NamedElement)runConfiguration).isValid()) : "RunConfiguration must be a valid element";
        RunGroovyScriptCommand runScript = new RunGroovyScriptCommand(this.getSoftwareSystemProvider(), new RunGroovyScriptCommand.IRunGroovyScriptInteraction(){

            public boolean collect(RunGroovyScriptCommand.RunGroovyScriptData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setRunConfiguration(runConfiguration);
                data.setScript(ScriptView.this.m_groovyScript);
                return true;
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)runScript, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                super.consume(exception);
                if (ScriptView.this.isActive()) {
                    ScriptView.this.updateCompileAndExecuteButton();
                    ScriptView.this.enableUserInteraction();
                }
            }
        });
    }

    public void zoomIn(Point location) {
        this.m_sourceViewWidget.zoomIn();
    }

    public void zoomOut(Point location) {
        this.m_sourceViewWidget.zoomOut();
    }

    @Override
    public IUndoRedoEntry isUndoPossible() {
        if (this.m_sourceViewWidget != null && !this.m_sourceViewWidget.isDisposed()) {
            return this.m_sourceViewWidget.isUndoPossible();
        }
        return null;
    }

    @Override
    public IUndoRedoEntry isRedoPossible() {
        if (this.m_sourceViewWidget != null && !this.m_sourceViewWidget.isDisposed()) {
            return this.m_sourceViewWidget.isRedoPossible();
        }
        return null;
    }

    @Override
    public void undo() {
        if (this.m_sourceViewWidget != null && !this.m_sourceViewWidget.isDisposed()) {
            this.m_sourceViewWidget.undo();
        }
    }

    @Override
    public void redo() {
        if (this.m_sourceViewWidget != null && !this.m_sourceViewWidget.isDisposed()) {
            this.m_sourceViewWidget.redo();
        }
    }
}

