/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IGroovyProvider;
import com.hello2morrow.sonargraph.core.model.script.IParameterDefinitionProvider;
import com.hello2morrow.sonargraph.core.model.script.IntegerParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ParameterType;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationParameters;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

final class RunConfigurationWizardPage
extends StandardWizardPage {
    private static final String VALUE_TABLE_EDITOR = "ValueTableEditor";
    private static final String FROM_DEFAULTS_TABLE_EDITOR = "FromDefaultsTableEditor";
    private static final String PARAMETER_NOT_FROM_DEFAULTS = "No - Restore?";
    private static final String PARAMETER_FROM_DEFAULTS = "Yes";
    private final IGroovyProvider m_groovyProvider;
    private final IParameterDefinitionProvider m_parameterDefinitionProvider;
    private final ITextValidator m_nameValidator;
    private final String m_initialName;
    private final String m_initialDescription;
    private final RunConfigurationParameters m_initialRunConfigurationParameters;
    private final RunConfigurationParameters m_currentRunConfigurationParameters;
    private final Map<String, ValidationResult> m_valueValidationResults = new LinkedHashMap<String, ValidationResult>();
    private ValidatingTextWidget m_widgetName;
    private Text m_widgetDescription;
    private Table m_widgetParameters;
    private String m_currentName;
    private String m_currentDescription;
    private boolean m_isModified;
    private boolean m_hasValidParameterName;
    private boolean m_inDefaultValueRestore;

    RunConfigurationWizardPage(GroovyScript script, FileBasedRunConfiguration toBeEdited, IGroovyProvider groovyProvider) {
        super("Run Configuration Page", "Specify name, description and values for the defined parameters.");
        assert (script != null) : "Parameter 'script' of method 'RunConfigurationEditControl' must not be null";
        assert (groovyProvider != null) : "Parameter 'groovyProvider' of method 'RunConfigurationEditControl' must not be null";
        this.m_groovyProvider = groovyProvider;
        this.m_parameterDefinitionProvider = script.getScriptContent();
        if (toBeEdited == null) {
            this.m_initialName = "";
            this.m_initialDescription = "";
            this.m_initialRunConfigurationParameters = new RunConfigurationParameters();
        } else {
            this.m_initialName = toBeEdited.getRunConfigurationName();
            this.m_initialDescription = toBeEdited.getDescription();
            this.m_initialRunConfigurationParameters = toBeEdited.getRunConfigurationParameters();
        }
        this.m_currentName = this.m_initialName;
        this.m_currentDescription = this.m_initialDescription;
        this.m_currentRunConfigurationParameters = new RunConfigurationParameters(this.m_initialRunConfigurationParameters);
        this.m_nameValidator = groovyProvider.getRunConfigurationNameValidator(script, toBeEdited);
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.CREATE_EDIT_RUN_CONFIGURATION_DIALOG;
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected void createContent(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createContent' must not be null";
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name:");
        nameLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.m_widgetName = new ValidatingTextWidget(composite, this.m_nameValidator, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                RunConfigurationWizardPage.this.m_currentName = input == null ? "" : input;
                RunConfigurationWizardPage.this.m_hasValidParameterName = input != null;
                RunConfigurationWizardPage.this.checkModification(false);
            }
        }, this.m_initialName, true, false, 0);
        this.m_widgetName.setEditable(true);
        this.m_widgetName.setLayoutData((Object)new GridData(4, 4, true, false));
        Label desriptionLabel = new Label(composite, 0);
        desriptionLabel.setText("Description:");
        desriptionLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.m_widgetDescription = new Text(composite, 2048);
        this.m_widgetDescription.setLayoutData((Object)new GridData(4, 2, true, false));
        this.m_widgetDescription.setText(this.m_initialDescription);
        this.m_widgetDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'modifyText' must not be null");
                }
                RunConfigurationWizardPage.this.m_currentDescription = RunConfigurationWizardPage.this.m_widgetDescription.getText();
                RunConfigurationWizardPage.this.checkModification(false);
            }
        });
        this.m_widgetParameters = new Table(composite, 65540);
        this.m_widgetParameters.setHeaderVisible(true);
        this.m_widgetParameters.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        String[] titles = new String[]{"Parameter", "Type", "Value", "From [Default]"};
        int[] widths = new int[]{100, 100, 150, 100};
        int index = 0;
        String[] stringArray = titles;
        int n = titles.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            TableColumn column = new TableColumn(this.m_widgetParameters, 0);
            column.setText(title);
            column.setWidth(widths[index++]);
            ++n2;
        }
        for (ParameterDefinition next : this.m_parameterDefinitionProvider.getParameterDefinitions()) {
            String nextParameterName = next.getName();
            TableItem nextTableItem = new TableItem(this.m_widgetParameters, 0);
            Object nextParameterValue = this.m_initialRunConfigurationParameters.getParameterValue(nextParameterName);
            this.fillTableItem(nextTableItem, next, nextParameterValue != null ? nextParameterValue : next.getDefaultValue(), nextParameterValue == null);
        }
        this.m_hasValidParameterName = this.m_nameValidator.isValid(null, this.m_currentName).isSuccess();
    }

    private void updateFromDefaultsInfo() {
        TableItem[] tableItemArray = this.m_widgetParameters.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem next = tableItemArray[n2];
            String nextParameterName = next.getText(0);
            boolean nextFromDefaults = this.m_currentRunConfigurationParameters.getParameterValue(nextParameterName) == null;
            TableEditor nextFromDefaultsTableEditor = (TableEditor)next.getData(FROM_DEFAULTS_TABLE_EDITOR);
            assert (nextFromDefaultsTableEditor != null) : "Parameter 'nextFromDefaultsTableEditor' of method 'updateFromDefaultsInfo' must not be null";
            Control nextControl = nextFromDefaultsTableEditor.getEditor();
            assert (nextControl != null && nextControl instanceof Button) : "Unexpected class in method 'updateFromDefaultsInfo': " + String.valueOf(nextControl);
            Button nextButton = (Button)nextControl;
            nextButton.setText(nextFromDefaults ? PARAMETER_FROM_DEFAULTS : PARAMETER_NOT_FROM_DEFAULTS);
            nextButton.setEnabled(!nextFromDefaults);
            ++n2;
        }
    }

    private void setBooleanValue(Control control, Object value) {
        assert (control != null && control instanceof Combo) : "Unexpected class in method 'setBooleanValue': " + String.valueOf(control);
        assert (value != null && value instanceof Boolean) : "Unexpected class in method 'setBooleanValue': " + String.valueOf(value);
        this.m_inDefaultValueRestore = true;
        Combo combo = (Combo)control;
        int index = combo.indexOf(value.toString());
        assert (index != -1) : "Item not found: " + String.valueOf(value);
        combo.select(index);
        this.m_inDefaultValueRestore = false;
    }

    private void setIntegerOrStringValue(Control control, Object value) {
        assert (control != null) : "Parameter 'control' of method 'setIntegerValue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'setIntegerValue' must not be null";
        assert (value instanceof Integer || value instanceof String) : "Not an integer or string: " + String.valueOf(value);
        this.m_inDefaultValueRestore = true;
        if (control instanceof Combo) {
            Combo combo = (Combo)control;
            int index = combo.indexOf(value.toString());
            assert (index != -1) : "Item not found: " + String.valueOf(value);
            combo.select(index);
        } else {
            assert (control instanceof Text) : "Unexpected class in method 'setStringValue': " + String.valueOf(control);
            Text text = (Text)control;
            text.setText(value.toString());
        }
        this.m_inDefaultValueRestore = false;
    }

    private ITextValidator getParameterValueValidator(final ParameterDefinition<?> definition) {
        assert (definition != null) : "Parameter 'definition' of method 'getParameterValueValidator' must not be null";
        return this.m_groovyProvider.getParameterValueValidator(new IGroovyProvider.IParameterDefinitionInfoProvider(){

            public String getCurrentPossibleValuesAsString() {
                return definition.getPossibleValuesAsString();
            }

            public ParameterType getCurrentParameterType() {
                return definition.getType();
            }

            public String getCurrentParameterName() {
                return definition.getName();
            }
        });
    }

    private boolean processParameterValue(ITextValidator validator, String parameterName, String newInput) {
        assert (validator != null) : "Parameter 'validator' of method 'processParameterValue' must not be null";
        assert (parameterName != null && parameterName.length() > 0) : "Parameter 'parameterName' of method 'processParameterValue' must not be empty";
        ValidationResult validationResult = validator.isValid(null, newInput);
        this.m_valueValidationResults.put(parameterName, validationResult);
        StringBuilder sb = new StringBuilder();
        int type = -1;
        if (!this.m_valueValidationResults.isEmpty()) {
            for (Map.Entry<String, ValidationResult> nextEntry : this.m_valueValidationResults.entrySet()) {
                List errors = nextEntry.getValue().getErrors();
                List warnings = nextEntry.getValue().getWarnings();
                if (errors.isEmpty() && warnings.isEmpty()) continue;
                type = !errors.isEmpty() ? 3 : 2;
                sb.append("'").append(nextEntry.getKey()).append("': ");
                for (String next : nextEntry.getValue().getErrors()) {
                    sb.append(next).append(",");
                }
                for (String next : nextEntry.getValue().getWarnings()) {
                    sb.append(next).append(",");
                }
            }
        }
        if (sb.length() == 0) {
            this.setMessage(null);
        } else {
            sb.deleteCharAt(sb.length() - 1);
            this.setMessage(sb.toString(), type);
        }
        return validationResult.isSuccess();
    }

    private void fillTableItem(final TableItem tableItem, ParameterDefinition<?> parameterDefinition, Object parameterValue, boolean fromDefaults) {
        assert (tableItem != null) : "Parameter 'tableItem' of method 'fillTableItem' must not be null";
        assert (parameterDefinition != null) : "Parameter 'parameterDefinition' of method 'fillTableItem' must not be null";
        assert (parameterValue != null) : "Parameter 'parameterValue' of method 'fillTableItem' must not be null";
        ParameterType parameterType = parameterDefinition.getType();
        final String parameterName = parameterDefinition.getName();
        tableItem.setText(0, parameterName);
        tableItem.setText(1, parameterType.getPresentationName());
        TableEditor fromDefaultsTableEditor = new TableEditor(this.m_widgetParameters);
        Button fromDefaultsButton = new Button((Composite)this.m_widgetParameters, 8);
        fromDefaultsButton.setText(fromDefaults ? PARAMETER_FROM_DEFAULTS : PARAMETER_NOT_FROM_DEFAULTS);
        fromDefaultsButton.setEnabled(!fromDefaults);
        fromDefaultsTableEditor.horizontalAlignment = 4;
        fromDefaultsTableEditor.grabHorizontal = true;
        fromDefaultsTableEditor.setEditor((Control)fromDefaultsButton, tableItem, 3);
        tableItem.setData(FROM_DEFAULTS_TABLE_EDITOR, (Object)fromDefaultsTableEditor);
        fromDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'widgetSelected' must not be null");
                }
                RunConfigurationWizardPage.this.m_currentRunConfigurationParameters.removeParameterValue(parameterName);
                RunConfigurationWizardPage.this.updateFromDefaultsInfo();
                ParameterDefinition defaultParameterDefinition = RunConfigurationWizardPage.this.m_parameterDefinitionProvider.getParameterDefinition(parameterName);
                if (!$assertionsDisabled && defaultParameterDefinition == null) {
                    throw new AssertionError((Object)"'defaultParameterDefinition' of method 'widgetSelected' must not be null");
                }
                Object defaultValue = defaultParameterDefinition.getDefaultValue();
                TableEditor valueTableEditor = (TableEditor)tableItem.getData(RunConfigurationWizardPage.VALUE_TABLE_EDITOR);
                if (!$assertionsDisabled && valueTableEditor == null) {
                    throw new AssertionError((Object)"Parameter 'valueTableEditor' of method 'widgetSelected' must not be null");
                }
                Control valueTableEditorControl = valueTableEditor.getEditor();
                switch (defaultParameterDefinition.getType()) {
                    case BOOLEAN: {
                        RunConfigurationWizardPage.this.setBooleanValue(valueTableEditorControl, defaultValue);
                        break;
                    }
                    case STRING: 
                    case INTEGER: {
                        RunConfigurationWizardPage.this.setIntegerOrStringValue(valueTableEditorControl, defaultValue);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("Unhandled type: " + String.valueOf(defaultParameterDefinition.getType())));
                        }
                        break;
                    }
                }
                RunConfigurationWizardPage.this.checkModification(false);
            }
        });
        TableEditor valueTableEditor = new TableEditor(this.m_widgetParameters);
        tableItem.setData(VALUE_TABLE_EDITOR, (Object)valueTableEditor);
        switch (parameterType) {
            case BOOLEAN: {
                ParameterDefinition<?> booleanParameterDefinition = parameterDefinition;
                assert (booleanParameterDefinition.hasPossibleValues()) : "Possible values expected";
                final Combo booleanCombo = new Combo((Composite)this.m_widgetParameters, 12);
                int booleanIndex = 0;
                for (Boolean candidate : booleanParameterDefinition.getPossibleValues()) {
                    booleanCombo.add(candidate.toString());
                    if (candidate.equals(parameterValue)) {
                        booleanCombo.select(booleanIndex);
                    }
                    ++booleanIndex;
                }
                booleanCombo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (!RunConfigurationWizardPage.this.m_inDefaultValueRestore) {
                            RunConfigurationWizardPage.this.m_currentRunConfigurationParameters.setParameterValue(parameterName, (Object)Boolean.valueOf(booleanCombo.getText()));
                            RunConfigurationWizardPage.this.checkModification(true);
                        }
                    }
                });
                valueTableEditor.horizontalAlignment = 4;
                valueTableEditor.grabHorizontal = true;
                valueTableEditor.setEditor((Control)booleanCombo, tableItem, 2);
                break;
            }
            case STRING: {
                ParameterDefinition<?> stringParameterDefinition = parameterDefinition;
                if (stringParameterDefinition.hasPossibleValues()) {
                    final Combo stringCombo = new Combo((Composite)this.m_widgetParameters, 12);
                    int stringIndex = 0;
                    for (String candidate : stringParameterDefinition.getPossibleValues()) {
                        stringCombo.add(candidate);
                        if (candidate.equals(parameterValue)) {
                            stringCombo.select(stringIndex);
                        }
                        ++stringIndex;
                    }
                    stringCombo.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            if (!RunConfigurationWizardPage.this.m_inDefaultValueRestore) {
                                RunConfigurationWizardPage.this.m_currentRunConfigurationParameters.setParameterValue(parameterName, (Object)stringCombo.getText());
                                RunConfigurationWizardPage.this.checkModification(true);
                            }
                        }
                    });
                    valueTableEditor.horizontalAlignment = 4;
                    valueTableEditor.grabHorizontal = true;
                    valueTableEditor.setEditor((Control)stringCombo, tableItem, 2);
                    break;
                }
                final ITextValidator stringValidator = this.getParameterValueValidator(parameterDefinition);
                final Text textString = new Text((Composite)this.m_widgetParameters, 0);
                assert (parameterValue != null && parameterValue instanceof String) : "Unexpected class in method 'fillTableItem': " + String.valueOf(parameterValue);
                textString.setText(parameterValue.toString());
                textString.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (!RunConfigurationWizardPage.this.m_inDefaultValueRestore) {
                            String newInput = textString.getText();
                            if (RunConfigurationWizardPage.this.processParameterValue(stringValidator, parameterName, newInput)) {
                                RunConfigurationWizardPage.this.m_currentRunConfigurationParameters.setParameterValue(parameterName, (Object)newInput);
                            }
                            RunConfigurationWizardPage.this.checkModification(true);
                        }
                    }
                });
                valueTableEditor.horizontalAlignment = 4;
                valueTableEditor.grabHorizontal = true;
                valueTableEditor.setEditor((Control)textString, tableItem, 2);
                break;
            }
            case INTEGER: {
                IntegerParameterDefinition integerParameterDefinition = (IntegerParameterDefinition)parameterDefinition;
                if (integerParameterDefinition.hasPossibleValues()) {
                    final Combo integerCombo = new Combo((Composite)this.m_widgetParameters, 12);
                    int integerIndex = 0;
                    for (Integer candidate : integerParameterDefinition.getPossibleValues()) {
                        integerCombo.add(candidate.toString());
                        if (candidate.equals(parameterValue)) {
                            integerCombo.select(integerIndex);
                        }
                        ++integerIndex;
                    }
                    integerCombo.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            if (!RunConfigurationWizardPage.this.m_inDefaultValueRestore) {
                                RunConfigurationWizardPage.this.m_currentRunConfigurationParameters.setParameterValue(parameterName, (Object)Integer.valueOf(integerCombo.getText()));
                                RunConfigurationWizardPage.this.checkModification(true);
                            }
                        }
                    });
                    valueTableEditor.horizontalAlignment = 4;
                    valueTableEditor.grabHorizontal = true;
                    valueTableEditor.setEditor((Control)integerCombo, tableItem, 2);
                    break;
                }
                final ITextValidator integerValidator = this.getParameterValueValidator(parameterDefinition);
                final Text textInteger = new Text((Composite)this.m_widgetParameters, 0);
                textInteger.setText(parameterValue.toString());
                textInteger.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (!RunConfigurationWizardPage.this.m_inDefaultValueRestore) {
                            String text = textInteger.getText();
                            if (RunConfigurationWizardPage.this.processParameterValue(integerValidator, parameterName, text)) {
                                RunConfigurationWizardPage.this.m_currentRunConfigurationParameters.setParameterValue(parameterName, (Object)Integer.valueOf(text));
                            }
                            RunConfigurationWizardPage.this.checkModification(true);
                        }
                    }
                });
                valueTableEditor.horizontalAlignment = 4;
                valueTableEditor.grabHorizontal = true;
                valueTableEditor.setEditor((Control)textInteger, tableItem, 2);
                break;
            }
            default: {
                assert (false) : "Unhandled type: " + parameterType.getStandardName();
                break;
            }
        }
    }

    private boolean valuesAreValid() {
        for (ValidationResult next : this.m_valueValidationResults.values()) {
            if (!next.isFailure()) continue;
            return false;
        }
        return true;
    }

    public boolean isPageComplete() {
        return this.m_hasValidParameterName && this.valuesAreValid() && this.m_isModified;
    }

    private void checkModification(boolean updateFromDefaults) {
        if (updateFromDefaults) {
            this.updateFromDefaultsInfo();
        }
        this.m_isModified = !this.m_initialName.equals(this.m_currentName) || !this.m_initialDescription.equals(this.m_currentDescription) || !this.m_initialRunConfigurationParameters.equals((Object)this.m_currentRunConfigurationParameters);
        this.setPageComplete(this.m_hasValidParameterName && this.valuesAreValid() && this.m_isModified);
    }

    public String getRunConfigurationName() {
        return this.m_currentName;
    }

    public String getRunConfigurationDescription() {
        return this.m_currentDescription;
    }

    public RunConfigurationParameters getRunConfigurationParameters() {
        return this.m_currentRunConfigurationParameters;
    }
}

