/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.resolutionsview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.author.IAuthorsProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.issuesview.IssueBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingCombo;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class ResolutionDialog
extends StandardDialog
implements ModifyListener,
ISelectionChangedListener {
    private static final String ADD_DEPENDENCY_FROM_PATTERN_PLACEHOLDER = "(Add From Pattern...)";
    private static final String ADD_DEPENDENCY_TO_PATTERN_PLACEHOLDER = "(Add To Pattern...)";
    private static final Pair<String, String> ADD_DEPENDENCY_PATTERN_PLACEHOLDER = new Pair((Object)"(Add From Pattern...)", (Object)"(Add To Pattern...)");
    private static final String ADD_ELEMENT_PATTERN_PLACEHOLDER = "(Add Pattern...)";
    private final List<String> m_originalElementPatterns;
    private final List<Pair<String, String>> m_originalDependencyPatterns;
    private final List<String> m_elementPatterns;
    private final List<Pair<String, String>> m_dependencyPatterns;
    private final String m_originalAssignee;
    private final Priority m_originalPriority;
    private final String m_originalDescription;
    private final Mode m_mode;
    private final List<Issue> m_issues;
    private final IssueBeanAdapter m_issueBeanAdapter = new IssueBeanAdapter();
    private final AssigneeMode m_assigneeMode;
    private PropertyTableViewer<Issue> m_issuesViewer;
    private List<Issue> m_selectedIssues;
    private TableViewer m_elementPatternsViewer;
    private TableViewer m_dependencyPatternsViewer;
    private ValidatingCombo m_assigneeCombo;
    private String m_assignee;
    private ComboViewer m_priorityCombo;
    private Priority m_priority;
    private Text m_descriptionText;
    private String m_description;
    private MenuItem m_deleteElementPatternItem;
    private MenuItem m_deleteDependencyPatternItem;

    ResolutionDialog(Shell parentShell, String title, List<String> elementPatterns, List<Pair<String, String>> dependencyPatterns, String assignee, Priority priority, String description, Mode mode, AssigneeMode assigneeMode, List<Issue> issues) {
        super(parentShell, title);
        assert (mode != null) : "Parameter 'mode' of method 'ResolutionDialog' must not be null";
        assert (assigneeMode != null) : "Parameter 'assigneeMode' of method 'ResolutionDialog' must not be null";
        assert (issues == null || !issues.isEmpty()) : "Parameter 'issues' of method 'ResolutionDialog' must not be null or not empty";
        this.m_issues = issues == null ? null : new ArrayList<Issue>(issues);
        this.m_assigneeMode = assigneeMode;
        this.m_originalAssignee = assignee;
        this.m_originalPriority = priority;
        this.m_originalDescription = description;
        this.m_assignee = assignee;
        this.m_priority = priority;
        this.m_description = description;
        if (elementPatterns != null) {
            this.m_originalElementPatterns = new ArrayList<String>(elementPatterns);
            this.m_originalElementPatterns.add(ADD_ELEMENT_PATTERN_PLACEHOLDER);
            this.m_elementPatterns = new ArrayList<String>(elementPatterns);
            this.m_elementPatterns.add(ADD_ELEMENT_PATTERN_PLACEHOLDER);
        } else {
            this.m_originalElementPatterns = null;
            this.m_elementPatterns = null;
        }
        if (dependencyPatterns != null) {
            this.m_originalDependencyPatterns = new ArrayList<Pair<String, String>>(dependencyPatterns);
            this.m_originalDependencyPatterns.add(ADD_DEPENDENCY_PATTERN_PLACEHOLDER);
            this.m_dependencyPatterns = new ArrayList<Pair<String, String>>(dependencyPatterns);
            this.m_dependencyPatterns.add(ADD_DEPENDENCY_PATTERN_PLACEHOLDER);
        } else {
            this.m_originalDependencyPatterns = null;
            this.m_dependencyPatterns = null;
        }
        this.m_mode = mode;
    }

    ResolutionDialog(Shell parentShell, String title, List<String> elementPatterns, List<Pair<String, String>> dependencyPatterns, String assignee, Priority priority, String description, Mode mode, AssigneeMode assigneeMode) {
        this(parentShell, title, elementPatterns, dependencyPatterns, assignee, priority, description, mode, assigneeMode, null);
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.RESOLUTION_DIALOG;
    }

    protected final int getNumberOfColumns() {
        return 2;
    }

    private void createIssuesBlock(SashForm composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createIssuesBlock' must not be null";
        assert (this.m_issues != null && !this.m_issues.isEmpty()) : "Parameter 'm_issues' of method 'createIssuesBlock' must not be empty";
        this.m_issuesViewer = new PropertyTableViewer((Composite)composite, (BeanPropertyReader.BeanAdapter)this.m_issueBeanAdapter, null, true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_issuesViewer.addColumn("Issue", "issueName", "issueName", "severityImage", 18, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumn("Description", "description", "description", null, 35, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumn("Element", "elementOrFrom", "elementOrFrom", "elementOrFromImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumn("To Element", "to", "to", "toImage", 15, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumn("Provider", "issueProviderName", "issueProviderName", null, 12, PropertyTableViewer.ColumnType.TEXT);
        this.m_selectedIssues = this.m_issues;
        this.m_issuesViewer.setAdditionalFirstColumnInfo(this.m_selectedIssues.size() + " selected");
        this.m_issuesViewer.showData(this.m_issues);
        this.m_issuesViewer.select(this.m_issues);
        this.m_issuesViewer.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResolutionDialog.this.m_selectedIssues = ResolutionDialog.this.m_issuesViewer.getSelected();
                ResolutionDialog.this.m_issuesViewer.setAdditionalFirstColumnInfo(ResolutionDialog.this.m_selectedIssues.size() + " selected");
                ResolutionDialog.this.setOkButtonState();
            }
        });
    }

    protected void fillDialogArea(Composite composite) {
        SashForm sashForm;
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        Composite parent = composite;
        if (this.m_issues != null) {
            sashForm = new SashForm(composite, 512);
            SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
            sashForm.setLayoutData((Object)new GridData(4, 4, true, true, this.getNumberOfColumns(), 1));
            this.createIssuesBlock(sashForm);
            parent = new Composite((Composite)sashForm, 0);
            parent.setLayout((Layout)this.createGridLayout());
            sashForm.setWeights(new int[]{60, 40});
        }
        if (this.m_assignee != null) {
            this.createAssigneeBlock(parent);
        }
        if (this.m_priority != null) {
            this.createPriorityBlock(parent);
        }
        if (this.m_description != null) {
            this.createDescriptionBlock(parent);
        }
        if (this.m_elementPatterns != null && this.m_dependencyPatterns != null) {
            sashForm = new SashForm(parent, 512);
            sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            this.creatElementPatternsTable((Composite)sashForm);
            this.createDependencyPatternsTable((Composite)sashForm);
        } else if (this.m_elementPatterns != null) {
            this.creatElementPatternsTable(parent).setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        } else if (this.m_dependencyPatterns != null) {
            this.createDependencyPatternsTable(parent).setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        }
    }

    protected void applyData() {
        if (this.m_assignee != null) {
            this.m_assigneeCombo.setText(this.m_assignee);
        }
    }

    protected final Mode getMode() {
        return this.m_mode;
    }

    private boolean isElementPatternValid(String pattern) {
        assert (pattern != null) : "Parameter 'pattern' of method 'isElementPatternValid' must not be null";
        return !pattern.isEmpty();
    }

    private boolean isDependencyPatternValid(Pair<String, String> pattern) {
        assert (pattern != null) : "Parameter 'pattern' of method 'isElementPatternValid' must not be null";
        String from = (String)pattern.getFirst();
        String to = (String)pattern.getSecond();
        if (from.isEmpty() || to.isEmpty()) {
            return false;
        }
        if (from.equals(ADD_DEPENDENCY_FROM_PATTERN_PLACEHOLDER) && !to.equals(ADD_DEPENDENCY_TO_PATTERN_PLACEHOLDER)) {
            return false;
        }
        return from.equals(ADD_DEPENDENCY_FROM_PATTERN_PLACEHOLDER) || !to.equals(ADD_DEPENDENCY_TO_PATTERN_PLACEHOLDER);
    }

    private boolean commonInfoMatchesOriginalInput() {
        boolean matches;
        boolean bl = matches = this.m_originalAssignee == null && this.m_assignee == null || this.m_originalAssignee != null && this.m_assignee != null;
        if (matches) {
            boolean bl2 = matches = this.m_originalPriority == null && this.m_priority == null || this.m_originalPriority != null && this.m_priority != null;
        }
        if (matches) {
            boolean bl3 = matches = this.m_originalDescription == null && this.m_description == null || this.m_originalDescription != null && this.m_description != null;
        }
        if (matches) {
            boolean bl4 = matches = this.m_originalElementPatterns == null && this.m_elementPatterns == null || this.m_originalElementPatterns != null && this.m_elementPatterns != null;
        }
        if (matches) {
            boolean bl5 = matches = this.m_originalDependencyPatterns == null && this.m_dependencyPatterns == null || this.m_originalDependencyPatterns != null && this.m_dependencyPatterns != null;
        }
        if (matches && this.m_originalAssignee != null) {
            assert (this.m_assignee != null) : "'m_assignee' of method 'checkModification' must not be null";
            matches = this.m_originalAssignee.equals(this.m_assignee);
        }
        if (matches && this.m_originalPriority != null) {
            assert (this.m_priority != null) : "'m_priority' of method 'checkModification' must not be null";
            matches = this.m_originalPriority.equals((Object)this.m_priority);
        }
        if (matches && this.m_originalDescription != null) {
            assert (this.m_description != null) : "'m_description' of method 'checkModification' must not be null";
            matches = this.m_originalDescription.equals(this.m_description);
        }
        return matches;
    }

    protected boolean hasBeenModified() {
        boolean matchesOriginalInput = this.commonInfoMatchesOriginalInput();
        boolean patternsAreValid = true;
        if (matchesOriginalInput) {
            if (this.m_originalElementPatterns != null) {
                assert (this.m_elementPatterns != null) : "'m_elementPatterns' of method 'originalDataHasBeenModifiedWithValidData' must not be null";
                matchesOriginalInput = this.m_originalElementPatterns.equals(this.m_elementPatterns);
                for (String string : this.m_elementPatterns) {
                    if (this.isElementPatternValid(string)) continue;
                    patternsAreValid = false;
                    break;
                }
            }
            if (matchesOriginalInput && this.m_originalDependencyPatterns != null) {
                assert (this.m_dependencyPatterns != null) : "'m_dependencyPatterns' of method 'originalDataHasBeenModifiedWithValidData' must not be null";
                matchesOriginalInput = this.m_originalDependencyPatterns.equals(this.m_dependencyPatterns);
                if (!matchesOriginalInput) {
                    for (Pair pair : this.m_dependencyPatterns) {
                        if (this.isDependencyPatternValid((Pair<String, String>)pair)) continue;
                        patternsAreValid = false;
                        break;
                    }
                }
            }
        }
        return !matchesOriginalInput && patternsAreValid;
    }

    public boolean hasValidData() {
        boolean isValid = true;
        if (this.m_originalElementPatterns != null) {
            assert (this.m_elementPatterns != null) : "'m_elementPatterns' of method 'originalDataHasBeenModifiedWithValidData' must not be null";
            for (String string : this.m_elementPatterns) {
                if (this.isElementPatternValid(string)) continue;
                isValid = false;
                break;
            }
        }
        if (this.m_originalDependencyPatterns != null) {
            assert (this.m_dependencyPatterns != null) : "'m_dependencyPatterns' of method 'originalDataHasBeenModifiedWithValidData' must not be null";
            for (Pair pair : this.m_dependencyPatterns) {
                if (this.isDependencyPatternValid((Pair<String, String>)pair)) continue;
                isValid = false;
                break;
            }
        }
        if (this.m_assigneeMode == AssigneeMode.SHOW && this.m_assignee == null) {
            isValid = false;
        }
        if (isValid && this.m_issuesViewer != null) {
            isValid = !this.m_issuesViewer.getSelected().isEmpty();
        }
        return isValid;
    }

    protected void setOkButtonState() {
        if (this.getButton(0) == null) {
            return;
        }
        if (this.m_mode == Mode.CREATE) {
            this.getButton(0).setEnabled(this.hasValidData());
        } else {
            assert (this.m_mode == Mode.EDIT) : "Unexpected mode: " + String.valueOf((Object)this.m_mode);
            this.getButton(0).setEnabled(this.hasBeenModified() && this.hasValidData());
        }
    }

    private Composite creatElementPatternsTable(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createNamedElementPatternsTable' must not be null";
        assert (this.m_elementPatterns != null) : "'m_elementPatterns' of method 'createNamedElementPatternsTable' must not be null";
        Composite tableComposite = new Composite(parent, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.m_elementPatternsViewer = new TableViewer(tableComposite, 65540);
        this.m_elementPatternsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_elementPatternsViewer.getTable().setHeaderVisible(true);
        this.m_elementPatternsViewer.getTable().setLinesVisible(true);
        this.m_elementPatternsViewer.getTable().setToolTipText("");
        Menu popupMenuNamedElementPatternsTable = new Menu((Control)this.m_elementPatternsViewer.getTable());
        this.m_deleteElementPatternItem = new MenuItem(popupMenuNamedElementPatternsTable, 64);
        this.m_deleteElementPatternItem.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_deleteElementPatternItem.setText("Delete Pattern(s)");
        this.m_deleteElementPatternItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectedIndices = ResolutionDialog.this.m_elementPatternsViewer.getTable().getSelectionIndices();
                ArrayList<String> patternsToDelete = new ArrayList<String>();
                int[] nArray = selectedIndices;
                int n = selectedIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int nextIndex = nArray[n2];
                    if (nextIndex != -1 && !ResolutionDialog.ADD_ELEMENT_PATTERN_PLACEHOLDER.equals(ResolutionDialog.this.m_elementPatternsViewer.getTable().getItem(nextIndex).getText())) {
                        patternsToDelete.add(ResolutionDialog.this.m_elementPatterns.get(nextIndex));
                    }
                    ++n2;
                }
                ResolutionDialog.this.m_elementPatterns.removeAll(patternsToDelete);
                ResolutionDialog.this.m_elementPatternsViewer.setInput(ResolutionDialog.this.m_elementPatterns);
                ResolutionDialog.this.setOkButtonState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_elementPatternsViewer.getTable().setMenu(popupMenuNamedElementPatternsTable);
        TableViewerColumn patternColumn = new TableViewerColumn(this.m_elementPatternsViewer, 0);
        patternColumn.getColumn().setText("Element Pattern");
        tableColumnLayout.setColumnData((Widget)patternColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(40, 800, true));
        patternColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                StyledString.Styler m_fItalicStyler = new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.font = UiResourceManager.getInstance().getFont(2);
                    }
                };
                String pattern = (String)cell.getElement();
                StyledString styledStringNamedElements = new StyledString(pattern, m_fItalicStyler);
                cell.setText(styledStringNamedElements.toString());
                cell.setStyleRanges(styledStringNamedElements.getStyleRanges());
            }
        });
        patternColumn.setEditingSupport(new EditingSupport(patternColumn.getViewer()){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)ResolutionDialog.this.m_elementPatternsViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                if (element.equals(ResolutionDialog.ADD_ELEMENT_PATTERN_PLACEHOLDER)) {
                    return "";
                }
                return element;
            }

            protected void setValue(Object oldValue, Object newValue) {
                if (!($assertionsDisabled || oldValue != null && oldValue instanceof String)) {
                    throw new AssertionError((Object)("Unexpected class in method 'setValue': " + String.valueOf(oldValue)));
                }
                if (!($assertionsDisabled || newValue != null && newValue instanceof String)) {
                    throw new AssertionError((Object)("Unexpected class in method 'setValue': " + String.valueOf(newValue)));
                }
                if (oldValue.equals(newValue)) {
                    return;
                }
                String oldValueAsString = (String)oldValue;
                String newValueAsString = (String)newValue;
                int oldValueIndex = -1;
                for (String nextPattern : ResolutionDialog.this.m_elementPatterns) {
                    ++oldValueIndex;
                    if (nextPattern.equals(oldValueAsString)) break;
                }
                if (!$assertionsDisabled && oldValueIndex == -1) {
                    throw new AssertionError((Object)"'oldValueIndex' not found in method 'setValue'");
                }
                if (newValueAsString.isEmpty()) {
                    ResolutionDialog.this.m_elementPatterns.remove(oldValueIndex);
                } else {
                    ResolutionDialog.this.m_elementPatterns.set(oldValueIndex, newValueAsString);
                }
                if (!ResolutionDialog.this.m_elementPatterns.contains(ResolutionDialog.ADD_ELEMENT_PATTERN_PLACEHOLDER)) {
                    ResolutionDialog.this.m_elementPatterns.add(ResolutionDialog.ADD_ELEMENT_PATTERN_PLACEHOLDER);
                }
                ResolutionDialog.this.m_elementPatternsViewer.setInput(ResolutionDialog.this.m_elementPatterns);
                ResolutionDialog.this.setOkButtonState();
            }
        });
        this.m_elementPatternsViewer.setInput(this.m_elementPatterns);
        this.m_elementPatternsViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        return tableComposite;
    }

    private Composite createDependencyPatternsTable(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createDependencyPatternsTable' must not be null";
        assert (this.m_dependencyPatterns != null) : "'m_dependencyPatterns' of method 'createDependencyPatternsTable' must not be null";
        Composite tableComposite = new Composite(parent, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.m_dependencyPatternsViewer = new TableViewer(tableComposite, 65540);
        this.m_dependencyPatternsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_dependencyPatternsViewer.getTable().setHeaderVisible(true);
        this.m_dependencyPatternsViewer.getTable().setLinesVisible(true);
        this.m_dependencyPatternsViewer.getTable().setToolTipText("");
        Menu popupMenuDependecyPatternsTable = new Menu((Control)this.m_dependencyPatternsViewer.getTable());
        this.m_deleteDependencyPatternItem = new MenuItem(popupMenuDependecyPatternsTable, 64);
        this.m_deleteDependencyPatternItem.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_deleteDependencyPatternItem.setText("Delete Pattern(s)");
        this.m_deleteDependencyPatternItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectedIndices = ResolutionDialog.this.m_dependencyPatternsViewer.getTable().getSelectionIndices();
                ArrayList<Pair<String, String>> patternsToDelete = new ArrayList<Pair<String, String>>();
                int[] nArray = selectedIndices;
                int n = selectedIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int nextIndex = nArray[n2];
                    String itemText = ResolutionDialog.this.m_dependencyPatternsViewer.getTable().getItem(nextIndex).getText();
                    if (nextIndex != -1 && !itemText.equals(ResolutionDialog.ADD_DEPENDENCY_FROM_PATTERN_PLACEHOLDER) && !itemText.equals(ResolutionDialog.ADD_DEPENDENCY_TO_PATTERN_PLACEHOLDER)) {
                        patternsToDelete.add(ResolutionDialog.this.m_dependencyPatterns.get(nextIndex));
                    }
                    ++n2;
                }
                ResolutionDialog.this.m_dependencyPatterns.removeAll(patternsToDelete);
                ResolutionDialog.this.m_dependencyPatternsViewer.setInput(ResolutionDialog.this.m_dependencyPatterns);
                ResolutionDialog.this.setOkButtonState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_dependencyPatternsViewer.getTable().setMenu(popupMenuDependecyPatternsTable);
        TableViewerColumn fromPatternColumn = new TableViewerColumn(this.m_dependencyPatternsViewer, 0);
        fromPatternColumn.getColumn().setText("Dependency From Pattern");
        tableColumnLayout.setColumnData((Widget)fromPatternColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(40, 400, true));
        fromPatternColumn.setLabelProvider((CellLabelProvider)this.createEndpointCellLabelProvider(true));
        fromPatternColumn.setEditingSupport(this.createDependencyPatternsEditionSupport(true));
        TableViewerColumn toPatternColumn = new TableViewerColumn(this.m_dependencyPatternsViewer, 0);
        toPatternColumn.getColumn().setText("Dependency To Pattern");
        tableColumnLayout.setColumnData((Widget)toPatternColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(40, 400, true));
        toPatternColumn.setLabelProvider((CellLabelProvider)this.createEndpointCellLabelProvider(false));
        toPatternColumn.setEditingSupport(this.createDependencyPatternsEditionSupport(false));
        this.m_dependencyPatternsViewer.setInput(this.m_dependencyPatterns);
        this.m_dependencyPatternsViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        return tableComposite;
    }

    private void createPriorityBlock(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createPriorityBlock' must not be null";
        assert (this.m_priority != null) : "'m_priority' of method 'createPriorityBlock' must not be null";
        Label priorityLabel = new Label(parent, 0);
        priorityLabel.setText("Priority:");
        priorityLabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.m_priorityCombo = new ComboViewer(parent, 2572);
        Priority[] priorityArray = Priority.values();
        int n = priorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Priority priority = priorityArray[n2];
            this.m_priorityCombo.add((Object)priority.getPresentationName());
            ++n2;
        }
        this.m_priorityCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_priorityCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof Priority)) {
                    throw new AssertionError((Object)("Unexpected class: " + element.getClass().getName()));
                }
                Priority priority = (Priority)element;
                return priority.getPresentationName();
            }
        });
        this.m_priorityCombo.setInput((Object)Priority.values());
        this.m_priorityCombo.setSelection((ISelection)new StructuredSelection((Object)this.m_priority));
        this.m_priorityCombo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
        this.m_priorityCombo.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void createAssigneeBlock(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createAssigneeBlock' must not be null";
        assert (this.m_assignee != null) : "'m_assignee' of method 'createAssigneeBlock' must not be null";
        IAuthorsProvider authorsProvider = (IAuthorsProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IAuthorsProvider.class);
        Label assigneeLabel = new Label(parent, 0);
        assigneeLabel.setText("Assignee:");
        assigneeLabel.setLayoutData((Object)new GridData(0, 0, false, false));
        final ITextValidator validator = authorsProvider.getAuthorNameValidator(Collections.emptyList());
        this.m_assigneeCombo = new ValidatingCombo(parent, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                if (newInput.length() == 0) {
                    return new ValidationResult(!Objects.equals(currentInput, newInput));
                }
                return validator.isValid(currentInput, newInput);
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                ResolutionDialog.this.m_assignee = input;
                ResolutionDialog.this.setOkButtonState();
            }
        }, this.m_assignee, authorsProvider.getAuthors(), 2048);
        this.m_assigneeCombo.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    protected boolean fillDescriptionBlockVertically() {
        return this.m_elementPatterns == null && this.m_dependencyPatterns == null;
    }

    private void createDescriptionBlock(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createDescriptionBlock' must not be null";
        assert (this.m_description != null) : "'m_description' of method 'createDescriptionBlock' must not be null";
        Label commentLabel = new Label(parent, 0);
        commentLabel.setText("Description:");
        commentLabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.m_descriptionText = new Text(parent, 2626);
        int preferredHeight = SwtUtility.calculatePreferredHeight((Text)this.m_descriptionText, (int)3);
        GridData gridData = this.fillDescriptionBlockVertically() ? new GridData(4, 4, true, true) : new GridData(4, 0, true, false);
        gridData.heightHint = preferredHeight;
        this.m_descriptionText.setLayoutData((Object)gridData);
        this.m_descriptionText.setText(this.m_description);
        this.m_descriptionText.addModifyListener((ModifyListener)this);
    }

    protected Point getPreferredSize() {
        return new Point(800, 500);
    }

    protected void okPressed() {
        if (this.m_elementPatterns != null && !this.m_elementPatterns.isEmpty()) {
            this.m_elementPatterns.remove(this.m_elementPatterns.size() - 1);
        }
        if (this.m_dependencyPatterns != null && !this.m_dependencyPatterns.isEmpty()) {
            this.m_dependencyPatterns.remove(this.m_dependencyPatterns.size() - 1);
        }
        super.okPressed();
    }

    private StyledCellLabelProvider createEndpointCellLabelProvider(final boolean first) {
        return new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                StyledString.Styler m_fItalicStyler = new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.font = UiResourceManager.getInstance().getFont(2);
                    }
                };
                Pair patterns = (Pair)cell.getElement();
                String pattern = first ? (String)patterns.getFirst() : (String)patterns.getSecond();
                StyledString styledStringDependencyPatternFrom = new StyledString(pattern, m_fItalicStyler);
                cell.setText(styledStringDependencyPatternFrom.toString());
                cell.setStyleRanges(styledStringDependencyPatternFrom.getStyleRanges());
            }
        };
    }

    private EditingSupport createDependencyPatternsEditionSupport(final boolean first) {
        return new EditingSupport((ColumnViewer)this.m_dependencyPatternsViewer){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)ResolutionDialog.this.m_dependencyPatternsViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof Pair)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getValue': " + String.valueOf(element)));
                }
                Pair value = (Pair)element;
                if (value.equals(ADD_DEPENDENCY_PATTERN_PLACEHOLDER)) {
                    return "";
                }
                return first ? value.getFirst() : value.getSecond();
            }

            protected void setValue(Object oldValue, Object newValue) {
                if (!($assertionsDisabled || oldValue != null && oldValue instanceof Pair)) {
                    throw new AssertionError((Object)("Unexpected class in method 'setValue': " + String.valueOf(oldValue)));
                }
                if (!($assertionsDisabled || newValue != null && newValue instanceof String)) {
                    throw new AssertionError((Object)("Unexpected class in method 'setValue': " + String.valueOf(newValue)));
                }
                Pair oldValueAsPair = (Pair)oldValue;
                String newValueAsString = (String)newValue;
                if (first ? ((String)oldValueAsPair.getFirst()).equals(newValueAsString) : ((String)oldValueAsPair.getSecond()).equals(newValueAsString)) {
                    return;
                }
                int oldValueIndex = -1;
                for (Pair<String, String> nextPattern : ResolutionDialog.this.m_dependencyPatterns) {
                    ++oldValueIndex;
                    if (oldValueAsPair.equals(nextPattern)) break;
                }
                if (!$assertionsDisabled && oldValueIndex == -1) {
                    throw new AssertionError((Object)"'oldValueIndex' not found in method 'setValue'");
                }
                boolean setValue = true;
                if (newValueAsString.isEmpty() && (first && ((String)oldValueAsPair.getSecond()).equals(ResolutionDialog.ADD_DEPENDENCY_TO_PATTERN_PLACEHOLDER) || !first && ((String)oldValueAsPair.getFirst()).equals(ResolutionDialog.ADD_DEPENDENCY_FROM_PATTERN_PLACEHOLDER) || first && ((String)oldValueAsPair.getSecond()).equals("") || !first && ((String)oldValueAsPair.getFirst()).equals(""))) {
                    ResolutionDialog.this.m_dependencyPatterns.remove(oldValueIndex);
                    setValue = false;
                }
                if (setValue) {
                    if (first) {
                        ResolutionDialog.this.m_dependencyPatterns.set(oldValueIndex, (Pair<String, String>)new Pair((Object)newValueAsString, (Object)((String)oldValueAsPair.getSecond())));
                    } else {
                        ResolutionDialog.this.m_dependencyPatterns.set(oldValueIndex, (Pair<String, String>)new Pair((Object)((String)oldValueAsPair.getFirst()), (Object)newValueAsString));
                    }
                }
                if (!ResolutionDialog.this.m_dependencyPatterns.contains(ADD_DEPENDENCY_PATTERN_PLACEHOLDER)) {
                    ResolutionDialog.this.m_dependencyPatterns.add(ADD_DEPENDENCY_PATTERN_PLACEHOLDER);
                }
                ResolutionDialog.this.m_dependencyPatternsViewer.setInput(ResolutionDialog.this.m_dependencyPatterns);
                ResolutionDialog.this.setOkButtonState();
            }
        };
    }

    public String getAssignee() {
        return this.m_assignee;
    }

    public Priority getPriority() {
        return this.m_priority;
    }

    public String getDescription() {
        return this.m_description;
    }

    public List<String> getNamedElementPatterns() {
        return this.m_elementPatterns;
    }

    public List<Pair<String, String>> getDependencyPatterns() {
        return this.m_dependencyPatterns;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.setOkButtonState();
        return control;
    }

    public void modifyText(ModifyEvent event) {
        assert (event != null) : "Parameter 'event' of method 'modifyText' must not be null";
        if (event.getSource() == this.m_descriptionText) {
            this.m_description = this.m_descriptionText.getText();
        }
        this.setOkButtonState();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (event.getSource() == this.m_priorityCombo) {
            this.m_priority = (Priority)selection.getFirstElement();
            this.setOkButtonState();
        } else if (event.getSource() == this.m_elementPatternsViewer) {
            this.m_deleteElementPatternItem.setEnabled(!selection.isEmpty() && selection.getFirstElement() != ADD_ELEMENT_PATTERN_PLACEHOLDER);
        } else if (event.getSource() == this.m_dependencyPatternsViewer) {
            this.m_deleteDependencyPatternItem.setEnabled(!selection.isEmpty() && selection.getFirstElement() != ADD_DEPENDENCY_PATTERN_PLACEHOLDER);
        } else assert (false) : "Unhandled control: " + String.valueOf(event.getSource());
    }

    List<Issue> getSelectedIssues() {
        if (this.m_selectedIssues == null) {
            return Collections.emptyList();
        }
        return this.m_selectedIssues;
    }

    public static enum AssigneeMode {
        SHOW,
        HIDE;

    }

    public static enum Mode {
        CREATE,
        EDIT;

    }
}

