/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.qualitygateview;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractIssueDiffAgainstBaselineConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IssueDiffAgainstBaselineConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateDiffCheck;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineConditionInfo;
import com.hello2morrow.sonargraph.ui.standalone.qualitygateview.AbstractQualityGateConditionWizard;
import com.hello2morrow.sonargraph.ui.standalone.qualitygateview.BaselineIssueConditionWizardPage;
import java.util.List;
import java.util.Set;

final class BaselineIssueConditionWizard
extends AbstractQualityGateConditionWizard<BaselineIssueConditionWizardPage> {
    private final AbstractIssueDiffAgainstBaselineConditionInfo m_conditionToEdit;

    public BaselineIssueConditionWizard(IQualityGateProvider qualityGateProvider, Set<IIssueId> issueIds, Set<IMetricDescriptor> metricDescriptors) {
        super("Create New Baseline Quality Gate Issue Condition", qualityGateProvider, issueIds, metricDescriptors, false);
        this.m_conditionToEdit = null;
    }

    public BaselineIssueConditionWizard(IQualityGateProvider qualityGateProvider, AbstractIssueDiffAgainstBaselineConditionInfo conditionToEdit, Set<IIssueId> issueIds, Set<IMetricDescriptor> metricDescriptors) {
        super("Edit Baseline Quality Gate Issue Condition", qualityGateProvider, issueIds, metricDescriptors, false);
        assert (conditionToEdit != null) : "Parameter 'conditionToEdit' of method 'BaselineIssueConditionWizard' must not be null";
        this.m_conditionToEdit = conditionToEdit;
    }

    @Override
    protected BaselineIssueConditionWizardPage createWizardPage(String name, IQualityGateProvider qualityGateProvider, List<String> availableIssueTypes, List<String> availableMetricIds) {
        BaselineIssueConditionWizardPage wizardPage;
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createInfoPage' must not be empty";
        assert (qualityGateProvider != null) : "Parameter 'qualityGateProvider' of method 'createInfoPage' must not be null";
        assert (availableIssueTypes != null) : "Parameter 'availableIssueTypes' of method 'createWizardPage' must not be null";
        assert (availableMetricIds != null) : "Parameter 'availableMetricIds' of method 'createWizardPage' must not be null";
        if (this.m_conditionToEdit == null) {
            wizardPage = new BaselineIssueConditionWizardPage(name, qualityGateProvider, availableIssueTypes, availableMetricIds);
        } else if (this.m_conditionToEdit instanceof IssueDiffAgainstBaselineConditionInfo) {
            IssueDiffAgainstBaselineConditionInfo issueCond = (IssueDiffAgainstBaselineConditionInfo)this.m_conditionToEdit;
            wizardPage = new BaselineIssueConditionWizardPage(name, qualityGateProvider, availableIssueTypes, availableMetricIds, issueCond.getIssueType(), issueCond.getSeverities(), issueCond.getResolutions(), "Any", Operator.N_A, null, null, issueCond.getCheck());
        } else if (this.m_conditionToEdit instanceof ThresholdIssueDiffAgainstBaselineConditionInfo) {
            ThresholdIssueDiffAgainstBaselineConditionInfo issueCond = (ThresholdIssueDiffAgainstBaselineConditionInfo)this.m_conditionToEdit;
            wizardPage = new BaselineIssueConditionWizardPage(name, qualityGateProvider, availableIssueTypes, availableMetricIds, issueCond.getIssueType(), issueCond.getSeverities(), issueCond.getResolutions(), issueCond.getMetricId(), issueCond.getOperator(), issueCond.getDiffThreshold(), issueCond.getDiffThresholdRelative(), issueCond.getCheck());
        } else {
            assert (false) : "Unsupported condition type: " + this.m_conditionToEdit.getClass().getCanonicalName();
            wizardPage = null;
        }
        return wizardPage;
    }

    @Override
    protected IQualityGateConditionInfo createConditionInfo(BaselineIssueConditionWizardPage page) {
        assert (page != null) : "Parameter 'page' of method 'createConditionInfo' must not be null";
        QualityGateDiffCheck check = page.getCheck();
        Object conditionInfo = page.isThresholdCondition() ? new ThresholdIssueDiffAgainstBaselineConditionInfo(page.getIssueType(), page.getSeverities(), page.getResolutions(), page.getMetricId(), page.getOperator(), page.getThresholdAbsolute(), page.getThresholdRelative(), check) : (check != null ? new IssueDiffAgainstBaselineConditionInfo(page.getIssueType(), page.getSeverities(), page.getResolutions(), check) : new IssueDiffAgainstBaselineConditionInfo(page.getIssueType(), page.getSeverities(), page.getResolutions()));
        return conditionInfo;
    }
}

