/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.qualitygateview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateMatchingElement;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import com.hello2morrow.sonargraph.ui.standalone.qualitygateview.AbstractQualityGateElementWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.WildcardContentProposalProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

abstract class AbstractQualityGateIssueElementWizardPage
extends AbstractQualityGateElementWizardPage {
    private ValidatingTextWidget m_issueTypeText;
    private String m_issueType = "Any";
    private String m_originalIssueType;
    private Button m_severityError;
    private Button m_severityWarning;
    private Button m_severityInfo;
    private List<String> m_severities = Severity.getPresentationNamesList();
    private List<String> m_originalSeverities;
    private Button m_resolutionNone;
    private Button m_resolutionIgnore;
    private Button m_resolutionTask;
    private List<String> m_resolutions = new ArrayList<String>(Arrays.asList(ResolutionType.NONE.getPresentationName()));
    private List<String> m_originalResolutions;
    private final List<String> m_availableIssueTypes;
    private Label m_severityLabel;
    private ControlDecoration m_severityDecoration;
    private Label m_resolutionLabel;
    private ControlDecoration m_resolutionDecoration;

    protected AbstractQualityGateIssueElementWizardPage(String pageName, String title, IQualityGateProvider qualityGateProvider, List<String> availableIssueTypes, List<String> metricIds) {
        super(pageName, title, qualityGateProvider, metricIds);
        assert (availableIssueTypes != null) : "Parameter 'availableIssueTypes' of method 'AbstractQualityGateIssueElementWizardPage' must not be null";
        this.m_availableIssueTypes = availableIssueTypes;
    }

    protected AbstractQualityGateIssueElementWizardPage(String pageName, String title, IQualityGateProvider qualityGateProvider, List<String> availableIssueTypes, List<String> availableMetricIds, String issueType, List<String> severities, List<String> resolutions, String metricId) {
        super(pageName, title, qualityGateProvider, availableMetricIds, metricId);
        assert (availableIssueTypes != null) : "Parameter 'availableIssueTypes' of method 'AbstractQualityGateIssueElementWizardPage' must not be null";
        this.m_issueType = issueType;
        this.m_originalIssueType = issueType;
        this.m_severities = new ArrayList<String>(severities);
        this.m_originalSeverities = new ArrayList<String>(severities);
        this.m_resolutions = new ArrayList<String>(resolutions);
        this.m_originalResolutions = new ArrayList<String>(resolutions);
        this.m_availableIssueTypes = availableIssueTypes;
    }

    abstract boolean isThresholdCondition();

    @Override
    protected boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return !this.m_issueType.equalsIgnoreCase(this.m_originalIssueType) || !this.valuesListsContainSameElements(this.m_originalSeverities, this.m_severities) || !this.valuesListsContainSameElements(this.m_originalResolutions, this.m_resolutions);
    }

    protected void createContent(Composite composite) {
        this.createStandardInputWidgets(composite);
        this.createMetricIdWidgets(composite, "Metric ID:");
        this.createInfoWidget(composite);
        this.finishCreateContent();
    }

    protected void finishCreateContent() {
        this.triggerIssueTypeValidation();
        List severities = this.getQualityGateProvider().getSeveritiesForIssueType(this.m_issueType);
        this.updateSeverityChoices(severities);
    }

    protected void updateSeverityChoices(List<Severity> severities) {
        assert (severities != null && severities.size() > 0) : "Parameter 'severities' of method 'updateSeverityChoices' must not be empty";
        this.m_severityError.setEnabled(severities.contains(Severity.ERROR));
        this.m_severityWarning.setEnabled(severities.contains(Severity.WARNING));
        this.m_severityInfo.setEnabled(severities.contains(Severity.INFO));
        this.updateSeverities();
        this.validateInput();
    }

    protected final void createStandardInputWidgets(Composite composite) {
        Label issueTypeLabel = new Label(composite, 0);
        String toolTipText = "Supports auto-completion. Enter '*' to see available issue types, 'Any' as wildcard.";
        issueTypeLabel.setText("Issue Type:");
        issueTypeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        issueTypeLabel.setToolTipText("Supports auto-completion. Enter '*' to see available issue types, 'Any' as wildcard.");
        this.m_issueTypeText = new ValidatingTextWidget(composite, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null || newInput.trim().isEmpty()) {
                    result.addError("Must not be empty");
                } else if (!newInput.trim().equals("Any") && newInput.indexOf(":") < 0) {
                    result.addWarning("Missing provider prefix");
                }
                return result;
            }
        }, this.createIssueTypeConsumer(), this.m_issueType, this.m_availableIssueTypes, EnumSet.of(WildcardContentProposalProvider.WildcardPosition.START, WildcardContentProposalProvider.WildcardPosition.END));
        this.m_issueTypeText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_issueTypeText.getTextField().setToolTipText("Supports auto-completion. Enter '*' to see available issue types, 'Any' as wildcard.");
        this.m_severityLabel = new Label(composite, 0);
        this.m_severityLabel.setText("Severity:");
        this.m_severityLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Composite severityCheckBoxes = new Composite(composite, 0);
        severityCheckBoxes.setLayoutData((Object)new GridData(1, 4, false, false));
        severityCheckBoxes.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)3, (boolean)false));
        this.m_severityError = this.createSeverityCheckBox(severityCheckBoxes, Severity.ERROR);
        this.m_severityWarning = this.createSeverityCheckBox(severityCheckBoxes, Severity.WARNING);
        this.m_severityInfo = this.createSeverityCheckBox(severityCheckBoxes, Severity.INFO);
        this.m_resolutionLabel = new Label(composite, 0);
        this.m_resolutionLabel.setText("Resolution:");
        this.m_resolutionLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Composite resolutionCheckBoxes = new Composite(composite, 0);
        resolutionCheckBoxes.setLayoutData((Object)new GridData(1, 4, false, false));
        resolutionCheckBoxes.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)3, (boolean)false));
        this.m_resolutionNone = this.createResolutionCheckBox(resolutionCheckBoxes, ResolutionMode.NONE);
        this.m_resolutionIgnore = this.createResolutionCheckBox(resolutionCheckBoxes, ResolutionMode.IGNORE);
        this.m_resolutionTask = this.createResolutionCheckBox(resolutionCheckBoxes, ResolutionMode.TASK);
    }

    private Button createSeverityCheckBox(Composite severityCheckBoxes, Severity severity) {
        Button severityCheck = new Button(severityCheckBoxes, 32);
        severityCheck.setSelection(this.m_severities.contains(severity.getStandardName()));
        severityCheck.setText(severity.getPresentationName());
        severityCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractQualityGateIssueElementWizardPage.this.updateSeverities();
                AbstractQualityGateIssueElementWizardPage.this.validateInput();
            }
        });
        return severityCheck;
    }

    private Button createResolutionCheckBox(Composite resolutionCheckBoxes, ResolutionMode mode) {
        Button resolutionCheck = new Button(resolutionCheckBoxes, 32);
        resolutionCheck.setSelection(this.m_resolutions.contains(mode.getStandardName()));
        resolutionCheck.setText(mode.getPresentationName());
        resolutionCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractQualityGateIssueElementWizardPage.this.updateResolutions();
                AbstractQualityGateIssueElementWizardPage.this.validateInput();
            }
        });
        return resolutionCheck;
    }

    private void updateSeverities() {
        this.m_severities.clear();
        if (this.m_severityError.isEnabled() && this.m_severityError.getSelection()) {
            this.m_severities.add(Severity.ERROR.getStandardName());
        }
        if (this.m_severityWarning.isEnabled() && this.m_severityWarning.getSelection()) {
            this.m_severities.add(Severity.WARNING.getStandardName());
        }
        if (this.m_severityInfo.isEnabled() && this.m_severityInfo.getSelection()) {
            this.m_severities.add(Severity.INFO.getStandardName());
        }
    }

    private void updateResolutions() {
        this.m_resolutions.clear();
        if (this.m_resolutionNone.isEnabled() && this.m_resolutionNone.getSelection()) {
            this.m_resolutions.add(ResolutionMode.NONE.getStandardName());
        }
        if (this.m_resolutionIgnore.isEnabled() && this.m_resolutionIgnore.getSelection()) {
            this.m_resolutions.add(ResolutionMode.IGNORE.getStandardName());
        }
        if (this.m_resolutionTask.isEnabled() && this.m_resolutionTask.getSelection()) {
            this.m_resolutions.add(ResolutionMode.TASK.getStandardName());
        }
    }

    protected void setSeverityError(String text) {
        this.updateControlDecoration((Control)this.m_severityLabel, this.m_severityDecoration, text, decoration -> {
            ControlDecoration controlDecoration = this.m_severityDecoration = decoration;
        });
    }

    protected void setResolutionError(String text) {
        this.updateControlDecoration((Control)this.m_resolutionLabel, this.m_resolutionDecoration, text, decoration -> {
            ControlDecoration controlDecoration = this.m_resolutionDecoration = decoration;
        });
    }

    private void updateControlDecoration(Control control, ControlDecoration decoration, String text, Consumer<ControlDecoration> consumer) {
        assert (text != null) : "Parameter 'text' of method 'updateControlDecoration' must not be null";
        if (text.trim().isEmpty()) {
            if (control != null && decoration != null) {
                decoration.setDescriptionText("");
                decoration.hide();
            }
        } else {
            if (decoration == null) {
                decoration = new ControlDecoration(control, 131200);
                consumer.accept(decoration);
            }
            decoration.setImage(UiResourceManager.getInstance().getImage("ErrorMarker"));
            decoration.setDescriptionText(text);
            decoration.show();
        }
    }

    protected final boolean validateSeverity(List<String> infoLines) {
        assert (infoLines != null) : "Parameter 'infoLines' of method 'validateSeverity' must not be null";
        if (this.getSeverities().isEmpty()) {
            this.setSeverityError("Missing Severity");
            infoLines.add("Missing severity.");
            return false;
        }
        this.setSeverityError("");
        return true;
    }

    protected final boolean validateResolution(List<String> infoLines) {
        assert (infoLines != null) : "Parameter 'infoLines' of method 'validateResolution' must not be null";
        if (this.getResolutions().isEmpty()) {
            this.setResolutionError("Missing Resolution");
            infoLines.add("Missing resolution.");
            return false;
        }
        this.setResolutionError("");
        return true;
    }

    protected final void triggerIssueTypeValidation() {
        this.m_issueTypeText.validate(true);
    }

    protected ValidatingTextOrComboWidget.IConsumer createIssueTypeConsumer() {
        return new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                AbstractQualityGateIssueElementWizardPage.this.setIssueType(input != null ? input.trim() : null);
                boolean doesIssueTypeSupportMetricId = input != null ? AbstractQualityGateMatchingElement.doesIssueTypeSupportMetricId((String)AbstractQualityGateIssueElementWizardPage.this.getIssueType()) : false;
                AbstractQualityGateIssueElementWizardPage.this.enableMetricIdInput(doesIssueTypeSupportMetricId);
                if (doesIssueTypeSupportMetricId) {
                    AbstractQualityGateIssueElementWizardPage.this.getMetricIdText().validate(false);
                }
                if (input != null && input.trim().length() > 0) {
                    List severities = AbstractQualityGateIssueElementWizardPage.this.getQualityGateProvider().getSeveritiesForIssueType(input.trim());
                    AbstractQualityGateIssueElementWizardPage.this.updateSeverityChoices(severities);
                }
                AbstractQualityGateIssueElementWizardPage.this.validateInput();
            }
        };
    }

    protected final void setIssueType(String issueType) {
        this.m_issueType = issueType;
    }

    final List<String> createSeverityEntries(String issueType) {
        List severities = this.getQualityGateProvider().getSeveritiesForIssueType(issueType);
        List<String> severityLabels = severities.stream().map(s -> s.getPresentationName()).collect(Collectors.toList());
        severityLabels.add(0, "Any");
        return severityLabels;
    }

    final List<String> createResolutionEntries() {
        ArrayList<String> resolutionTypes = new ArrayList<String>();
        resolutionTypes.add(ResolutionMode.NONE.getPresentationName());
        resolutionTypes.add(ResolutionMode.IGNORE.getPresentationName());
        resolutionTypes.add(ResolutionMode.TASK.getPresentationName());
        resolutionTypes.add("Any");
        return resolutionTypes;
    }

    final String getIssueType() {
        return this.m_issueType;
    }

    final List<String> getSeverities() {
        return this.m_severities;
    }

    final List<String> getResolutions() {
        return this.m_resolutions;
    }

    protected final boolean valuesListsContainSameElements(List<String> list1, List<String> list2) {
        assert (list1 != null) : "Parameter 'list1' of method 'valuesListsContainSameElements' must not be null";
        assert (list2 != null) : "Parameter 'list2' of method 'valuesListsContainSameElements' must not be null";
        return list1.containsAll(list2) && list2.containsAll(list1);
    }
}

