/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.qualitygateview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.WildcardContentProposalProvider;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

abstract class AbstractQualityGateElementWizardPage
extends StandardWizardPage {
    protected static final String ANY = "Any";
    private ValidatingTextWidget m_metricIdText;
    private String m_originalMetricId;
    private String m_metricId = "Any";
    private Text m_infoText;
    private final boolean m_isEdit;
    private final IQualityGateProvider m_qualityGateProvider;
    private final List<String> m_availableMetricIds;

    public AbstractQualityGateElementWizardPage(String pageName, String title, IQualityGateProvider qualityGateProvider, List<String> availableMetricIds) {
        super(pageName, title);
        assert (qualityGateProvider != null) : "Parameter 'qualityGateProvider' of method 'AbstractQualityGateElementWizardPage' must not be null";
        assert (availableMetricIds != null) : "Parameter 'availableMetricIds' of method 'AbstractQualityGateElementWizardPage' must not be null";
        this.m_qualityGateProvider = qualityGateProvider;
        this.m_isEdit = false;
        this.m_availableMetricIds = availableMetricIds;
    }

    public AbstractQualityGateElementWizardPage(String pageName, String title, IQualityGateProvider qualityGateProvider, List<String> availableMetricIds, String metricId) {
        super(pageName, title);
        assert (qualityGateProvider != null) : "Parameter 'qualityGateProvider' of method 'AbstractQualityGateElementWizardPage' must not be null";
        this.m_qualityGateProvider = qualityGateProvider;
        this.m_isEdit = true;
        this.m_availableMetricIds = availableMetricIds;
        this.m_originalMetricId = metricId;
        this.m_metricId = metricId;
    }

    protected final boolean isEdit() {
        return this.m_isEdit;
    }

    protected final IQualityGateProvider getQualityGateProvider() {
        return this.m_qualityGateProvider;
    }

    protected final void setInfoText(String text) {
        assert (text != null) : "Parameter 'text' of method 'setInfoText' must not be null";
        assert (this.m_infoText != null) : "m_infoText must not be null";
        this.m_infoText.setText(text);
    }

    protected final void createMetricIdWidgets(Composite composite, String label) {
        String toolTipText = "Supports auto-completion. Enter '*' to see available metric IDs, 'Any' as wildcard.";
        Label metricIdLabel = new Label(composite, 0);
        metricIdLabel.setText(label);
        metricIdLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        metricIdLabel.setToolTipText("Supports auto-completion. Enter '*' to see available metric IDs, 'Any' as wildcard.");
        this.m_metricIdText = new ValidatingTextWidget(composite, this.createMetricIdValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                AbstractQualityGateElementWizardPage.this.m_metricId = input != null ? input.trim() : "";
                AbstractQualityGateElementWizardPage.this.metricIdUpdated(AbstractQualityGateElementWizardPage.this.m_metricId);
                AbstractQualityGateElementWizardPage.this.validateInput();
            }
        }, this.m_metricId, this.m_availableMetricIds, EnumSet.of(WildcardContentProposalProvider.WildcardPosition.START, WildcardContentProposalProvider.WildcardPosition.END));
        this.m_metricIdText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_metricIdText.getTextField().setToolTipText("Supports auto-completion. Enter '*' to see available metric IDs, 'Any' as wildcard.");
    }

    protected void metricIdUpdated(String metricId) {
    }

    protected ITextValidator createMetricIdValidator() {
        return new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null || newInput.trim().isEmpty()) {
                    result.addError("Must not be empty. Use 'Any' as wildcard if metric ID is not relevant.");
                }
                return result;
            }
        };
    }

    protected final void enableMetricIdInput(boolean enabled) {
        this.m_metricIdText.setEnabled(enabled);
    }

    protected final void createInfoWidget(Composite composite) {
        SwtUtility.placeHorizontalSeparator((Composite)composite, (int)this.getNumberOfColumns());
        Group group = new Group(composite, 32);
        group.setText("Info Text");
        group.setLayoutData((Object)new GridData(4, 4, true, true, this.getNumberOfColumns(), 1));
        group.setLayout((Layout)new FillLayout(768));
        this.m_infoText = new Text((Composite)group, 66);
        this.m_infoText.setEditable(false);
    }

    protected ITextValidator createFloatValidator() {
        return new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput.trim().length() == 0) {
                    result.addError("Must not be empty");
                } else {
                    Number number = NumberUtility.parse((String)newInput.trim(), (boolean)false);
                    if (number == null) {
                        result.addError("Not a float value");
                    }
                }
                return result;
            }
        };
    }

    protected abstract boolean validateInputFields();

    protected final void validateInput() {
        boolean isValid = this.validateInputFields();
        if (this.m_isEdit) {
            this.setPageComplete(isValid && this.isModified());
        } else {
            this.setPageComplete(isValid);
        }
    }

    protected boolean isModified() {
        return !StringUtility.areEqual((String)this.m_originalMetricId, (String)this.m_metricId);
    }

    final String getMetricId() {
        return this.m_metricId;
    }

    protected ValidatingTextWidget getMetricIdText() {
        return this.m_metricIdText;
    }
}

