/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.navigationview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IPhysicalElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringInfo;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DragSourceAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DropTargetAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.NamedElementViewComparator;
import com.hello2morrow.sonargraph.ui.standalone.navigationview.NavigationViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.presentationmodeview.PresentationModeView;
import com.hello2morrow.sonargraph.ui.standalone.resolutionsview.CreateMoveRenameRefactoringHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DropLocation;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.NavigationViewShowInViewSupport;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewContentExclusionFilter;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;

public final class NavigationView
extends PresentationModeView
implements DropTargetAdapter.IDropTargetActionHandler<NamedElement>,
DragSourceAdapter.IDragActionHandler<NamedElement> {
    private NavigationViewContentAndLabelProvider m_contentAndLabelProvider;
    private MoveRenameRefactoringInfo m_moveRenameDragAndDropInfo = null;
    private List<NamedElement> m_dragSelection = null;

    public IViewId getViewId() {
        return ViewId.NAVIGATION_VIEW;
    }

    protected void createViewContent(Composite viewContentArea) {
        super.createViewContent(viewContentArea);
        DropTargetAdapter dropTargetAdapter = new DropTargetAdapter((StructuredViewer)this.getTreeViewer(), this, Collections.singletonList(NamedElement.class), false);
        new DragSourceAdapter<NamedElement>((StructuredViewer)this.getTreeViewer(), 2, Collections.singletonList(dropTargetAdapter), Collections.singletonList(NamedElement.class), this);
    }

    @Override
    public boolean validateDrag(List<NamedElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'validateDrag' must not be empty";
        MoveRenameRefactoringInfo info = ((IIssueProvider)this.getSoftwareSystem().getExtension(IIssueProvider.class)).isMoveRenameRefactoringPossible(new ArrayList<NamedElement>(elements));
        if (info != null && (info.getRefactoringType() == RefactoringType.MOVE || info.getRefactoringType() == RefactoringType.MOVE_RENAME) && this.getElementInteractor().dragAndDropStarted()) {
            this.m_moveRenameDragAndDropInfo = info;
            this.m_dragSelection = elements;
            return true;
        }
        return false;
    }

    @Override
    public void dragFinished() {
        this.m_moveRenameDragAndDropInfo = null;
        this.m_dragSelection = null;
        this.getElementInteractor().dragAndDropFinished();
    }

    @Override
    public boolean validateDrop(NamedElement target, int operation, TransferData transferType) {
        assert (target != null) : "Parameter 'target' of method 'validateDrop' must not be null";
        if (this.m_moveRenameDragAndDropInfo != null) {
            if (this.m_dragSelection.contains(target)) {
                return false;
            }
            MoveRenameRefactoringInfo info = ((IIssueProvider)this.getSoftwareSystem().getExtension(IIssueProvider.class)).isPossibleMoveRefactoringTarget(this.m_moveRenameDragAndDropInfo, (Element)target);
            if (info != null && (info.getRefactoringType() == RefactoringType.MOVE || info.getRefactoringType() == RefactoringType.MOVE_RENAME)) {
                this.m_moveRenameDragAndDropInfo = info;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean perform(NamedElement target, DropLocation location, List<NamedElement> dropped, StructuredViewer viewer) {
        assert (target != null) : "Parameter 'target' of method 'perform' must not be null";
        assert (location != null) : "Parameter 'location' of method 'perform' must not be null";
        assert (dropped != null && !dropped.isEmpty()) : "Parameter 'dropped' of method 'perform' must not be empty";
        if (this.m_moveRenameDragAndDropInfo != null) {
            IIssueProvider issueProvider = (IIssueProvider)this.getSoftwareSystem().getExtension(IIssueProvider.class);
            CreateMoveRenameRefactoringHandler.requestUserToPerformMoveRenameRefactoring(issueProvider, this.m_moveRenameDragAndDropInfo);
            this.m_moveRenameDragAndDropInfo = null;
            return true;
        }
        this.m_moveRenameDragAndDropInfo = null;
        return false;
    }

    protected void configureTreeViewer(TreeViewer treeViewer) {
        assert (treeViewer != null) : "Parameter 'treeViewer' of method 'configureTreeViewer' must not be null";
        this.m_contentAndLabelProvider = new NavigationViewContentAndLabelProvider();
        treeViewer.setContentProvider((IContentProvider)this.m_contentAndLabelProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.m_contentAndLabelProvider));
        NamedElementViewComparator comparator = new NamedElementViewComparator();
        treeViewer.setComparator((ViewerComparator)comparator);
        treeViewer.setUseHashlookup(true);
        ArrayList<IViewContentExclusionFilter> filters = new ArrayList<IViewContentExclusionFilter>();
        filters.add((IViewContentExclusionFilter)NavigationViewShowInViewSupport.FILTER);
        filters.addAll(WorkbenchRegistry.getInstance().getViewContentFilters((IViewId)ViewId.NAVIGATION_VIEW));
        this.m_contentAndLabelProvider.setViewContentExclusionFilters(filters);
        comparator.setCategoryProvider(new CategoryProvider(WorkbenchRegistry.getInstance().getViewCategoryProviders((IViewId)ViewId.NAVIGATION_VIEW)));
    }

    protected Class<?> getParentClassForExpansion() {
        return IPhysicalElement.class;
    }

    @Override
    protected void presentationModeChanged() {
        this.m_contentAndLabelProvider.setPresentationMode(this.getPresentationMode());
    }

    public void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.removeListeners();
        this.getTreeViewer().getControl().setRedraw(false);
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        this.m_contentAndLabelProvider.setPresentationMode(this.getPresentationMode());
        this.getTreeViewer().setInput(softwareSystem.getUniqueExistingChild(Workspace.class));
        this.getTreeViewer().getControl().setRedraw(true);
        this.addListeners();
        super.softwareSystemShow(mode);
    }

    protected NamedElement getInput(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getInput' must not be null";
        return (NamedElement)softwareSystem.getUniqueExistingChild(Workspace.class);
    }

    public void softwareSystemHide(WorkbenchView.HideMode mode) {
        this.removeListeners();
        this.getTreeViewer().getControl().setRedraw(false);
        this.getTreeViewer().setInput(null);
        this.getTreeViewer().getControl().setRedraw(true);
        this.addListeners();
        this.m_moveRenameDragAndDropInfo = null;
        super.softwareSystemHide(mode);
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null) : "Parameter 'elements' of method 'finishShowInView' must not be null";
        ArrayList<Element> transformedElements = new ArrayList<Element>(elements.size());
        for (Element nextElement : elements) {
            if (nextElement instanceof LogicalProgrammingElement) {
                transformedElements.addAll(((LogicalProgrammingElement)nextElement).getProgrammingElements());
                continue;
            }
            transformedElements.add(nextElement);
        }
        super.finishShowInView(sourceViewId, transformedElements, options);
    }
}

