/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.logicalnamespacesview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.system.LogicalNamespaces;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.common.IViewContentExclusionFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

final class LogicalNamespacesViewContentAndLabelProvider
implements ITreeContentProvider,
ILabelProvider {
    private List<IViewContentExclusionFilter> m_viewContentFilters = Collections.emptyList();
    private PresentationMode m_presentationMode = PresentationMode.HIERARCHICAL;

    LogicalNamespacesViewContentAndLabelProvider() {
    }

    void setPresentationMode(PresentationMode presentationMode) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'setFlatPresentation' must not be null";
        this.m_presentationMode = presentationMode;
    }

    void setViewContentFilters(List<IViewContentExclusionFilter> filters) {
        assert (filters != null) : "Parameter 'filters' of method 'setViewContentFilters' must not be null";
        this.m_viewContentFilters = filters;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    private boolean accept(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'accept' must not be null";
        if (!this.m_viewContentFilters.isEmpty()) {
            for (IViewContentExclusionFilter nextFilter : this.m_viewContentFilters) {
                if (!nextFilter.match((Element)namedElement)) continue;
                return false;
            }
        }
        return true;
    }

    public Object[] getElements(Object parent) {
        assert (parent instanceof LogicalNamespaces) : "Not of logical namespaces class: " + String.valueOf(parent);
        List allChildren = ((LogicalNamespaces)parent).getAllChildren();
        ArrayList<NamedElement> children = new ArrayList<NamedElement>(allChildren.size());
        for (NamedElement next : allChildren) {
            if (!this.accept(next)) continue;
            children.add(next);
        }
        return children.toArray();
    }

    static boolean applyFlatPresentation(NamedElement namedElement, PresentationMode presentationMode) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'applyFlatPresentation' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'applyFlatPresentation' must not be null";
        return presentationMode == PresentationMode.FLAT && namedElement instanceof LogicalNamespace;
    }

    static final boolean applyMixedPresentation(NamedElement namedElement, PresentationMode presentationMode) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'applyMixedPresentation' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'applyMixedPresentation' must not be null";
        return presentationMode == PresentationMode.MIXED && namedElement instanceof LogicalNamespace;
    }

    private NamedElement getParent(NamedElement namedElement, PresentationMode presentationMode) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getParent' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'getParent' must not be null";
        if (LogicalNamespacesViewContentAndLabelProvider.applyFlatPresentation(namedElement, presentationMode)) {
            if (namedElement instanceof LogicalNamespace) {
                return (NamedElement)namedElement.getParent(LogicalNamespaceRoot.class, new Class[0]);
            }
        } else if (LogicalNamespacesViewContentAndLabelProvider.applyMixedPresentation(namedElement, presentationMode) && namedElement instanceof LogicalNamespace) {
            NamedElement parent = namedElement.getParent();
            while (parent != null && parent instanceof LogicalNamespace && ((LogicalNamespace)parent).isMixable()) {
                parent = parent.getParent();
            }
            return parent;
        }
        return namedElement.getParent();
    }

    public Object getParent(Object child) {
        assert (child != null && child instanceof NamedElement) : "Not an named named element: " + String.valueOf(child);
        return this.getParent((NamedElement)child, this.m_presentationMode);
    }

    private boolean hasNonPartLogicalNamespace(LogicalNamespace logicalNamespace) {
        assert (logicalNamespace != null) : "Parameter 'logicalNamespace' of method 'hasNonPartNamespaceFragment' must not be null";
        if (!logicalNamespace.isPart()) {
            return true;
        }
        List namespaceFragmentChildren = logicalNamespace.getChildren(LogicalNamespace.class);
        for (LogicalNamespace nextNamespaceFragmentChild : namespaceFragmentChildren) {
            if (!this.hasNonPartLogicalNamespace(nextNamespaceFragmentChild)) continue;
            return true;
        }
        return false;
    }

    private void processNamespaceFragment(LogicalNamespace namespaceFragment, List<NamedElement> result) {
        assert (namespaceFragment != null) : "Parameter 'namespaceFragment' of method 'processNamespaceFragment' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processNamespaceFragment' must not be null";
        if (!namespaceFragment.isPart() && this.accept((NamedElement)namespaceFragment)) {
            result.add((NamedElement)namespaceFragment);
        }
        List namespaceFragmentChildren = namespaceFragment.getChildren(LogicalNamespace.class);
        for (LogicalNamespace nextNamespaceFragmentChild : namespaceFragmentChildren) {
            this.processNamespaceFragment(nextNamespaceFragmentChild, result);
        }
    }

    public Object[] getChildren(Object parent) {
        assert (parent instanceof NamedElement) : "Not of class named element: " + String.valueOf(parent);
        List allChildren = ((NamedElement)parent).getAllChildren();
        ArrayList<NamedElement> result = new ArrayList<NamedElement>(allChildren.size());
        for (NamedElement nextChild : allChildren) {
            if (LogicalNamespacesViewContentAndLabelProvider.applyFlatPresentation(nextChild, this.m_presentationMode)) {
                assert (nextChild != null && nextChild instanceof LogicalNamespace) : "Unexpected class in method 'getChildren': " + String.valueOf(nextChild);
                if (parent instanceof LogicalNamespace) continue;
                this.processNamespaceFragment((LogicalNamespace)nextChild, result);
                continue;
            }
            if (LogicalNamespacesViewContentAndLabelProvider.applyMixedPresentation(nextChild, this.m_presentationMode)) {
                assert (nextChild != null && nextChild instanceof LogicalNamespace) : "Unexpected class in method 'getChildren': " + String.valueOf(nextChild);
                this.processForMixedMode((LogicalNamespace)nextChild, result);
                continue;
            }
            if (!this.accept(nextChild)) continue;
            result.add(nextChild);
        }
        return result.toArray();
    }

    public boolean hasChildren(Object parent) {
        assert (parent instanceof NamedElement) : "Not of class named element: " + String.valueOf(parent);
        for (NamedElement nextChild : ((NamedElement)parent).getAllChildren()) {
            if (LogicalNamespacesViewContentAndLabelProvider.applyFlatPresentation(nextChild, this.m_presentationMode)) {
                assert (nextChild != null && nextChild instanceof LogicalNamespace) : "Unexpected class in method 'hasChildren': " + String.valueOf(nextChild);
                if (!(nextChild instanceof LogicalNamespace) || parent instanceof LogicalNamespace) continue;
                return this.hasNonPartLogicalNamespace((LogicalNamespace)nextChild);
            }
            if (LogicalNamespacesViewContentAndLabelProvider.applyMixedPresentation(nextChild, this.m_presentationMode)) {
                assert (nextChild != null && nextChild instanceof LogicalNamespace) : "Unexpected class in method 'hasChildren': " + String.valueOf(nextChild);
                ArrayList<NamedElement> children = new ArrayList<NamedElement>();
                this.processForMixedMode((LogicalNamespace)nextChild, children);
                return !children.isEmpty();
            }
            if (!this.accept(nextChild)) continue;
            return true;
        }
        return false;
    }

    public String getText(Object obj) {
        assert (obj instanceof NamedElement) : "Not of class named element: " + String.valueOf(obj);
        String presentationName = null;
        if (LogicalNamespacesViewContentAndLabelProvider.applyFlatPresentation((NamedElement)obj, this.m_presentationMode)) {
            assert (obj != null && obj instanceof LogicalNamespace) : "Unexpected class in method 'getText': " + String.valueOf(obj);
            presentationName = ((NamedElement)obj).getPresentationName(false);
        } else {
            if (LogicalNamespacesViewContentAndLabelProvider.applyMixedPresentation((NamedElement)obj, this.m_presentationMode)) {
                return this.getPresentationNameForMixedMode((NamedElement)obj);
            }
            presentationName = ((NamedElement)obj).getPresentationName(this.getParent(obj) != null);
        }
        return presentationName;
    }

    public Image getImage(Object obj) {
        assert (obj instanceof NamedElement) : "Not of class named element: " + String.valueOf(obj);
        NamedElement element = (NamedElement)obj;
        return UiResourceManager.getInstance().getImage((Element)element);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    String getPresentationNameForMixedMode(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getPresentationNameForMixedMode' must not be null";
        if (namedElement instanceof LogicalNamespace) {
            NamedElement parent = this.getParent(namedElement, PresentationMode.MIXED);
            assert (parent != null) : "Parameter 'parent' of method 'getTextForNode' must not be null";
            String textForNode = namedElement.getPresentationName(false);
            if (parent instanceof LogicalNamespace) {
                String textToCut = parent.getPresentationName(false);
                textForNode = textForNode.substring(textToCut.length());
            }
            if (textForNode.startsWith("::")) {
                textForNode = textForNode.substring(2);
            }
            if (textForNode.endsWith(".")) {
                textForNode = textForNode.substring(0, textForNode.length() - 1);
            }
            if (!textForNode.startsWith("./") && textForNode.startsWith(".")) {
                textForNode = textForNode.substring(1);
            }
            return textForNode;
        }
        return namedElement.getPresentationName(true);
    }

    private void processForMixedMode(LogicalNamespace logicalNamespace, List<NamedElement> result) {
        assert (logicalNamespace != null) : "Parameter 'logicalNamespace' of method 'processForMixedMode' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processForMixedMode' must not be null";
        if (logicalNamespace.isMixable()) {
            List children = logicalNamespace.getChildren();
            assert (children.size() == 1) : "Only 1 children expected but was: " + children.size();
            this.processForMixedMode((LogicalNamespace)children.get(0), result);
        } else {
            result.add((NamedElement)logicalNamespace);
        }
    }
}

