/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.issuesview;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.IIssueFilter;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IssueList;
import com.hello2morrow.sonargraph.core.model.programming.IssueAffectedElementType;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.FilterCriterionIssueCounter;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.UsedIssueInfo;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.SimpleCheckBoxTreeViewer;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.UiTreeNode;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.issuesview.IssuesFilterContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.issuesview.IssuesViewTreeNode;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

final class IssuesFilterDialog
extends StandardDialog
implements SimpleCheckBoxTreeViewer.IStateChangedListener<IssuesViewTreeNode> {
    private static final String SHOW_ONLY_APPLICABLE_FILTERS = "SHOW_ONLY_APPLICABLE_FILTERS";
    private final IssueFilter m_newFilter;
    private final ISoftwareSystemProvider m_softwareSystemProvider;
    private IssuesFilterContentAndLabelProvider m_contentAndLabelProvider;
    private SimpleCheckBoxTreeViewer<IssuesViewTreeNode> m_filtersCheckboxTreeViewer;
    private Button m_showOnlyApplicableFiltersCheckBox;
    private Button m_selectAll;
    private Button m_deselectAll;
    private UsedIssueInfo m_usedIssueInfo;
    private ICheckStateProvider m_checkStateProvider;

    static Collection<Severity> getSeveritiesForFilter() {
        return Arrays.asList(Severity.values());
    }

    static Collection<IssueCategory> getCategoriesForFilter() {
        return Arrays.asList(IssueCategory.values()).stream().filter(issueCategory -> !issueCategory.isGenerated()).collect(Collectors.toList());
    }

    static Collection<IProviderId> getProviderIdsForFilter(ISoftwareSystemProvider softwareSystemProvider) {
        assert (softwareSystemProvider != null) : "Parameter 'softwareSystemProvider' of method 'getProviderIdsForFilter' must not be null";
        return softwareSystemProvider.getInstallation().getAvailableIssueProviderIds();
    }

    static Collection<IIssueId> getIssueIdsForFilter(ISoftwareSystemProvider softwareSystemProvider) {
        assert (softwareSystemProvider != null) : "Parameter 'softwareSystemProvider' of method 'getIssueIdsForFilter' must not be null";
        return softwareSystemProvider.getInstallation().getAvailableIssueIds().stream().filter(issueId -> !issueId.getCategory().isGenerated()).collect(Collectors.toList());
    }

    static Collection<IssueAffectedElementType> getAffectedElementTypesForFilter() {
        return Arrays.asList(IssueAffectedElementType.values());
    }

    public IssuesFilterDialog(Shell parentShell, String title, IssueFilter newFilter, ISoftwareSystemProvider softwareSystemProvider) {
        super(parentShell, title);
        assert (parentShell != null) : "Parameter 'parentShell' of method 'IssuesFilterDialog' must not be null";
        assert (title != null) : "Parameter 'title' of method 'IssuesFilterDialog' must not be null";
        assert (softwareSystemProvider != null) : "Parameter 'softwareSystemProvider' of method 'IssuesFilterDialog' must not be null";
        this.m_newFilter = newFilter;
        this.m_softwareSystemProvider = softwareSystemProvider;
    }

    private Collection<FilterCriterionIssueCounter<? extends IStandardEnumeration>> getFilterItemsForUI(Collection<? extends IStandardEnumeration> allItems) {
        assert (allItems != null) : "Parameter 'allItems' of method 'getFilterItemsForUI' must not be null";
        ArrayList<FilterCriterionIssueCounter<? extends IStandardEnumeration>> result = new ArrayList<FilterCriterionIssueCounter<? extends IStandardEnumeration>>();
        for (IStandardEnumeration iStandardEnumeration : allItems) {
            FilterCriterionIssueCounter filterCriterion = this.m_usedIssueInfo.getCriterion(iStandardEnumeration);
            if (filterCriterion != null) {
                result.add((FilterCriterionIssueCounter<? extends IStandardEnumeration>)filterCriterion);
                continue;
            }
            if (this.m_showOnlyApplicableFiltersCheckBox.getSelection()) continue;
            result.add((FilterCriterionIssueCounter<? extends IStandardEnumeration>)new FilterCriterionIssueCounter(iStandardEnumeration));
        }
        return result;
    }

    private List<IssuesViewTreeNode> createIssuesFilterTree() {
        ArrayList<IssuesViewTreeNode> collector = new ArrayList<IssuesViewTreeNode>();
        this.addElementsToTree(this.getFilterItemsForUI(IssuesFilterDialog.getSeveritiesForFilter()), collector, Topic.SEVERITY);
        this.addElementsToTree(this.getFilterItemsForUI(IssuesFilterDialog.getCategoriesForFilter()), collector, Topic.CATEGORY);
        this.addElementsToTree(this.getFilterItemsForUI(IssuesFilterDialog.getProviderIdsForFilter(this.m_softwareSystemProvider)), collector, Topic.ISSUE_PROVIDER);
        this.addElementsToTree(this.getFilterItemsForUI(IssuesFilterDialog.getIssueIdsForFilter(this.m_softwareSystemProvider)), collector, Topic.ISSUE_ID);
        this.addElementsToTree(this.getFilterItemsForUI(IssuesFilterDialog.getAffectedElementTypesForFilter()), collector, Topic.AFFECTED_ELEMENT_TYPE);
        return collector;
    }

    private void addElementsToTree(Collection<FilterCriterionIssueCounter<? extends IStandardEnumeration>> criteria, List<IssuesViewTreeNode> collector, Topic parentTopic) {
        assert (criteria != null) : "Parameter 'criteria' of method 'addElementsToTree' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'addElementsToTree' must not be null";
        assert (parentTopic != null) : "Parameter 'parentTopic' of method 'addElementsToTree' must not be null";
        IssuesViewTreeNode parentNode = new IssuesViewTreeNode(parentTopic);
        parentNode.setChecked(this.m_checkStateProvider.isChecked((Object)parentNode));
        for (FilterCriterionIssueCounter<? extends IStandardEnumeration> next : criteria) {
            IssuesViewTreeNode node = new IssuesViewTreeNode(next.getCriterion(), next.getIssueCount());
            node.setChecked(this.m_checkStateProvider.isChecked((Object)node));
            parentNode.addChild(node);
        }
        if (!parentNode.getChildren().isEmpty()) {
            collector.add(parentNode);
        }
    }

    public boolean hasValidData() {
        return true;
    }

    protected int getNumberOfColumns() {
        return 3;
    }

    protected Point getPreferredSize() {
        return new Point(420, 600);
    }

    protected Point getMinimumSize() {
        return new Point(400, 600);
    }

    @Override
    public void handleStateChanged(IssuesViewTreeNode element) {
        assert (element != null) : "Parameter 'element' of method 'handleStateChanged' must not be null";
        if (!this.getButton(0).isEnabled()) {
            this.getButton(0).setEnabled(true);
        }
        if (element.getModel() instanceof Topic) {
            return;
        }
        if (element.isChecked()) {
            this.m_newFilter.add(element.getModel());
        } else {
            this.m_newFilter.remove(element.getModel());
        }
    }

    @Override
    public void handleAllStatesChanged() {
        if (!this.getButton(0).isEnabled()) {
            this.getButton(0).setEnabled(true);
        }
        for (UiTreeNode uiTreeNode : this.m_filtersCheckboxTreeViewer.getInput()) {
            for (UiTreeNode child : uiTreeNode.getChildrenRecursively()) {
                IStandardEnumeration model = ((IssuesViewTreeNode)child).getModel();
                if (child.isChecked()) {
                    this.m_newFilter.add(model);
                    continue;
                }
                this.m_newFilter.remove(model);
            }
        }
    }

    void show() {
        this.m_filtersCheckboxTreeViewer.getTree().setRedraw(false);
        this.m_usedIssueInfo = this.m_softwareSystemProvider.getInstallation().getCurrentModel().getUsedIssueInfo();
        if (this.m_softwareSystemProvider.hasSoftwareSystem()) {
            this.m_usedIssueInfo.add(this.m_softwareSystemProvider.getSoftwareSystem().getCurrentModel().getUsedIssueInfo());
        }
        List<IssuesViewTreeNode> issuesFilterTree = this.createIssuesFilterTree();
        this.m_filtersCheckboxTreeViewer.setInput(issuesFilterTree);
        this.m_filtersCheckboxTreeViewer.setExpandedElements(this.m_contentAndLabelProvider.getElements(issuesFilterTree));
        this.m_filtersCheckboxTreeViewer.getTree().setRedraw(true);
    }

    protected void fillDialogArea(Composite composite) {
        super.fillDialogArea(composite);
        this.m_checkStateProvider = new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                IssuesViewTreeNode filterNode = (IssuesViewTreeNode)((Object)element);
                IStandardEnumeration model = filterNode.getModel();
                if (model instanceof Topic) {
                    return this.grayOrUngreyParent(filterNode);
                }
                return false;
            }

            public boolean isChecked(Object element) {
                if (!$assertionsDisabled && !(element instanceof IssuesViewTreeNode)) {
                    throw new AssertionError((Object)("Unexpected class " + element.getClass().getName()));
                }
                IssuesViewTreeNode filterNode = (IssuesViewTreeNode)((Object)element);
                IStandardEnumeration model = filterNode.getModel();
                if (model instanceof Topic) {
                    return this.checkOrUncheckParent(filterNode);
                }
                return IssuesFilterDialog.this.m_newFilter.containsFilter(model);
            }

            private boolean checkOrUncheckParent(IssuesViewTreeNode parent) {
                if (!$assertionsDisabled && parent == null) {
                    throw new AssertionError((Object)"Parameter 'parent' of method 'checkOrUncheckParent' must not be null");
                }
                IStandardEnumeration model = parent.getModel();
                if (!$assertionsDisabled && !(model instanceof Topic)) {
                    throw new AssertionError((Object)("Unexpected class " + model.getClass().getName()));
                }
                Topic topic = (Topic)model;
                return IssuesFilterDialog.this.m_newFilter.getNumberOfFilters(topic.getFilterClass(), filter -> IssuesFilterDialog.this.m_showOnlyApplicableFiltersCheckBox.getSelection() ? IssuesFilterDialog.this.m_usedIssueInfo.contains(filter) : true) != 0;
            }

            private boolean grayOrUngreyParent(IssuesViewTreeNode parent) {
                if (!$assertionsDisabled && parent == null) {
                    throw new AssertionError((Object)"Parameter 'parent' of method 'grayOrUngreyParent' must not be null");
                }
                if (!$assertionsDisabled && IssuesFilterDialog.this.m_softwareSystemProvider == null) {
                    throw new AssertionError((Object)"'m_softwareSystemControler' of method 'checkOrUncheckParent' must not be null");
                }
                IStandardEnumeration model = parent.getModel();
                if (!$assertionsDisabled && !(model instanceof Topic)) {
                    throw new AssertionError((Object)("Unexpected class " + model.getClass().getName()));
                }
                Topic topic = (Topic)model;
                boolean containsAnyCheckedFilters = IssuesFilterDialog.this.m_newFilter.getNumberOfFilters(topic.getFilterClass(), filter -> IssuesFilterDialog.this.m_usedIssueInfo.contains(filter)) > 0;
                boolean doesNotContainAllFilters = IssuesFilterDialog.this.m_newFilter.getNumberOfFilters(topic.getFilterClass(), filter -> IssuesFilterDialog.this.m_showOnlyApplicableFiltersCheckBox.getSelection() ? IssuesFilterDialog.this.m_usedIssueInfo.contains(filter) : true) < parent.getChildren().size();
                boolean grayed = containsAnyCheckedFilters && doesNotContainAllFilters;
                return grayed;
            }
        };
        this.m_filtersCheckboxTreeViewer = new SimpleCheckBoxTreeViewer(composite, this.m_checkStateProvider);
        GridData gridData = new GridData(4, 4, true, true, 3, 5);
        this.m_filtersCheckboxTreeViewer.getTree().setLayoutData((Object)gridData);
        this.m_contentAndLabelProvider = new IssuesFilterContentAndLabelProvider();
        this.m_filtersCheckboxTreeViewer.setContentProvider((IContentProvider)this.m_contentAndLabelProvider);
        this.m_filtersCheckboxTreeViewer.setLabelProvider((IBaseLabelProvider)this.m_contentAndLabelProvider);
        this.m_filtersCheckboxTreeViewer.setStateChangedListener(this);
        this.m_showOnlyApplicableFiltersCheckBox = new Button(composite, 32);
        this.m_showOnlyApplicableFiltersCheckBox.setText("Show only applicable filters");
        this.m_showOnlyApplicableFiltersCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IssuesFilterDialog.this.show();
                if (!IssuesFilterDialog.this.getButton(0).isEnabled()) {
                    IssuesFilterDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this.m_showOnlyApplicableFiltersCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        IssueFilter blankFilter = new IssueFilter(new IStandardEnumeration[0]);
        IssueList installationIssueList = this.m_softwareSystemProvider.getInstallation().getCurrentModel().getIssueList((IIssueFilter)blankFilter);
        ArrayList allIssues = new ArrayList(installationIssueList.getIssues());
        if (this.m_softwareSystemProvider.hasSoftwareSystem()) {
            IssueList issueList = this.m_softwareSystemProvider.getSoftwareSystem().getCurrentModel().getIssueList((IIssueFilter)blankFilter);
            allIssues.addAll(issueList.getIssues());
        }
        this.m_filtersCheckboxTreeViewer.setComparator(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        this.m_deselectAll = new Button(composite, 8);
        this.m_deselectAll.setText("Deselect All");
        this.m_deselectAll.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.m_deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IssuesFilterDialog.this.m_filtersCheckboxTreeViewer.setAllChecked(false);
                if (!IssuesFilterDialog.this.getButton(0).isEnabled()) {
                    IssuesFilterDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this.m_selectAll = new Button(composite, 8);
        this.m_selectAll.setText("Select All");
        this.m_selectAll.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.m_selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IssuesFilterDialog.this.m_filtersCheckboxTreeViewer.setAllChecked(true);
                if (!IssuesFilterDialog.this.getButton(0).isEnabled()) {
                    IssuesFilterDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this.show();
    }

    protected void applyData() {
        IEclipsePreferences preferences = this.getPreferences("com.hello2morrow.sonargraph.standalone");
        this.m_showOnlyApplicableFiltersCheckBox.setSelection(preferences.getBoolean(SHOW_ONLY_APPLICABLE_FILTERS, true));
        List<IssuesViewTreeNode> issuesFilterTree = this.createIssuesFilterTree();
        this.m_filtersCheckboxTreeViewer.setInput(issuesFilterTree);
        this.m_filtersCheckboxTreeViewer.setExpandedElements(this.m_contentAndLabelProvider.getElements(issuesFilterTree));
    }

    protected IEclipsePreferences saveData() {
        IEclipsePreferences preferences = this.getPreferences("com.hello2morrow.sonargraph.standalone");
        preferences.putBoolean(SHOW_ONLY_APPLICABLE_FILTERS, this.m_showOnlyApplicableFiltersCheckBox.getSelection());
        return preferences;
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.ISSUES_FILTER_DIALOG;
    }

    public IssueFilter getNewIssueFilter() {
        return this.m_newFilter;
    }

    static /* synthetic */ Button access$1(IssuesFilterDialog issuesFilterDialog) {
        return issuesFilterDialog.m_showOnlyApplicableFiltersCheckBox;
    }

    static /* synthetic */ UsedIssueInfo access$2(IssuesFilterDialog issuesFilterDialog) {
        return issuesFilterDialog.m_usedIssueInfo;
    }

    public static final class Topic
    extends Enum<Topic>
    implements IStandardEnumeration {
        public static final /* enum */ Topic SEVERITY = new Topic(IssueFilter.ISSUE_SEVERITY);
        public static final /* enum */ Topic CATEGORY = new Topic(IssueFilter.ISSUE_CATEGORY);
        public static final /* enum */ Topic ISSUE_PROVIDER = new Topic(IssueFilter.ISSUE_PROVIDER);
        public static final /* enum */ Topic ISSUE_ID = new Topic(IssueFilter.ISSUE_ID);
        public static final /* enum */ Topic AFFECTED_ELEMENT_TYPE = new Topic(IssueFilter.ISSUE_TYPE);
        private Class<? extends IStandardEnumeration> m_filterClass;
        private String m_presentationName;
        private static final /* synthetic */ Topic[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Topic[]{SEVERITY, CATEGORY, ISSUE_PROVIDER, ISSUE_ID, AFFECTED_ELEMENT_TYPE};
        }

        private Topic(Class<? extends IStandardEnumeration> filterClass, String presentationName) {
            assert (filterClass != null) : "Parameter 'filterClass' of method 'Topic' must not be null";
            this.m_filterClass = filterClass;
            this.m_presentationName = presentationName;
        }

        private Topic(Class<? extends IStandardEnumeration> filterClass) {
            this(filterClass, null);
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return this.m_presentationName == null ? StringUtility.convertConstantNameToPresentationName((String)this.name()) : this.m_presentationName;
        }

        public Class<? extends IStandardEnumeration> getFilterClass() {
            return this.m_filterClass;
        }

        public static Topic[] values() {
            Topic[] topicArray = ENUM$VALUES;
            int n = topicArray.length;
            Topic[] topicArray2 = new Topic[n];
            System.arraycopy(ENUM$VALUES, 0, topicArray2, 0, n);
            return topicArray2;
        }

        public static Topic valueOf(String string) {
            return Enum.valueOf(Topic.class, string);
        }
    }
}

