/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.help;

import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpContext;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.Collections;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class HelpControl
extends Composite {
    private final Object m_context;
    private final StyledText m_content;
    private Point m_size;

    private static void showHelp(StyledText content, Object context) {
        assert (context != null) : "Parameter 'context' of method 'showHelp' must not be null";
        if (content != null && !content.isDisposed()) {
            HelpContext helpContext = HelpRegistry.getInstance().getContext(context);
            if (helpContext == null && context instanceof String) {
                helpContext = HelpRegistry.getInstance().getContext((String)context);
            }
            if (helpContext == null) {
                helpContext = HelpRegistry.getInstance().getDefaultHelpContext();
            }
            HelpRegistry.getInstance().setContextHelpText(Collections.singletonList(helpContext), content);
        }
    }

    public HelpControl(Composite parent, Object context) {
        super(parent, 0);
        assert (context != null) : "Parameter 'context' of method 'HelpControl' must not be null";
        this.setLayout((Layout)new FillLayout());
        this.m_context = context;
        this.m_content = new StyledText((Composite)this, 72);
        this.m_content.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        HelpControl.showHelp(this.m_content, this.m_context);
    }

    void showHelp(Object context) {
        assert (context != null) : "Parameter 'context' of method 'showHelp' must not be null";
        HelpControl.showHelp(this.m_content, context);
    }

    public void setSize(int width, int height) {
        this.m_size = new Point(width, height);
        super.setSize(width, height);
    }

    public void setSize(Point size) {
        assert (size != null) : "Parameter 'size' of method 'setSize' must not be null";
        this.m_size = size;
    }

    public Point computeSize(int wHint, int hHint) {
        if (this.m_size != null) {
            return this.m_size;
        }
        return super.computeSize(wHint, hHint);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.m_size != null && !changed) {
            return this.m_size;
        }
        return super.computeSize(wHint, hHint, changed);
    }
}

