/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.filesview;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.dashboard.Dashboard;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.ModifiableDirectoryPathCreatedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableDirectoryPathDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableDirectoryPathModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileCreatedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.plugin.IPluginProvider;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.script.ScriptDirectory;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ParserModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.system.settings.SoftwareSystemSettingsFile;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.ConfigurationDialogHelper;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.IAnalyzerPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.PluginPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.PreferencePageRegistry;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.NamedElementViewComparator;
import com.hello2morrow.sonargraph.ui.standalone.filesview.FilesViewContentProvider;
import com.hello2morrow.sonargraph.ui.standalone.filesview.FilesViewLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.workspaceprofile.WorkspaceProfileWizard;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchMasterView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Shell;

public final class FilesView
extends WorkbenchMasterView {
    public IViewId getViewId() {
        return ViewId.FILES_VIEW;
    }

    protected void configureTreeViewer(TreeViewer treeViewer) {
        assert (treeViewer != null) : "Parameter 'treeViewer' of method 'configureTreeViewer' must not be null";
        treeViewer.setContentProvider((IContentProvider)new FilesViewContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new FilesViewLabelProvider()));
        CategoryProvider categoryProvider = new CategoryProvider();
        categoryProvider.setCategory(SoftwareSystemFile.class, -1);
        categoryProvider.setCategory(ScriptDirectory.class, -1);
        categoryProvider.setCategory(ParserModel.class, -1);
        treeViewer.setComparator((ViewerComparator)new NamedElementViewComparator(categoryProvider));
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileCreatedEvent>(ModifiableFileCreatedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileCreatedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                FilesView.this.handleModifiableFileEvent((SoftwareSystemProviderEvent)event);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<MultipleModifiableFileModifiedEvent>(MultipleModifiableFileModifiedEvent.class, (Object)this){

            public void handleEvent(MultipleModifiableFileModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                FilesView.this.handleModifiableFileEvent((SoftwareSystemProviderEvent)event);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileDeletedEvent>(ModifiableFileDeletedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileDeletedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                FilesView.this.handleModifiableFileEvent((SoftwareSystemProviderEvent)event);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableDirectoryPathCreatedEvent>(ModifiableDirectoryPathCreatedEvent.class, (Object)this){

            public void handleEvent(ModifiableDirectoryPathCreatedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                FilesView.this.handleModifiableFileEvent((SoftwareSystemProviderEvent)event);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableDirectoryPathModifiedEvent>(ModifiableDirectoryPathModifiedEvent.class, (Object)this){

            public void handleEvent(ModifiableDirectoryPathModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                FilesView.this.handleModifiableFileEvent((SoftwareSystemProviderEvent)event);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableDirectoryPathDeletedEvent>(ModifiableDirectoryPathDeletedEvent.class, (Object)this){

            public void handleEvent(ModifiableDirectoryPathDeletedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                FilesView.this.handleModifiableFileEvent((SoftwareSystemProviderEvent)event);
            }
        });
    }

    private void handleModifiableFileEvent(SoftwareSystemProviderEvent event) {
        assert (event != null) : "Parameter 'event' of method 'handleModifiableFileEvent' must not be null";
        if (this.canHandleEvent(event)) {
            this.removeListeners();
            this.getTreeViewer().getTree().setRedraw(false);
            this.getTreeViewer().refresh();
            this.getTreeViewer().getTree().setRedraw(true);
            this.addListeners();
        }
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(ModifiableFileCreatedEvent.class, (Object)this);
        EventManager.getInstance().detach(MultipleModifiableFileModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableFileDeletedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableDirectoryPathCreatedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableDirectoryPathModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableDirectoryPathDeletedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    public void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.removeListeners();
        this.getTreeViewer().getControl().setRedraw(false);
        this.getTreeViewer().setInput(this.getSoftwareSystem().getUniqueChild(Files.class));
        this.getTreeViewer().getControl().setRedraw(true);
        this.addListeners();
        super.softwareSystemShow(mode);
    }

    public boolean doubleClicked(Element element) {
        assert (element != null) : "Parameter 'element' of method 'doubleClicked' must not be null";
        if (element instanceof AnalyzerConfigurationFile) {
            SoftwareSystem system = this.getSoftwareSystem();
            if (system != null) {
                IPreferenceNode[] rootNodes;
                PreferenceManager preferenceManager = PreferencePageRegistry.getInstance().getSoftwareSystemPreferenceManager(system.getUsedLanguages(), ((IPluginProvider)this.getInstallation().getExtension(IPluginProvider.class)).getPlugins());
                IAnalyzerId analyzerId = ((AnalyzerConfigurationFile)element).getAnalyzerId();
                String pageId = null;
                IPreferenceNode[] iPreferenceNodeArray = rootNodes = preferenceManager.getRootSubNodes();
                int n = rootNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnalyzerPreferencePage nextAnalyzerPreferencePage;
                    IPreferenceNode nextNode = iPreferenceNodeArray[n2];
                    IPreferencePage nextPage = nextNode.getPage();
                    if (nextPage instanceof IAnalyzerPreferencePage && analyzerId.equals((nextAnalyzerPreferencePage = (IAnalyzerPreferencePage)nextPage).getAnalyzerId())) {
                        pageId = nextAnalyzerPreferencePage.getId();
                        break;
                    }
                    ++n2;
                }
                if (pageId != null) {
                    ConfigurationDialogHelper.openPreferencePage(preferenceManager, pageId);
                    return true;
                }
            }
        } else if (element instanceof PluginConfigurationFile) {
            SoftwareSystem system = this.getSoftwareSystem();
            if (system != null) {
                IPreferenceNode[] rootNodes;
                PreferenceManager preferenceManager = PreferencePageRegistry.getInstance().getSoftwareSystemPreferenceManager(system.getUsedLanguages(), ((IPluginProvider)this.getInstallation().getExtension(IPluginProvider.class)).getPlugins());
                String pluginId = ((PluginConfigurationFile)element).getPluginId();
                String pageId = null;
                IPreferenceNode[] iPreferenceNodeArray = rootNodes = preferenceManager.getRootSubNodes();
                int n = rootNodes.length;
                int n3 = 0;
                while (n3 < n) {
                    PluginPreferencePage nextPluginPreferencePage;
                    String nextPluginId;
                    IPreferenceNode nextNode = iPreferenceNodeArray[n3];
                    IPreferencePage nextPage = nextNode.getPage();
                    if (nextPage instanceof PluginPreferencePage && pluginId.equals(nextPluginId = (nextPluginPreferencePage = (PluginPreferencePage)nextPage).getPluginId())) {
                        pageId = nextPluginPreferencePage.getId();
                        break;
                    }
                    ++n3;
                }
                if (pageId != null) {
                    ConfigurationDialogHelper.openPreferencePage(preferenceManager, pageId);
                    return true;
                }
            }
        } else if (element instanceof SoftwareSystemSettingsFile) {
            SoftwareSystem system = this.getSoftwareSystem();
            if (system != null) {
                PreferenceManager preferenceManager = PreferencePageRegistry.getInstance().getSoftwareSystemPreferenceManager(system.getUsedLanguages(), ((IPluginProvider)this.getInstallation().getExtension(IPluginProvider.class)).getPlugins());
                String pageId = "com.hello2morrow.sonargraph.standalone." + ((SoftwareSystemSettingsFile)element).getLanguage().getStandardName().toLowerCase() + ".systemSettings";
                ConfigurationDialogHelper.openPreferencePage(preferenceManager, pageId);
                return true;
            }
        } else if (element instanceof SoftwareSystemFile || element instanceof Dashboard) {
            MPart part = (MPart)RcpUtility.findUniqueModelElement((IEclipseContext)this.getEclipseContext(), null, (String)ViewId.SOFTWARE_SYSTEM_VIEW.getId(), MPart.class);
            assert (part != null) : "Parameter 'part' of method 'execute' must not be null";
            if (!part.isVisible()) {
                part.setVisible(true);
            }
            this.getPartService().showPart(ViewId.SOFTWARE_SYSTEM_VIEW.getId(), EPartService.PartState.ACTIVATE);
            IWorkbenchView view = RcpUtility.getWorkbenchView((MPart)part, IWorkbenchView.class);
            if (view != null) {
                WorkbenchRegistry.getInstance().selectView(view);
                return true;
            }
        } else if (element instanceof WorkspaceProfile && CommandRegistry.getInstance().isCommandLicensed((ICommandId)CoreCommandId.MODIFY_WORKSPACE_PROFILE_PATTERN_BASED)) {
            SonargraphWizardAdapter.createWizardDialog((Shell)WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), (SonargraphWizard)new WorkspaceProfileWizard((WorkspaceProfile)element)).open();
            return true;
        }
        return false;
    }

    protected NamedElement getInput(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getInput' must not be null";
        return (NamedElement)softwareSystem.getUniqueChild(Files.class);
    }

    protected boolean restoreNavigationStateOnSoftwareSystemModified() {
        return false;
    }

    public void softwareSystemHide(WorkbenchView.HideMode mode) {
        this.removeListeners();
        this.getTreeViewer().setInput(null);
        this.addListeners();
        super.softwareSystemHide(mode);
    }
}

