/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.filesview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.DeleteWorkspaceProfileCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import java.util.List;

public final class DeleteWorkspaceProfileCommandAdapter
extends CompositeCommandAdapter {
    public CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.DELETE;
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.DELETE_WORKSPACE_PROFILE;
    }

    public CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        if (!elements.isEmpty()) {
            for (Element nextElement : elements) {
                if (nextElement instanceof WorkspaceProfile) continue;
                return null;
            }
            WorkspaceProfile profile = (WorkspaceProfile)elements.get(0);
            if (elements.size() == 1) {
                return new CompositeCommandAdapter.Applicable(profile.getPresentationKind() + " [" + profile.getIdentifyingPath() + "]", profile.getPresentationKind());
            }
            return new CompositeCommandAdapter.Applicable(profile.getPresentationKind() + "s");
        }
        return null;
    }

    public void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'apply' must not be null";
        final List profiles = CommandHandler.getMultipleSelection(WorkspaceProfile.class, elements);
        DeleteWorkspaceProfileCommand.IDeleteInteraction interaction = new DeleteWorkspaceProfileCommand.IDeleteInteraction(){

            public boolean collect(DeleteWorkspaceProfileCommand.DeleteData data) {
                for (WorkspaceProfile next : profiles) {
                    data.addProfile(next);
                }
                return true;
            }

            public void processDeleteResult(OperationResult result) {
                UserInterfaceAdapter.getInstance().process(result);
            }

            public boolean confirmDeletion(String info) {
                if (!($assertionsDisabled || info != null && info.length() > 0)) {
                    throw new AssertionError((Object)"Parameter 'info' of method 'confirmDeletion' must not be empty");
                }
                return UserInterfaceAdapter.getInstance().question(info, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
            }
        };
        DeleteWorkspaceProfileCommand cmd = new DeleteWorkspaceProfileCommand(provider, interaction);
        UserInterfaceAdapter.getInstance().run((Command)cmd);
    }
}

