/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.duplicateview;

import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.ISingleIssueProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.programming.ConditionFilter;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.duplicateview.DuplicateBlocksViewContentProvider;
import com.hello2morrow.sonargraph.ui.swt.base.TreeContentProviderWithFilter;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.SingleIssueProviderComparator;
import com.hello2morrow.sonargraph.ui.swt.base.view.TreeBasedViewNavigationStateUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.TreeBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.TreeViewerBasedView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public final class DuplicateCodeBlocksView
extends TreeViewerBasedView {
    private static final String FIRST_COLUMN = "Duplicate Code Block";
    private static final String FILTER_HANDLED_ITEM_ID = "com.hello2morrow.sonargraph.standalone.handledmenuitem.filter";
    private static final Predicate<DuplicateCodeBlock> IGNORED_FILTER = duplicateCodeBlock -> duplicateCodeBlock.getAssociatedIssue().getResolution() instanceof IgnoreDefinition;
    private static final Predicate<DuplicateCodeBlock> NOT_IGNORED_FILTER = duplicateCodeBlock -> !(duplicateCodeBlock.getAssociatedIssue().getResolution() instanceof IgnoreDefinition);
    private AnalyzerResult m_analyzerResult;
    private TreeViewer m_treeViewer;
    private TreeViewerColumn m_treeViewerFirstColumn;
    private TreeBasedTextSearchHandler m_textSearchHandler;
    private TreeContentProviderWithFilter<DuplicateCodeBlock> m_contentProvider;

    public IViewId getViewId() {
        return ViewId.DUPLICATE_CODE_BLOCKS_VIEW;
    }

    protected TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchHandler;
    }

    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    public void createViewContent(Composite viewContentArea) {
        this.m_treeViewer = new TreeViewer(viewContentArea, 66306);
        ConditionFilter filter = new ConditionFilter();
        filter.add(IGNORED_FILTER);
        filter.add(NOT_IGNORED_FILTER);
        this.m_contentProvider = new DuplicateBlocksViewContentProvider((ConditionFilter<DuplicateCodeBlock>)filter);
        this.m_treeViewer.setContentProvider(this.m_contentProvider);
        this.m_textSearchHandler = new TreeBasedTextSearchHandler(this.m_treeViewer, this.getViewId().getPresentationName());
        this.m_treeViewerFirstColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        this.m_treeViewerFirstColumn.getColumn().setWidth(350);
        this.m_treeViewerFirstColumn.getColumn().setText(FIRST_COLUMN);
        this.m_treeViewerFirstColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                String text = null;
                if (obj instanceof DuplicateCodeBlock) {
                    text = ((DuplicateCodeBlock)obj).getName();
                } else if (obj instanceof DuplicateCodeBlockOccurrence) {
                    text = ((DuplicateCodeBlockOccurrence)obj).getSourceFile().getPresentationName(true);
                }
                return text;
            }

            public Image getImage(Object obj) {
                Image image = null;
                if (obj instanceof DuplicateCodeBlockOccurrence) {
                    image = UiResourceManager.getInstance().getImage((Element)((DuplicateCodeBlockOccurrence)obj).getSourceFile());
                } else if (obj instanceof NamedElement) {
                    image = UiResourceManager.getInstance().getImage((Element)((NamedElement)obj));
                } else if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unhandled class: " + obj.getClass().getName()));
                }
                return image;
            }

            public String getToolTipText(Object obj) {
                if (obj instanceof DuplicateCodeBlockOccurrence) {
                    return ((DuplicateCodeBlockOccurrence)obj).getName();
                }
                return super.getToolTipText(obj);
            }
        });
        TreeViewerColumn treeViewerColumnOccurrences = new TreeViewerColumn(this.m_treeViewer, 131072);
        treeViewerColumnOccurrences.getColumn().setWidth(80);
        treeViewerColumnOccurrences.getColumn().setText("Occurrences");
        treeViewerColumnOccurrences.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                String text = null;
                if (obj instanceof DuplicateCodeBlock) {
                    text = Integer.toString(((DuplicateCodeBlock)obj).getTotalNumberOfOccurrences());
                }
                return text;
            }
        });
        TreeViewerColumn treeViewerColumnLineRange = new TreeViewerColumn(this.m_treeViewer, 131072);
        treeViewerColumnLineRange.getColumn().setWidth(80);
        treeViewerColumnLineRange.getColumn().setText("Line Range");
        treeViewerColumnLineRange.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                String text = null;
                if (obj instanceof DuplicateCodeBlockOccurrence) {
                    text = ((DuplicateCodeBlockOccurrence)obj).getLineRange();
                }
                return text;
            }
        });
        TreeViewerColumn treeViewerColumnBlockLength = new TreeViewerColumn(this.m_treeViewer, 131072);
        treeViewerColumnBlockLength.getColumn().setWidth(120);
        treeViewerColumnBlockLength.getColumn().setText("Block Length (Lines)");
        treeViewerColumnBlockLength.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                String text = null;
                if (obj instanceof DuplicateCodeBlock) {
                    text = NumberUtility.format((Number)((DuplicateCodeBlock)obj).getBlockSize());
                } else if (obj instanceof DuplicateCodeBlockOccurrence) {
                    text = NumberUtility.format((Number)((DuplicateCodeBlockOccurrence)obj).getBlockSize());
                }
                return text;
            }
        });
        TreeViewerColumn treeViewerColumnBlockLengthLogical = new TreeViewerColumn(this.m_treeViewer, 131072);
        treeViewerColumnBlockLengthLogical.getColumn().setWidth(220);
        treeViewerColumnBlockLengthLogical.getColumn().setText("Block Length (Lines without Ignored)");
        treeViewerColumnBlockLengthLogical.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                String text = null;
                if (obj instanceof DuplicateCodeBlock) {
                    text = NumberUtility.format((Number)((DuplicateCodeBlock)obj).getBlockSizeWithoutIgnored());
                } else if (obj instanceof DuplicateCodeBlockOccurrence) {
                    text = NumberUtility.format((Number)((DuplicateCodeBlockOccurrence)obj).getBlockSizeWithoutIgnored());
                }
                return text;
            }
        });
        TreeViewerColumn treeViewerColumnTolerance = new TreeViewerColumn(this.m_treeViewer, 131072);
        treeViewerColumnTolerance.getColumn().setWidth(120);
        treeViewerColumnTolerance.getColumn().setText("Tolerance (Lines)");
        treeViewerColumnTolerance.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                String text = null;
                if (obj instanceof DuplicateCodeBlockOccurrence) {
                    text = ((DuplicateCodeBlockOccurrence)obj).getTolerance();
                }
                return text;
            }
        });
        TreeViewerColumn treeViewerColumnResolution = new TreeViewerColumn(this.m_treeViewer, 0);
        treeViewerColumnResolution.getColumn().setWidth(140);
        treeViewerColumnResolution.getColumn().setText("Resolution");
        treeViewerColumnResolution.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                String text = null;
                if (obj instanceof DuplicateCodeBlock) {
                    DuplicateCodeBlock cycleGroup = (DuplicateCodeBlock)obj;
                    Issue associatedIssue = cycleGroup.getAssociatedIssue();
                    if (associatedIssue != null) {
                        StringBuilder resolutionText = new StringBuilder();
                        if (associatedIssue.getResolution() != null) {
                            Resolution resolution = (Resolution)associatedIssue.getResolution();
                            if (resolution.ignores()) {
                                resolutionText.append("Ignored");
                            } else {
                                resolutionText.append("Task");
                                resolutionText.append(" ");
                                resolutionText.append("[");
                                resolutionText.append(resolution.getPriority().getPresentationName());
                                resolutionText.append("]");
                            }
                            text = resolutionText.toString();
                        }
                    }
                    if (text == null) {
                        text = "None";
                    }
                }
                return text;
            }

            public Image getImage(Object obj) {
                Image image = null;
                if (obj instanceof DuplicateCodeBlock) {
                    Resolution resolution;
                    DuplicateCodeBlock cycleGroup = (DuplicateCodeBlock)obj;
                    Issue associatedIssue = cycleGroup.getAssociatedIssue();
                    if (associatedIssue != null && (resolution = (Resolution)associatedIssue.getResolution()) != null) {
                        image = resolution.ignores() ? UiResourceManager.getInstance().getImage("Ignore") : UiResourceManager.getInstance().getImage("Fix");
                    }
                    if (image == null) {
                        image = UiResourceManager.getInstance().getImage("None");
                    }
                }
                return image;
            }
        });
        DuplicateCodeBlocksView.addSelectionListenerToColumn(this.m_treeViewer, this.m_treeViewerFirstColumn);
        DuplicateCodeBlocksView.addSelectionListenerToColumn(this.m_treeViewer, treeViewerColumnOccurrences);
        DuplicateCodeBlocksView.addSelectionListenerToColumn(this.m_treeViewer, treeViewerColumnBlockLength);
        DuplicateCodeBlocksView.addSelectionListenerToColumn(this.m_treeViewer, treeViewerColumnBlockLengthLogical);
        DuplicateCodeBlocksView.addSelectionListenerToColumn(this.m_treeViewer, treeViewerColumnTolerance);
        DuplicateCodeBlocksView.addSelectionListenerToColumn(this.m_treeViewer, treeViewerColumnResolution);
        this.m_treeViewer.setComparator((ViewerComparator)new CodeBlockBasedViewerComparator());
        this.m_treeViewer.getTree().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_treeViewer, (int)2);
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultAvailableEvent>(AnalyzerResultAvailableEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultAvailableEvent event) {
                AnalyzerResult analyzerResult;
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (DuplicateCodeBlocksView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOriginator() == null && (analyzerResult = event.getResult()).getId() == CoreAnalyzerId.DUPLICATE_CODE) {
                    DuplicateCodeBlocksView.this.m_analyzerResult = analyzerResult;
                    DuplicateCodeBlocksView.this.show(false, true);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultClearedEvent>(AnalyzerResultClearedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultClearedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (DuplicateCodeBlocksView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.contains((IAnalyzerId)CoreAnalyzerId.DUPLICATE_CODE)) {
                    DuplicateCodeBlocksView.this.reset();
                }
            }
        });
        this.updateViewOptions();
    }

    private static void addSelectionListenerToColumn(final TreeViewer treeViewer, TreeViewerColumn treeViewerColumn) {
        assert (treeViewer != null) : "Parameter 'treeViewer' of method 'addSelectionListenerToColumn' must not be null";
        assert (treeViewerColumn != null) : "Parameter 'treeViewerColumn' of method 'addSelectionListenerToColumn' must not be null";
        TreeColumn column = treeViewerColumn.getColumn();
        final int columnIndex = treeViewer.getTree().indexOf(column);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tree tree = treeViewer.getTree();
                TreeColumn currentSortColumn = tree.getSortColumn();
                int direction = 1024;
                if (currentSortColumn != null) {
                    direction = tree.indexOf(currentSortColumn) == columnIndex && tree.getSortDirection() != 128 ? 128 : 1024;
                }
                tree.setSortColumn(tree.getColumn(columnIndex));
                tree.setSortDirection(direction);
                treeViewer.refresh();
            }
        });
    }

    private void updateViewOptions() {
        MHandledMenuItem filterMenuItem = (MHandledMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)this.getEclipseContext(), (MUIElement)((MUIElement)this.getPart().getMenus().get(0)), (String)FILTER_HANDLED_ITEM_ID, MHandledMenuItem.class);
        assert (filterMenuItem != null) : "'filterMenuItem' of method 'updateViewOptions' must not be null";
        ConditionFilter oldFilter = this.m_contentProvider.getFilter();
        ConditionFilter newFilter = new ConditionFilter(oldFilter);
        if (filterMenuItem.isSelected()) {
            newFilter.remove(IGNORED_FILTER);
        } else {
            newFilter.add(IGNORED_FILTER);
        }
        this.m_contentProvider.setFilter(newFilter);
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null) : "Parameter 'elements' of method 'finishShowInView' must not be null";
        if (this.m_analyzerResult != null) {
            boolean ignores = false;
            for (Element element : elements) {
                assert (element != null && element instanceof DuplicateCodeBlock) : "Unexpected class in method 'finishShowInView': " + String.valueOf(element);
                DuplicateCodeBlock duplicateBlock = (DuplicateCodeBlock)element;
                Resolution resolution = (Resolution)duplicateBlock.getAssociatedIssue().getResolution();
                if (resolution == null || !resolution.ignores()) continue;
                ignores = true;
                break;
            }
            ConditionFilter oldFilter = this.m_contentProvider.getFilter();
            if (ignores && oldFilter.hasFiltered()) {
                ConditionFilter newFilter = new ConditionFilter(oldFilter);
                newFilter.add(IGNORED_FILTER);
                newFilter.add(NOT_IGNORED_FILTER);
                this.m_contentProvider.setFilter(newFilter);
                this.show(true, false);
                MHandledMenuItem filterMenuItem = (MHandledMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)this.getEclipseContext(), (MUIElement)((MUIElement)this.getPart().getMenus().get(0)), (String)FILTER_HANDLED_ITEM_ID, MHandledMenuItem.class);
                assert (filterMenuItem != null) : "'useAntialiasingItem' of method 'updateViewOptions' must not be null";
                filterMenuItem.setSelected(false);
            }
            this.removeListeners();
            this.m_treeViewer.setSelection((ISelection)new StructuredSelection(elements));
            this.addListeners();
        }
        super.finishShowInView(sourceViewId, elements, options);
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        for (Analyzer analyzer : ((Files)this.getSoftwareSystem().getUniqueExistingChild(Files.class)).getAnalyzers().getChildren(Analyzer.class)) {
            if (analyzer.getId() != CoreAnalyzerId.DUPLICATE_CODE) continue;
            if (analyzer.getState() != AnalyzerState.FINISHED) break;
            this.m_analyzerResult = analyzer.getResult();
            break;
        }
        this.show(false, mode == WorkbenchView.ShowMode.AWAKE);
        super.softwareSystemShow(mode);
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        if (this.m_analyzerResult != null) {
            if (restoredFromHistory || modification.contains(Modification.VIRTUAL_MODEL_CHANGED)) {
                this.show(false, false);
                this.m_textSearchHandler.requestNewFindInfo();
            } else if (modification.contains(Modification.VIRTUAL_MODEL_MODIFIED)) {
                this.show(true, true);
                this.m_textSearchHandler.requestNewFindInfo();
            }
        }
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED)) {
            this.removeListeners();
            this.m_treeViewer.getTree().setRedraw(false);
            this.m_treeViewer.refresh();
            this.m_treeViewer.getTree().setRedraw(true);
            this.addListeners();
        }
        super.analyzerModification(modification, analyzerId);
    }

    private void reset() {
        this.removeListeners();
        this.m_treeViewer.getTree().setRedraw(false);
        this.m_analyzerResult = null;
        this.m_treeViewerFirstColumn.getColumn().setText(FIRST_COLUMN);
        this.m_treeViewer.setInput(null);
        this.m_contentProvider.resetHasFiltered();
        this.m_treeViewer.getTree().setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_treeViewer.getTree().setRedraw(true);
        this.addListeners();
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.reset();
    }

    public List<Element> getSelectedElements() {
        return SelectionProviderAdapter.getElementsFromSelection((IStructuredSelection)((IStructuredSelection)this.m_treeViewer.getSelection()));
    }

    public NamedElement getLinkNamedElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getLinkNamedElement' must not be null";
        if (element instanceof DuplicateCodeBlockOccurrence) {
            DuplicateCodeBlockOccurrence dcbo = (DuplicateCodeBlockOccurrence)element;
            return dcbo.getSourceFile();
        }
        return null;
    }

    private void show(boolean tryRefresh, boolean restoreNavigationState) {
        NavigationState state;
        if (this.m_analyzerResult == null) {
            return;
        }
        this.removeListeners();
        this.getTreeViewer().getTree().setRedraw(false);
        this.m_contentProvider.resetHasFiltered();
        if (this.getTreeViewer().getInput() == null || !tryRefresh) {
            this.getTreeViewer().setInput((Object)this.m_analyzerResult);
        } else {
            this.getTreeViewer().refresh();
        }
        if (this.m_contentProvider.hasFiltered()) {
            this.getTreeViewer().getTree().setBackground(UiResourceManager.getInstance().getViewHasFilteredElementsColor());
        } else {
            this.getTreeViewer().getTree().setBackground(UiResourceManager.getInstance().getBackgroundColor());
        }
        if (restoreNavigationState && (state = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId())) != null) {
            TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.getTreeViewer(), (NavigationState)state, (IElementResolver)this.getElementResolver());
        }
        if (!tryRefresh) {
            this.m_textSearchHandler.requestNewFindInfo();
        }
        int duplicateCodeBlocks = this.m_treeViewer.getTree().getItemCount();
        this.m_treeViewerFirstColumn.getColumn().setText("Duplicate Code Block [" + duplicateCodeBlocks + " " + StringUtility.pluralize((String)"element", (int)duplicateCodeBlocks) + "]");
        this.getTreeViewer().getTree().setRedraw(true);
        this.addListeners();
    }

    public void viewOptionsChanged() {
        super.viewOptionsChanged();
        this.updateViewOptions();
        this.m_textSearchHandler.requestNewFindInfo();
        this.show(false, true);
    }

    private static final class CodeBlockBasedViewerComparator
    extends ViewerComparator {
        private CodeBlockBasedViewerComparator() {
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            assert (viewer != null) : "Parameter 'viewer' of method 'compare' must not be null";
            assert (o1 != null) : "Parameter 'o1' of method 'compare' must not be null";
            assert (o2 != null) : "Parameter 'o2' of method 'compare' must not be null";
            Tree tree = ((TreeViewer)viewer).getTree();
            TreeColumn currentSortIndicator = tree.getSortColumn();
            int columnIndex = currentSortIndicator != null ? tree.indexOf(currentSortIndicator) : 3;
            int result = 0;
            if (o1 instanceof DuplicateCodeBlock && o2 instanceof DuplicateCodeBlock) {
                result = this.compareDuplicateCodeBlocks((DuplicateCodeBlock)o1, (DuplicateCodeBlock)o2, columnIndex);
            } else if (o1 instanceof DuplicateCodeBlockOccurrence && o2 instanceof DuplicateCodeBlockOccurrence) {
                DuplicateCodeBlockOccurrence occurrence1 = (DuplicateCodeBlockOccurrence)o1;
                DuplicateCodeBlockOccurrence occurrence2 = (DuplicateCodeBlockOccurrence)o2;
                if (currentSortIndicator != null) {
                    if (columnIndex == 0) {
                        result = occurrence1.getName().compareTo(occurrence2.getName());
                        if (result == 0) {
                            result = Integer.compare(occurrence1.getBlockBegin(), occurrence2.getBlockBegin());
                        }
                    } else if (columnIndex == 5) {
                        result = Integer.compare(occurrence1.getToleranceAsInt(), occurrence2.getToleranceAsInt());
                    }
                }
            }
            if (currentSortIndicator != null && tree.getSortDirection() == 1024) {
                return result * -1;
            }
            return result;
        }

        private int compareDuplicateCodeBlocks(DuplicateCodeBlock block1, DuplicateCodeBlock block2, int columnIndex) {
            int result = 0;
            switch (columnIndex) {
                case 0: {
                    result = Integer.compare(block1.getSimpleId(), block2.getSimpleId());
                    break;
                }
                case 1: {
                    result = Integer.compare(block1.getTotalNumberOfOccurrences(), block2.getTotalNumberOfOccurrences());
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    result = Integer.compare(block1.getBlockSize(), block2.getBlockSize());
                    break;
                }
                case 4: {
                    result = Integer.compare(block1.getBlockSizeWithoutIgnored(), block2.getBlockSizeWithoutIgnored());
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    result = SingleIssueProviderComparator.compareByResolutionPriority((ISingleIssueProvider)block1, (ISingleIssueProvider)block2);
                    break;
                }
                default: {
                    assert (false) : "Unexpected column index: " + columnIndex;
                    break;
                }
            }
            return result;
        }
    }
}

