/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.Baseline;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.ui.standalone.diffview.OpenBaselineWizard;
import com.hello2morrow.sonargraph.ui.standalone.diffview.SystemDiffViewHeader;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public final class SystemDiffSetBaselineHandler
extends CommandHandlerWithCorrespondingCommand {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.SET_BASELINE;
    }

    public final IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){};
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        if (this.isAvailable() && selection != null && !selection.isEmpty() && WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) {
            Baseline baseline = (Baseline)CommandHandler.getSingleSelection(Baseline.class, (List)selection.getElements(), (boolean)false);
            return baseline != null && !FileUtility.refersToSameFile((TFile)((ISystemDiffProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(ISystemDiffProvider.class)).getActiveBaselineFile(), (TFile)baseline.getFile());
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "Not software system available";
        Baseline baseline = (Baseline)CommandHandler.getSingleSelection(Baseline.class, (List)selection.getElements(), (boolean)true);
        OpenBaselineWizard openBaselineWizard = new OpenBaselineWizard(provider, baseline.getFile());
        WizardDialog wizardDialog = SonargraphWizardAdapter.createWizardDialog((Shell)WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), (SonargraphWizard)openBaselineWizard);
        if (wizardDialog.open() == 0) {
            SystemDiffViewHeader.setBaseline(provider, openBaselineWizard.getBaseline(), openBaselineWizard.getBaselineType());
        }
    }
}

