/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.SystemDiffAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffConfiguration;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.diffview.SystemDiffViewComponent;
import com.hello2morrow.sonargraph.ui.standalone.settings.AnalyzerPropertyPage;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public final class SystemDiffPropertyPage
extends AnalyzerPropertyPage<SystemDiffAnalyzerConfiguration> {
    private TFile m_originalBaselinePath;
    private boolean m_originalIsEnabled;
    private TFile m_currentBaselinePath;
    private boolean m_currentIsEnabled;

    public SystemDiffPropertyPage() {
        super((IAnalyzerId)CoreAnalyzerId.SYSTEM_DIFF);
    }

    @Override
    public IDialogId getDialogId() {
        return CoreDialogId.SYSTEM_DIFF_ANALYZER_PROPERTY_PAGE;
    }

    @Override
    protected int getNumberOfColumns() {
        return 1;
    }

    private static TFile getSystemDirectoryFile() {
        return WorkbenchRegistry.getInstance().getSoftwareSystem().getSystemDirectoryFile();
    }

    @Override
    protected void fillDialogArea(Composite composite, SystemDiffAnalyzerConfiguration configuration, boolean readOnly) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'fillDialogArea' must not be null";
        Composite infoComposite = new Composite(composite, 0);
        infoComposite.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        GridData infoGridData = new GridData(4, 4, true, false);
        infoGridData.widthHint = 500;
        infoComposite.setLayoutData((Object)infoGridData);
        Label info = new Label(infoComposite, 64);
        info.setLayoutData((Object)new GridData(4, 4, true, false));
        info.setText("A baseline is used to track and report changes of a software system. Changes are visualized in the System view (dashboard) via trends and in the System Diff view in more detail. Using a baseline also allows you to define quality gate conditions with respect to that baseline.\n\nA system baseline is meant to be useful for all Sonargraph users and clients and is usually located within the software system's baselines directory and committed into the version control system.\n");
        SystemDiffConfiguration diffConfiguration = ((ISystemDiffProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(ISystemDiffProvider.class)).getSystemDiffConfiguration();
        BaselineType baselineType = diffConfiguration.getBaselineType();
        if (baselineType != null && baselineType == BaselineType.LOCAL) {
            Link status = new Link(infoComposite, 64);
            status.setLayoutData((Object)new GridData(4, 4, true, true));
            status.setText("NOTE: Currently a local baseline is active! To activate the system baseline use the\n<a>Configuration section in the System Diff view</a>.\n");
            status.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ShowInViewSelectionAdapter.showInView((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (EPartService)WorkbenchRegistry.getInstance().getPartService(), (IViewId)ViewId.SYSTEM_DIFF_VIEW, null, (IStandardEnumeration)SystemDiffViewComponent.CONFIGURATION);
                    SystemDiffPropertyPage.this.getShell().close();
                }
            });
        }
        Group systemBaselineGroup = new Group(composite, 32);
        systemBaselineGroup.setText("System Baseline");
        systemBaselineGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        systemBaselineGroup.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin((int)2));
        this.m_currentIsEnabled = this.m_originalIsEnabled = configuration.isEnabled();
        String baselinePath = configuration.getBaselinePath();
        if (baselinePath != null && !baselinePath.isEmpty()) {
            this.m_currentBaselinePath = this.m_originalBaselinePath = FileUtility.getAbsolutePath((TFile)SystemDiffPropertyPage.getSystemDirectoryFile(), (String)baselinePath);
        }
        Label enabledLabel = new Label((Composite)systemBaselineGroup, 0);
        enabledLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        enabledLabel.setText("Enabled:");
        final Button isEnabledCheckbox = new Button((Composite)systemBaselineGroup, 32);
        isEnabledCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        isEnabledCheckbox.setSelection(this.m_originalIsEnabled);
        Label baselineLabel = new Label((Composite)systemBaselineGroup, 0);
        baselineLabel.setText("Baseline:");
        baselineLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ISystemDiffProvider systemDiffProvider = (ISystemDiffProvider)WorkbenchRegistry.getInstance().getSoftwareSystem().getExtension(ISystemDiffProvider.class);
        final ValidatingPathWidget baselineWidget = new ValidatingPathWidget((Composite)systemBaselineGroup, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                if (inputModified) {
                    SystemDiffPropertyPage.this.m_currentBaselinePath = input;
                }
            }
        }, (IPathValidator)new BaselinePathValidator(systemDiffProvider.getBaselineValidator()), 2, this.m_originalBaselinePath, false, SystemDiffPropertyPage.getSystemDirectoryFile());
        baselineWidget.setFilterExtensions(new String[]{"*" + CoreFileType.ANALYZER_CONFIGURATION.getDefaultExtension()});
        GridData pathGridData = GridDataFactory.copyData((GridData)new GridData(4, 0x1000000, true, false));
        pathGridData.widthHint = 300;
        baselineWidget.setLayoutData((Object)pathGridData);
        isEnabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemDiffPropertyPage.this.m_currentIsEnabled = isEnabledCheckbox.getSelection();
                baselineWidget.validate(true);
            }
        });
    }

    @Override
    protected String isDataValid() {
        if (this.m_currentIsEnabled && this.m_currentBaselinePath == null) {
            return "System baseline is enabled but no baseline path is specified.\nSelect a valid baseline path.";
        }
        return null;
    }

    @Override
    protected boolean applyChanges(SystemDiffAnalyzerConfiguration configuration) {
        assert (configuration != null) : "Parameter 'configuration' of method 'applyChanges' must not be null";
        if (this.m_originalIsEnabled != this.m_currentIsEnabled || this.m_originalBaselinePath != null && this.m_currentBaselinePath != null && !FileUtility.refersToSameFile((TFile)this.m_originalBaselinePath, (TFile)this.m_currentBaselinePath)) {
            configuration.setBaselinePath(FileUtility.calculateRelativePath((TFile)this.m_currentBaselinePath, (TFile)SystemDiffPropertyPage.getSystemDirectoryFile()), this.m_currentIsEnabled);
            return true;
        }
        return false;
    }

    final class BaselinePathValidator
    implements IPathValidator {
        private final IPathValidator m_pathValidator;

        public BaselinePathValidator(IPathValidator validator) {
            assert (validator != null) : "Parameter 'validator' of method 'BaselinePathValidator' must not be null";
            this.m_pathValidator = validator;
        }

        public IPathValidator.PathType getType() {
            return this.m_pathValidator.getType();
        }

        public ValidationResult isValid(TFile currentInput, TFile newInput) {
            SystemDiffAnalyzerConfiguration configuration = (SystemDiffAnalyzerConfiguration)SystemDiffPropertyPage.this.getConfiguration();
            String baselinePath = configuration.getBaselinePath();
            if (!SystemDiffPropertyPage.this.m_currentIsEnabled && (baselinePath == null || baselinePath.isEmpty())) {
                return new ValidationResult();
            }
            if (FileUtility.refersToSameFile((TFile)SystemDiffPropertyPage.this.m_originalBaselinePath, (TFile)newInput)) {
                return new ValidationResult();
            }
            return this.m_pathValidator.isValid(currentInput, newInput);
        }
    }
}

