/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockOccurrenceDiff;
import com.hello2morrow.sonargraph.ui.standalone.diffview.IssueDiffResourceProvider;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

final class DuplicatesDiffColumLabelProvider
extends ColumnLabelProvider {
    private final int m_columnIndex;

    public DuplicatesDiffColumLabelProvider(int columnIndex) {
        this.m_columnIndex = columnIndex;
    }

    public String getText(Object element) {
        assert (element != null && element instanceof IDiffElement) : "Unexpected class in method 'getText': " + String.valueOf(element);
        assert (element != null && element instanceof NamedElement) : "Unexpected class in method 'getText': " + String.valueOf(element);
        NamedElement namedElement = (NamedElement)element;
        IDiffElement deltaElement = (IDiffElement)element;
        switch (this.m_columnIndex) {
            case 0: {
                if (element instanceof DuplicateCodeBlockOccurrenceDiff) {
                    return ((DuplicateCodeBlockOccurrenceDiff)element).getIdentifyingPath();
                }
                return namedElement.getPresentationName(true);
            }
            case 1: {
                return deltaElement.getChange().getPresentationName();
            }
            case 2: {
                return deltaElement.getChangeDescription();
            }
            case 3: {
                if (element instanceof DuplicateCodeBlockIssueDiff) {
                    return "" + ((DuplicateCodeBlockIssueDiff)element).getNumberOfOccurrences();
                }
                return null;
            }
            case 4: {
                if (element instanceof DuplicateCodeBlockOccurrenceDiff) {
                    String lineRange = ((DuplicateCodeBlockOccurrenceDiff)element).getLineRange();
                    return lineRange;
                }
                return null;
            }
            case 5: {
                if (element instanceof DuplicateCodeBlockOccurrenceDiff) {
                    return "" + ((DuplicateCodeBlockOccurrenceDiff)element).getBlockSize();
                }
                return null;
            }
            case 6: {
                if (element instanceof DuplicateCodeBlockOccurrenceDiff) {
                    return "" + ((DuplicateCodeBlockOccurrenceDiff)element).getTolerance();
                }
                return null;
            }
            case 7: {
                if (element instanceof DuplicateCodeBlockIssueDiff) {
                    DuplicateCodeBlockIssueDiff diff = (DuplicateCodeBlockIssueDiff)element;
                    ResolutionKind resolutionKind = diff.getCurrent() != null ? diff.getCurrentResolutionKind() : diff.getBaselineResolutionKind();
                    return resolutionKind != null ? resolutionKind.getPresentationName() : "None";
                }
                return null;
            }
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        assert (element != null && element instanceof IDiffElement) : "Unexpected class in method 'getText': " + String.valueOf(element);
        assert (element != null && element instanceof NamedElement) : "Unexpected class in method 'getText': " + String.valueOf(element);
        NamedElement namedElement = (NamedElement)element;
        switch (this.m_columnIndex) {
            case 0: {
                return UiResourceManager.getInstance().getImage(namedElement.getImageResourceName());
            }
            case 1: {
                if (!(element instanceof IDiffElement)) break;
                IDiffElement diff = (IDiffElement)element;
                return IssueDiffResourceProvider.getInstance().getChangeImage(diff.getChange());
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                if (!(element instanceof DuplicateCodeBlockIssueDiff)) break;
                DuplicateCodeBlockIssueDiff diff = (DuplicateCodeBlockIssueDiff)element;
                ResolutionKind resolutionKind = diff.getCurrent() != null ? diff.getCurrentResolutionKind() : diff.getBaselineResolutionKind();
                if (resolutionKind != null) {
                    return UiResourceManager.getInstance().getImage(resolutionKind.getStandardName());
                }
                return UiResourceManager.getInstance().getImage("None");
            }
        }
        return super.getImage(element);
    }
}

