/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.ui.standalone.diffview.DiffTabFolderViewOptions;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.BaseTextSearchHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeColumn;

abstract class DiffViewTab<T extends Control, V extends Viewer>
extends Composite {
    private final CTabItem m_tabItem;
    private final String m_title;

    public DiffViewTab(CTabFolder parent, String title, String imageName) {
        super((Composite)parent, 0);
        this.m_title = title;
        this.m_tabItem = new CTabItem(parent, 0);
        this.m_tabItem.setText(title);
        this.m_tabItem.setImage(UiResourceManager.getInstance().getImage(imageName));
    }

    final String getTitle() {
        return this.m_title;
    }

    final CTabItem getTabItem() {
        return this.m_tabItem;
    }

    Control getControl() {
        return this.m_tabItem.getControl();
    }

    final void setExclamationMarkInTabTitle(boolean show) {
        String previous = this.m_tabItem.getText();
        int closingParenthesis = previous.lastIndexOf(") ");
        if (closingParenthesis > 0) {
            previous = previous.substring(closingParenthesis + 2);
        }
        Object title = previous;
        if (show) {
            title = "(!) " + (String)title;
        }
        this.m_tabItem.setText((String)title);
    }

    final void showElementCountInHeader(TreeViewer viewer, int itemCount) {
        assert (viewer != null) : "Parameter 'viewer' of method 'showElementCountInHeader' must not be null";
        TreeColumn column = viewer.getTree().getColumn(0);
        String previous = column.getText();
        int openBracket = previous.indexOf(91);
        StringBuilder newText = openBracket > 0 ? new StringBuilder(previous.substring(0, openBracket)) : new StringBuilder(previous).append(" ");
        newText = newText.append("[").append(itemCount).append("]");
        column.setText(newText.toString());
    }

    final void setBackgroundColor(TreeViewer viewer, int numberOfFiltered) {
        assert (viewer != null) : "Parameter 'treeViewer' of method 'adjustBackgroundColor' must not be null";
        viewer.getControl().setBackground(numberOfFiltered > 0 ? UiResourceManager.getInstance().getViewHasFilteredElementsColor() : UiResourceManager.getInstance().getBackgroundColor());
    }

    abstract void clear();

    abstract void show(SoftwareSystemDiff var1);

    abstract IStructuredSelection getSelection();

    abstract void clearSelection();

    DiffTabFolderViewOptions getViewOptions() {
        return null;
    }

    abstract V getViewer();

    abstract BaseTextSearchHandler createTextSearchHandler(String var1);
}

