/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.consoleview;

import com.hello2morrow.sonargraph.core.model.script.BufferedOutputStream;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.StandaloneOutputStreamProvider;
import com.hello2morrow.sonargraph.ui.standalone.consoleview.ConsoleView;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public final class ConsolesAvailableHandler
extends CommandHandler {
    @CanExecute
    public boolean canExecute() {
        if (this.isAvailable()) {
            return !StandaloneOutputStreamProvider.getInstance().getBufferedOutputStreams().isEmpty();
        }
        return false;
    }

    @Execute
    public void execute(@Optional Display display) {
        if (display != null && !display.isDisposed()) {
            Point location = display.getCursorLocation();
            Shell shell = new Shell(display);
            Menu menu = new Menu((Control)shell);
            Image image = UiResourceManager.getInstance().getImage("ConsoleView");
            for (BufferedOutputStream nextAvailable : StandaloneOutputStreamProvider.getInstance().getBufferedOutputStreams()) {
                MenuItem nextItem = new MenuItem(menu, 8);
                final String nextConsoleId = nextAvailable.getId();
                nextItem.setText(nextConsoleId);
                nextItem.setImage(image);
                nextItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MPart consoleViewPart = WorkbenchRegistry.getInstance().getPartService().findPart(ViewId.CONSOLE_VIEW.getId());
                        if (!$assertionsDisabled && consoleViewPart == null) {
                            throw new AssertionError((Object)"'consoleViewPart' of method 'execute' must not be null");
                        }
                        ConsoleView consoleView = (ConsoleView)RcpUtility.getWorkbenchView((MPart)consoleViewPart, ConsoleView.class);
                        if (!$assertionsDisabled && consoleView == null) {
                            throw new AssertionError((Object)"'consoleView' of method 'execute' must not be null");
                        }
                        consoleView.showConsole(nextConsoleId);
                    }
                });
            }
            menu.setLocation(location);
            menu.setVisible(true);
            while (!menu.isDisposed() && menu.isVisible()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            menu.dispose();
            shell.dispose();
        }
    }
}

