/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler.remoting;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.remoting.SingleRemoteSelectionRequestCommand;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INamedElementAdapter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingEdge;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.remoting.IRemoteSelectionProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.standalone.sourceview.SourceView;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

public final class SendSelectionRequestToIdeHandler
extends CommandHandlerWithCorrespondingCommand {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.REQUEST_SELECTION_IN_IDE;
    }

    private StrictPair<NamedElement, Integer> getElementInfo(WorkbenchViewSelection selection) {
        if (selection != null && selection.size() == 1 && WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) {
            Element element = ((Element)selection.getElements().get(0)).getElement();
            NamedElement namedElement = null;
            int lineNumber = -1;
            if (selection.getWorkbenchView() instanceof SourceView) {
                if (element instanceof SourceFile) {
                    SourceView sourceView = (SourceView)selection.getWorkbenchView();
                    SourceFile sourceFile = (SourceFile)element;
                    namedElement = sourceFile;
                    lineNumber = sourceView.getCurrentLine();
                    StrictPair<Integer, Integer> lineRange = sourceView.getVisibleLineRange();
                    if (lineNumber < 0) {
                        lineNumber = (Integer)lineRange.getFirst();
                    } else if (lineNumber < (Integer)lineRange.getFirst()) {
                        lineNumber = (Integer)lineRange.getFirst();
                    } else if ((Integer)lineRange.getSecond() > 0 && lineNumber > (Integer)lineRange.getSecond()) {
                        lineNumber = (Integer)lineRange.getSecond();
                    }
                    if (lineNumber <= 0) {
                        lineNumber = 1;
                    }
                }
            } else if (element instanceof ParserDependency) {
                ParserDependency parserDependency = (ParserDependency)element;
                namedElement = parserDependency.getUnderlyingFrom();
                lineNumber = parserDependency.getLineNumber();
            } else if (element instanceof IParserDependenciesProvidingEdge) {
                IParserDependenciesProvidingEdge parserDependency = (IParserDependenciesProvidingEdge)element;
                namedElement = parserDependency.getFromEndPoint();
                if (parserDependency.getParserDependencies().size() == 1) {
                    lineNumber = ((ParserDependency)parserDependency.getParserDependencies().iterator().next()).getLineNumber();
                }
            } else if (element instanceof INamedElementAdapter) {
                List adaptedTo = ((INamedElementAdapter)element).getAdaptedTo();
                if (!adaptedTo.isEmpty() && adaptedTo.get(0) != null && ((NamedElement)adaptedTo.get(0)).isValid()) {
                    namedElement = (NamedElement)adaptedTo.get(0);
                }
            } else if (element instanceof NamedElement) {
                namedElement = (NamedElement)element;
            }
            if (namedElement != null && namedElement.getParent(Module.class, ParentMode.SELF_OR_FIRST_PARENT) != null && namedElement.getOriginal() != null && namedElement.getOriginal().isValid()) {
                return new StrictPair((Object)namedElement.getOriginal(), (Object)lineNumber);
            }
        }
        return null;
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        return this.getElementInfo(selection) != null;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        final StrictPair<NamedElement, Integer> elementInfo = this.getElementInfo(selection);
        if (elementInfo != null) {
            if (!((IRemoteSelectionProvider)WorkbenchRegistry.getInstance().getProvider().getInstallation().getExtension(IRemoteSelectionProvider.class)).isRemoteListening()) {
                UserInterfaceAdapter.getInstance().information("No IDE listening to remote selection requests!", null);
                return;
            }
            SingleRemoteSelectionRequestCommand command = new SingleRemoteSelectionRequestCommand(WorkbenchRegistry.getInstance().getProvider(), new SingleRemoteSelectionRequestCommand.IInteraction(){

                public boolean collect(SingleRemoteSelectionRequestCommand.InteractionData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.setElement((NamedElement)elementInfo.getFirst());
                    data.setLineNumber(((Integer)elementInfo.getSecond()).intValue());
                    return true;
                }

                public void processResult(OperationResult result) {
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
    }
}

