/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.workbench;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchAuxiliaryView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.ElementGroup;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Control;

public abstract class SimpleWorkbenchAuxiliaryView
extends WorkbenchAuxiliaryView
implements ISelectionChangedListener {
    private final DeadStateInfoProvider m_deadStateInfoProvider = new DeadStateInfoProvider();

    protected SimpleWorkbenchAuxiliaryView() {
    }

    protected abstract PropertyTableViewer<? extends Element> getViewer();

    protected final void initialize() {
        super.initialize();
        this.getViewer().getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public final List<Control> getControlsForInteraction() {
        return Collections.singletonList(this.getViewer().getTable());
    }

    protected final WorkbenchView getWorkbenchView(String id, String secondaryId) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'getWorkbenchView' must not be empty";
        MPart viewPart = RcpUtility.findPart((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (String)id, secondaryId != null && !secondaryId.isEmpty() ? secondaryId : null);
        return viewPart != null ? (WorkbenchView)RcpUtility.getWorkbenchView((MPart)viewPart, WorkbenchView.class) : null;
    }

    protected final void completeNavigationState(NavigationState state, List<Element> selectedElements) {
        assert (state != null) : "Parameter 'state' of method 'completeNavigationState' must not be null";
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'completeNavigationState' must not be null";
        state.addElementsInformation((IElementGroup)ElementGroup.SELECTION, NavigationState.getDescriptors(selectedElements, (IElementResolver)this.getElementResolver()));
        state.markAsZombie();
        state.setDeadStateInfoProvider((NavigationState.IDeadStateInfoProvider)this.m_deadStateInfoProvider);
        WorkbenchView connectedView = this.getConnectedView();
        if (connectedView != null) {
            state.addString((IStateData)StateData.CONNECTED_VIEW_ID, connectedView.getViewId().getId());
            String secondaryId = connectedView.getSecondaryId();
            if (secondaryId != null && !secondaryId.isEmpty()) {
                state.addString((IStateData)StateData.CONNECTED_VIEW_SECONDARY_ID, secondaryId);
            }
        }
    }

    public final void completeViewNavigationState(NavigationState state) {
        this.completeNavigationState(state, this.getSelectedElements());
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        List selectedElements = this.getSelectedElements();
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.completeNavigationState(state, selectedElements);
        ViewNavigationManager.getInstance().addNavigationState(state);
        this.getSelectionProviderAdapter().handleSelectionChanged(selectedElements);
    }

    protected Map<Element, Element> getElementMapping(Collection<Element> currentInput) {
        assert (currentInput != null) : "Parameter 'currentInput' of method 'getElementMapping' must not be null";
        if (currentInput.isEmpty()) {
            return Collections.emptyMap();
        }
        THashMap mapping = new THashMap();
        for (Element next : currentInput) {
            mapping.put(next, next);
        }
        return mapping;
    }

    protected final StructuredSelection restoreNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        TableViewer tableViewer = this.getViewer().getTableViewer();
        Control control = tableViewer.getControl();
        try {
            WorkbenchView connectedView;
            StructuredSelection selection;
            control.setRedraw(false);
            tableViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            Object input = tableViewer.getInput();
            if (input != null) {
                assert (input instanceof Collection) : "Unexpected class in method 'restoreNavigationState': " + String.valueOf(input);
                Map<Element, Element> mapping = this.getElementMapping((Collection)input);
                ArrayList<Element> selectElements = new ArrayList<Element>(mapping.size());
                for (Element nextRestoredElement : state.getElements((IElementGroup)ElementGroup.SELECTION, Element.class, this.getElementResolver())) {
                    Element nextElement = mapping.get(nextRestoredElement);
                    if (nextElement == null) continue;
                    selectElements.add(nextElement);
                }
                selection = new StructuredSelection(selectElements);
            } else {
                selection = new StructuredSelection();
            }
            tableViewer.setSelection((ISelection)selection, true);
            String connectedViewId = state.getString((IStateData)StateData.CONNECTED_VIEW_ID);
            if (connectedViewId != null && !connectedViewId.isEmpty() && (connectedView = this.getWorkbenchView(connectedViewId, state.getString((IStateData)StateData.CONNECTED_VIEW_SECONDARY_ID))) != null) {
                this.connect(connectedView);
            }
            StructuredSelection structuredSelection = selection;
            return structuredSelection;
        }
        finally {
            tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            control.setRedraw(true);
        }
    }

    protected final void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        this.getSelectionProviderAdapter().handleSelectionChanged((IStructuredSelection)this.restoreNavigationState(state));
    }

    private class DeadStateInfoProvider
    implements NavigationState.IDeadStateInfoProvider {
        DeadStateInfoProvider() {
        }

        public boolean meetsDeadStateCriteria(NavigationState navigationState, IElementResolver elementResolver) {
            assert (navigationState != null) : "Parameter 'navigationState' of method 'meetsDeadStateCriteria' must not be null";
            assert (elementResolver != null) : "Parameter 'elementResolver' of method 'meetsDeadStateCriteria' must not be null";
            ArrayList elementsForSelection = new ArrayList(navigationState.getElements((IElementGroup)ElementGroup.SELECTION, Element.class, SimpleWorkbenchAuxiliaryView.this.getElementResolver()));
            Object input = SimpleWorkbenchAuxiliaryView.this.getViewer().getTableViewer().getInput();
            if (input == null) {
                return true;
            }
            assert (input instanceof Collection) : "Unexpected class in method 'restoreNavigationState': " + String.valueOf(input);
            Collection inputCollection = (Collection)input;
            Iterator it = elementsForSelection.iterator();
            while (it.hasNext()) {
                Element next = (Element)it.next();
                if (inputCollection.contains(next)) continue;
                it.remove();
            }
            return elementsForSelection.isEmpty();
        }

        public String toString() {
            return SimpleWorkbenchAuxiliaryView.this.getViewId().getStandardName() + " dead state info provider";
        }
    }

    private static enum StateData implements IStateData
    {
        CONNECTED_VIEW_ID,
        CONNECTED_VIEW_SECONDARY_ID;

    }
}

