/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.swt;

import com.hello2morrow.sonargraph.ui.standalone.base.swt.DropTargetAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public final class DragSourceAdapter<T>
implements DragSourceListener {
    private static final Transfer[] TRANSFER = new Transfer[]{TextTransfer.getInstance()};
    private final StructuredViewer m_viewer;
    private final List<DropTargetAdapter<T>> m_targetAdapters;
    private final List<Class<? extends T>> m_dragClasses;
    private final IDragActionHandler<T> m_dragActionHandler;

    private static <T> void initialize(StructuredViewer viewer, int operations, DragSourceListener dragSourceListener, List<DropTargetAdapter<T>> targetAdapters) {
        assert (viewer != null) : "Parameter 'viewer' of method 'initialize' must not be null";
        assert (dragSourceListener != null) : "Parameter 'dragSourceListener' of method 'initialize' must not be null";
        assert (targetAdapters != null && !targetAdapters.isEmpty()) : "Parameter 'targetAdapters' of method 'initialize' must not be empty";
        viewer.addDragSupport(operations, TRANSFER, dragSourceListener);
        for (DropTargetAdapter<T> nextTargetAdapter : targetAdapters) {
            nextTargetAdapter.connectWithViewer(operations, TRANSFER);
        }
    }

    public DragSourceAdapter(StructuredViewer viewer, int operations, List<DropTargetAdapter<T>> targetAdapters, List<Class<? extends T>> dragClasses) {
        assert (viewer != null) : "Parameter 'viewer' of method 'DragSourceAdapter' must not be null";
        assert (targetAdapters != null && targetAdapters.size() > 0) : "Parameter 'targetAdapters' of method 'DragSourceAdapter' must not be empty";
        assert (dragClasses != null && dragClasses.size() > 0) : "Parameter 'dragClasses' of method 'DragSourceAdapter' must not be empty";
        this.m_viewer = viewer;
        this.m_targetAdapters = targetAdapters;
        this.m_dragClasses = dragClasses;
        this.m_dragActionHandler = null;
        DragSourceAdapter.initialize(this.m_viewer, operations, this, this.m_targetAdapters);
    }

    public DragSourceAdapter(StructuredViewer viewer, int operations, List<DropTargetAdapter<T>> targetAdapters, List<Class<? extends T>> dragClasses, IDragActionHandler<T> dragActionHandler) {
        assert (viewer != null) : "Parameter 'viewer' of method 'DragSourceAdapter' must not be null";
        assert (targetAdapters != null && targetAdapters.size() > 0) : "Parameter 'targetAdapters' of method 'DragSourceAdapter' must not be empty";
        assert (dragClasses != null && !dragClasses.isEmpty()) : "Parameter 'dragClasses' of method 'DragSourceAdapter' must not be empty";
        assert (dragActionHandler != null) : "Parameter 'dragActionHandler' of method 'DragSourceAdapter' must not be null";
        this.m_viewer = viewer;
        this.m_targetAdapters = new ArrayList<DropTargetAdapter<T>>(targetAdapters);
        this.m_dragClasses = dragClasses;
        this.m_dragActionHandler = dragActionHandler;
        DragSourceAdapter.initialize(this.m_viewer, operations, this, this.m_targetAdapters);
    }

    private List<T> getSelection() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.m_viewer.getSelection();
        if (!structuredSelection.isEmpty()) {
            List selection = structuredSelection.toList();
            ArrayList typedSelection = new ArrayList(selection.size());
            for (Object next : selection) {
                typedSelection.add(next);
            }
            return typedSelection;
        }
        return Collections.emptyList();
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.m_viewer.getSelection();
        if (TextTransfer.getInstance().isSupportedType(event.dataType) && !structuredSelection.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            List<T> typedSelection = this.getSelection();
            for (T t : typedSelection) {
                builder.append(t.toString());
                builder.append(",");
            }
            if (builder.length() > 0) {
                builder.deleteCharAt(builder.length() - 1);
            }
            for (DropTargetAdapter dropTargetAdapter : this.m_targetAdapters) {
                dropTargetAdapter.setSelection(typedSelection);
            }
            event.data = builder.toString();
        }
    }

    public void dragStart(DragSourceEvent event) {
        assert (event != null) : "Parameter 'event' of method 'dragStart' must not be null";
        boolean doIt = true;
        List<T> typedSelection = this.getSelection();
        if (typedSelection.isEmpty()) {
            doIt = false;
        } else {
            for (T next : typedSelection) {
                boolean matches = false;
                for (Class<T> nextClazz : this.m_dragClasses) {
                    if (!nextClazz.isAssignableFrom(next.getClass())) continue;
                    matches = true;
                    break;
                }
                if (matches) continue;
                doIt = false;
                break;
            }
        }
        event.doit = doIt && (this.m_dragActionHandler == null || this.m_dragActionHandler.validateDrag(typedSelection));
    }

    public void dragFinished(DragSourceEvent event) {
        if (this.m_dragActionHandler != null) {
            this.m_dragActionHandler.dragFinished();
        }
    }

    public static interface IDragActionHandler<T> {
        public boolean validateDrag(List<T> var1);

        default public void dragFinished() {
        }
    }
}

