/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.sourceview;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.TargetInSource;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.LineInformation;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SourceViewWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SyntaxHighlightMode;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public abstract class LanguageBasedSourceViewWidget
extends SourceViewWidget {
    private final IWorkbenchView m_workbenchView;
    private int m_startHyperlink;
    private int m_extentHyperlink;
    private TargetInSource m_targetInSource;
    private Language m_language;

    public static void performOutOfDateCheck(SoftwareSystem system, LanguageBasedSourceViewWidget ... sourceWidgets) {
        assert (system != null) : "Parameter 'system' of method 'checkSourceFilesOutOfDate' must not be null";
        assert (sourceWidgets != null && sourceWidgets.length > 0) : "Parameter 'sourceWidgets' of method 'checkSourceFilesOutOfDate' must not be empty";
        if (system.getMode() == SoftwareSystemMode.SYSTEM) {
            ArrayList<String> outOfDateInfo = new ArrayList<String>(sourceWidgets.length);
            LanguageBasedSourceViewWidget[] languageBasedSourceViewWidgetArray = sourceWidgets;
            int n = sourceWidgets.length;
            int n2 = 0;
            while (n2 < n) {
                LanguageBasedSourceViewWidget nextWidget = languageBasedSourceViewWidgetArray[n2];
                if (nextWidget.isSourceAvailable()) {
                    String hasTimestampChangedOnDisk;
                    FilePath nextSource = nextWidget.getSourceFile();
                    ILanguageProvider nextLanguageProvider = nextWidget.getLanguageProvider();
                    if (nextLanguageProvider != null && (hasTimestampChangedOnDisk = nextLanguageProvider.hasTimestampChangedOnDisk(nextSource)) != null) {
                        outOfDateInfo.add(hasTimestampChangedOnDisk);
                    }
                }
                ++n2;
            }
            if (!outOfDateInfo.isEmpty()) {
                StringBuilder builder = new StringBuilder("The time stamp of an involved source file has changed on disk.");
                builder.append("\n");
                builder.append("This might alter the analysis results.");
                builder.append("\n");
                builder.append("\n");
                builder.append("File(s):");
                builder.append("\n");
                for (String next : outOfDateInfo) {
                    builder.append("  ").append(next).append("\n");
                }
                builder.append("\n");
                builder.append("Consider performing a 'refresh'!");
                UserInterfaceAdapter.getInstance().information("Source file changed on disk.", builder.toString());
            }
        }
    }

    public LanguageBasedSourceViewWidget(Composite parent, IWorkbenchView workbenchView) {
        super(parent, true);
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'LanguageBasedSourceViewWidget' must not be null";
        this.m_workbenchView = workbenchView;
        this.getSourceWidget().addMouseListener((MouseListener)this);
    }

    public final ILanguageProvider getLanguageProvider() {
        SoftwareSystem softwareSystem;
        if (this.m_language != null && (softwareSystem = this.getSoftwareSystem()) != null && softwareSystem.isValid()) {
            return ((ISoftwareSystemProvider)softwareSystem.getExtension(ISoftwareSystemProvider.class)).getLanguageProvider(this.m_language);
        }
        return null;
    }

    @Override
    protected final void sourceFileShown(FilePath sourceFile) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'aboutToShowFile' must not be null";
        this.m_language = sourceFile.getLanguage();
        super.sourceFileShown(sourceFile);
    }

    private void resetHyperlinking(boolean resetRegion) {
        this.getSourceWidget().setCursor(null);
        if (resetRegion && this.m_startHyperlink != -1 && this.m_extentHyperlink != -1) {
            this.setHyperlinkStyle(this.m_startHyperlink, this.m_extentHyperlink, UiResourceManager.getInstance().getForegroundColor(), false);
        }
        this.m_targetInSource = null;
        this.m_startHyperlink = -1;
        this.m_extentHyperlink = -1;
    }

    @Override
    public void clear() {
        this.m_language = null;
        this.resetHyperlinking(false);
        super.clear();
    }

    private void setHyperlinkStyle(int startOffset, int extent, Color hyperlinkColor, boolean underline) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = startOffset;
        styleRange.length = extent;
        styleRange.foreground = hyperlinkColor;
        if (underline) {
            styleRange.underline = true;
            styleRange.underlineColor = hyperlinkColor;
        }
        this.setHyperLinkStyleRange(styleRange);
        this.setSyntaxHighlightMode(SyntaxHighlightMode.ON_HYPERLINKING);
        this.getSourceWidget().redrawRange(startOffset, extent, false);
    }

    @Override
    public final void mouseMove(MouseEvent event) {
        FilePath sourceFile;
        SoftwareSystem softwareSystem;
        assert (event != null) : "Parameter 'event' of method 'mouseMove' must not be null";
        if (event.getSource() == this.getSourceWidget() && this.isSourceAvailable() && this.m_language != null && (softwareSystem = this.getSoftwareSystem()) != null && softwareSystem.isValid() && (sourceFile = this.getSourceFile()) != null && sourceFile.isValid()) {
            try {
                String lineContent;
                int mask;
                this.resetHyperlinking(true);
                int wordOffset = this.getSourceWidget().getOffsetAtPoint(new Point(event.x, event.y));
                LineInformation lineInfo = this.getLineAtOffset(wordOffset);
                int n = mask = Platform.isMac() ? 0x400000 : 262144;
                if (lineInfo != null && (event.stateMask & mask) != 0 && !(lineContent = lineInfo.getContent()).isEmpty()) {
                    int lineOffset = lineInfo.getStartOffset();
                    int wordRelativeOffset = wordOffset - lineOffset;
                    int lineNumber = this.getLineAtOffset(lineOffset).getLineNumber() + 1;
                    this.m_targetInSource = this.getLanguageProvider().getTargetInSource((IVirtualModel)softwareSystem.getCurrentModel(), sourceFile, lineContent, lineNumber, wordRelativeOffset);
                    if (this.m_targetInSource != null) {
                        if (this.m_targetInSource.getElement().getLineNumber() == -1) {
                            return;
                        }
                        int wordStartOffset = this.m_targetInSource.getStartOffset();
                        if (wordOffset >= lineOffset + wordStartOffset && wordOffset <= lineOffset + wordStartOffset + this.m_targetInSource.getIdentifier().length()) {
                            this.m_startHyperlink = lineOffset + wordStartOffset;
                            this.m_extentHyperlink = lineOffset + wordStartOffset + this.m_targetInSource.getIdentifier().length() - this.m_startHyperlink;
                            this.setHyperlinkStyle(this.m_startHyperlink, this.m_extentHyperlink, UiResourceManager.getInstance().getColor(UiResourceManager.BLUE), true);
                            this.getSourceWidget().setCursor(UiResourceManager.getInstance().getCursor(0));
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        super.mouseMove(event);
    }

    @Override
    public final void mouseUp(MouseEvent event) {
        FilePath sourceFile;
        SoftwareSystem softwareSystem;
        assert (event != null) : "Parameter 'event' of method 'mouseDown' must not be null";
        if (event.button == 1 && (event.stateMask & SWT.MOD1) != 0 && this.isSourceAvailable() && this.m_language != null && this.m_targetInSource != null && (softwareSystem = this.getSoftwareSystem()) != null && softwareSystem.isValid() && (sourceFile = this.getSourceFile()) != null && sourceFile.isValid()) {
            if (FileUtility.areEqual((TFile)this.m_targetInSource.getSourceFile().getFile(), (TFile)sourceFile.getFile())) {
                this.gotoLine(this.m_targetInSource.getElement().getLineNumber(), true);
            } else {
                ShowInViewSelectionAdapter.showInView((IWorkbenchView)this.m_workbenchView, (IViewId)ViewId.SOURCE_VIEW, (String)this.m_targetInSource.getElement().getShortName(), Collections.singletonList(this.m_targetInSource.getElement()), (boolean)false);
            }
            this.resetHyperlinking(true);
        }
    }
}

