/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.preferencepage;

import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.ISonargraphPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.PageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.swt.graphics.Image;

public final class LazyPreferenceNode
implements IPreferenceNode {
    private final IEclipseContext m_eclipseContext;
    private final PageDescriptor m_descriptor;
    private ISonargraphPreferencePage m_page;
    private List<IPreferenceNode> m_subNodes;

    public LazyPreferenceNode(IEclipseContext eclipseContext, PageDescriptor descriptor) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'LazyPreferenceNode' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'LazyPreferenceNode' must not be null";
        this.m_eclipseContext = eclipseContext;
        this.m_descriptor = descriptor;
    }

    public void add(IPreferenceNode node) {
        if (this.m_subNodes == null) {
            this.m_subNodes = new ArrayList<IPreferenceNode>();
        }
        this.m_subNodes.add(node);
    }

    public void createPage() {
        IContributionFactory factory = (IContributionFactory)this.m_eclipseContext.get(IContributionFactory.class);
        Object object = factory.create(this.m_descriptor.getClassUri(), this.m_eclipseContext);
        assert (object != null && object instanceof ISonargraphPreferencePage) : "Unexpected class in method 'createPage': " + String.valueOf(object);
        this.m_page = (ISonargraphPreferencePage)object;
        this.m_page.setTitle(this.m_descriptor.getLabel());
    }

    public void disposeResources() {
        if (this.m_page != null) {
            this.m_page.dispose();
            this.m_page = null;
        }
    }

    public IPreferenceNode findSubNode(String id) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'findSubNode' must not be empty";
        if (this.m_subNodes == null) {
            return null;
        }
        int size = this.m_subNodes.size();
        int i = 0;
        while (i < size) {
            IPreferenceNode node = this.m_subNodes.get(i);
            if (id.equals(node.getId())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public String getId() {
        return this.m_descriptor.getId();
    }

    public Image getLabelImage() {
        String image = this.m_descriptor.getImage();
        return image != null ? UiResourceManager.getInstance().getImage(image) : null;
    }

    public String getLabelText() {
        if (this.m_page != null) {
            return this.m_page.getTitle();
        }
        return this.m_descriptor.getLabel();
    }

    public IPreferencePage getPage() {
        return this.m_page;
    }

    public IPreferenceNode[] getSubNodes() {
        if (this.m_subNodes == null) {
            return new IPreferenceNode[0];
        }
        return this.m_subNodes.toArray(new IPreferenceNode[this.m_subNodes.size()]);
    }

    public IPreferenceNode remove(String id) {
        IPreferenceNode node = this.findSubNode(id);
        if (node != null) {
            this.remove(node);
        }
        return node;
    }

    public boolean remove(IPreferenceNode node) {
        if (this.m_subNodes == null) {
            return false;
        }
        return this.m_subNodes.remove(node);
    }

    public String toString() {
        return this.m_descriptor.getBundleId() + ": " + this.m_descriptor.getLabel() + " [" + (this.m_descriptor.isSoftwareSystemBased() ? "Software System" : "Installation") + "]";
    }
}

