/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.IBooleanValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingWidget;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class ValidatingCheckboxWidget<T>
extends ValidatingWidget
implements SelectionListener {
    private final IBooleanValidator<T> m_validator;
    private final IConsumer m_consumer;
    private final boolean m_currentInput;
    private final Button m_checkbox;
    private boolean m_isEnabled = true;
    private IInputProvider<T> m_inputProvider;

    public ValidatingCheckboxWidget(Composite parent, IBooleanValidator<T> validator, IInputProvider<T> inputProvider, IConsumer consumer) {
        this(parent, validator, inputProvider, consumer, false);
    }

    public ValidatingCheckboxWidget(Composite parent, IBooleanValidator<T> validator, IInputProvider<T> inputProvider, IConsumer consumer, boolean value) {
        this(parent, validator, inputProvider, consumer, value, true);
    }

    public ValidatingCheckboxWidget(Composite parent, IBooleanValidator<T> validator, IInputProvider<T> inputProvider, IConsumer consumer, boolean value, boolean validateAtCreation) {
        super(parent);
        assert (parent != null) : "Parameter 'parent' of method 'ValidatingDirectoryWidget' must not be null";
        assert (validator != null) : "Parameter 'validator' of method 'ValidatingTextWidget' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'ValidatingPathWidget' must not be null";
        this.setLayout((Layout)new FillLayout());
        this.m_validator = validator;
        this.m_inputProvider = inputProvider;
        this.m_consumer = consumer;
        this.m_currentInput = value;
        this.m_checkbox = new Button((Composite)this, 32);
        this.m_checkbox.setSelection(value);
        if (validateAtCreation) {
            this.validate(false);
        }
        this.m_checkbox.addSelectionListener((SelectionListener)this);
    }

    private void validate(boolean notifyConsumer) {
        boolean value = this.m_checkbox.getSelection();
        ValidationResult result = this.m_validator.isValid(this.m_inputProvider.getCurrentInput(), this.m_currentInput, value);
        if (this.m_isEnabled) {
            this.updateDecoration((Control)this.m_checkbox, result);
            if (notifyConsumer) {
                this.m_consumer.setSelection(result, value, result.inputModified());
            }
        }
    }

    public Button getCheckbox() {
        return this.m_checkbox;
    }

    public void clearDecoration() {
        this.clearDecoration((Control)this.m_checkbox);
    }

    public void setEnabled(boolean isEnabled) {
        this.m_checkbox.setEnabled(isEnabled);
        this.m_isEnabled = isEnabled;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.m_isEnabled) {
            this.validate(true);
        }
    }

    public void dispose() {
        this.m_checkbox.removeSelectionListener((SelectionListener)this);
        super.dispose();
    }

    public static interface IConsumer {
        public void setSelection(ValidationResult var1, boolean var2, boolean var3);
    }

    public static interface IInputProvider<T> {
        public T getCurrentInput();
    }
}

